/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.inference.external.http;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.threadpool.ThreadPool;

class RequestBasedTaskRunner {
    private final Runnable command;
    private final ThreadPool threadPool;
    private final String executorServiceName;
    private final AtomicInteger loopCount = new AtomicInteger(0);
    private final AtomicBoolean isRunning = new AtomicBoolean(true);

    RequestBasedTaskRunner(Runnable command, ThreadPool threadPool, String executorServiceName) {
        this.command = Objects.requireNonNull(command);
        this.threadPool = Objects.requireNonNull(threadPool);
        this.executorServiceName = Objects.requireNonNull(executorServiceName);
    }

    public void requestNextRun() {
        if (this.loopCount.getAndIncrement() == 0) {
            String currentThreadPool = EsExecutors.executorName((String)Thread.currentThread().getName());
            if (this.executorServiceName.equalsIgnoreCase(currentThreadPool)) {
                this.run();
            } else {
                this.threadPool.executor(this.executorServiceName).execute(this::run);
            }
        }
    }

    public void cancel() {
        this.isRunning.set(false);
    }

    private void run() {
        do {
            this.command.run();
        } while (this.isRunning.get() && this.loopCount.decrementAndGet() > 0);
    }
}

