/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.util;

import com.nimbusds.jose.util.Base64URL;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JSONObjectUtils {
    public static Map<String, Object> parse(String s) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.parse(s));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static Map<String, Object> parse(String s, int sizeLimit) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.parse(s, sizeLimit));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    @Deprecated
    public static Map<String, Object> parseJSONObject(String s) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.parseJSONObject(s));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static boolean getBoolean(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getBoolean(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static int getInt(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getInt(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static long getLong(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getLong(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static float getFloat(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> Float.valueOf(org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getFloat(o, key))).floatValue();
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static double getDouble(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getDouble(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static String getString(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getString(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static URI getURI(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getURI(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static List<Object> getJSONArray(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getJSONArray(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static String[] getStringArray(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getStringArray(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static Map<String, Object>[] getJSONObjectArray(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getJSONObjectArray(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static List<String> getStringList(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getStringList(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static Map<String, Object> getJSONObject(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getJSONObject(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static Base64URL getBase64URL(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getBase64URL(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static Date getEpochSecondAsDate(Map<String, Object> o, String key) throws ParseException {
        try {
            return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.getEpochSecondAsDate(o, key));
        }
        catch (PrivilegedActionException e) {
            throw (ParseException)e.getException();
        }
    }

    public static String toJSONString(Map<String, ?> o) {
        return AccessController.doPrivileged(() -> org.elasticsearch.nimbus.jose.util.JSONObjectUtils.toJSONString(o));
    }

    public static Map<String, Object> newJSONObject() {
        return AccessController.doPrivileged(org.elasticsearch.nimbus.jose.util.JSONObjectUtils::newJSONObject);
    }

    private JSONObjectUtils() {
    }
}

