/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.application.analytics.action;

import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestUtils;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.application.EnterpriseSearchBaseRestHandler;
import org.elasticsearch.xpack.application.analytics.action.GetAnalyticsCollectionAction;
import org.elasticsearch.xpack.application.utils.LicenseUtils;

@ServerlessScope(value=Scope.PUBLIC)
public class RestGetAnalyticsCollectionAction
extends EnterpriseSearchBaseRestHandler {
    public RestGetAnalyticsCollectionAction(XPackLicenseState licenseState) {
        super(licenseState, LicenseUtils.Product.BEHAVIORAL_ANALYTICS);
    }

    public String getName() {
        return "get_analytics_collection_action";
    }

    public List<RestHandler.Route> routes() {
        return List.of(new RestHandler.Route(RestRequest.Method.GET, "/_application/analytics/{collection_name}"), new RestHandler.Route(RestRequest.Method.GET, "/_application/analytics"));
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest restRequest, NodeClient client) {
        GetAnalyticsCollectionAction.Request request = new GetAnalyticsCollectionAction.Request(RestUtils.getMasterNodeTimeout((RestRequest)restRequest), Strings.splitStringByCommaToArray((String)restRequest.param("collection_name")));
        return channel -> client.execute(GetAnalyticsCollectionAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

