/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.kibana;

import java.util.Collection;
import java.util.List;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.SystemIndexPlugin;

public class KibanaPlugin
extends Plugin
implements SystemIndexPlugin {
    private static final List<String> KIBANA_PRODUCT_ORIGIN = List.of("kibana");
    public static final SystemIndexDescriptor KIBANA_INDEX_DESCRIPTOR = SystemIndexDescriptor.builder().setIndexPattern(".kibana_*").setDescription("Kibana saved objects system index").setAliasName(".kibana").setType(SystemIndexDescriptor.Type.EXTERNAL_UNMANAGED).setAllowedElasticProductOrigins(KIBANA_PRODUCT_ORIGIN).setAllowsTemplates().build();
    public static final SystemIndexDescriptor REPORTING_INDEX_DESCRIPTOR = SystemIndexDescriptor.builder().setIndexPattern(".reporting-*").setDescription("system index for reporting").setType(SystemIndexDescriptor.Type.EXTERNAL_UNMANAGED).setAllowedElasticProductOrigins(KIBANA_PRODUCT_ORIGIN).build();
    public static final SystemIndexDescriptor APM_AGENT_CONFIG_INDEX_DESCRIPTOR = SystemIndexDescriptor.builder().setIndexPattern(".apm-agent-configuration*").setDescription("system index for APM agent configuration").setType(SystemIndexDescriptor.Type.EXTERNAL_UNMANAGED).setAllowedElasticProductOrigins(KIBANA_PRODUCT_ORIGIN).build();
    public static final SystemIndexDescriptor APM_CUSTOM_LINK_INDEX_DESCRIPTOR = SystemIndexDescriptor.builder().setIndexPattern(".apm-custom-link*").setDescription("system index for APM custom links").setType(SystemIndexDescriptor.Type.EXTERNAL_UNMANAGED).setAllowedElasticProductOrigins(KIBANA_PRODUCT_ORIGIN).build();

    public Collection<SystemIndexDescriptor> getSystemIndexDescriptors(Settings settings) {
        return List.of(KIBANA_INDEX_DESCRIPTOR, REPORTING_INDEX_DESCRIPTOR, APM_AGENT_CONFIG_INDEX_DESCRIPTOR, APM_CUSTOM_LINK_INDEX_DESCRIPTOR);
    }

    public String getFeatureName() {
        return "kibana";
    }

    public String getFeatureDescription() {
        return "Manages Kibana configuration and reports";
    }
}

