/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.analysis.common;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.elasticsearch.analysis.common.FingerprintAnalyzer;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AbstractIndexAnalyzerProvider;
import org.elasticsearch.index.analysis.Analysis;
import org.elasticsearch.xcontent.ParseField;

public class FingerprintAnalyzerProvider
extends AbstractIndexAnalyzerProvider<Analyzer> {
    public static ParseField SEPARATOR = new ParseField("separator", new String[0]);
    public static ParseField MAX_OUTPUT_SIZE = new ParseField("max_output_size", new String[0]);
    public static int DEFAULT_MAX_OUTPUT_SIZE = 255;
    public static CharArraySet DEFAULT_STOP_WORDS = CharArraySet.EMPTY_SET;
    public static final char DEFAULT_SEPARATOR = ' ';
    private final FingerprintAnalyzer analyzer;

    FingerprintAnalyzerProvider(IndexSettings indexSettings, Environment env, String name, Settings settings) {
        super(name, settings);
        char separator = FingerprintAnalyzerProvider.parseSeparator(settings);
        int maxOutputSize = settings.getAsInt(MAX_OUTPUT_SIZE.getPreferredName(), Integer.valueOf(DEFAULT_MAX_OUTPUT_SIZE));
        CharArraySet stopWords = Analysis.parseStopWords((Environment)env, (Settings)settings, (CharArraySet)DEFAULT_STOP_WORDS);
        this.analyzer = new FingerprintAnalyzer(stopWords, separator, maxOutputSize);
    }

    public FingerprintAnalyzer get() {
        return this.analyzer;
    }

    public static char parseSeparator(Settings settings) throws IllegalArgumentException {
        String customSeparator = settings.get(SEPARATOR.getPreferredName());
        if (customSeparator == null) {
            return ' ';
        }
        if (customSeparator.length() == 1) {
            return customSeparator.charAt(0);
        }
        throw new IllegalArgumentException("Setting [separator] must be a single, non-null character. [" + customSeparator + "] was provided.");
    }
}

