/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ssl;

import java.nio.file.Path;
import java.security.KeyStore;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.ssl.SslClientAuthenticationMode;
import org.elasticsearch.common.ssl.SslConfigException;
import org.elasticsearch.common.ssl.SslConfiguration;
import org.elasticsearch.common.ssl.SslConfigurationLoader;
import org.elasticsearch.common.ssl.SslKeyConfig;
import org.elasticsearch.common.ssl.SslTrustConfig;
import org.elasticsearch.common.ssl.SslVerificationMode;
import org.elasticsearch.common.ssl.X509Field;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.env.Environment;
import org.elasticsearch.xpack.core.ssl.RestrictedTrustConfig;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;

public final class SslSettingsLoader
extends SslConfigurationLoader {
    private final Settings settings;
    private final Map<String, Setting<? extends SecureString>> secureSettings;
    private final Map<String, Setting<?>> standardSettings;
    private final Map<String, Setting<?>> disabledSettings;

    public SslSettingsLoader(Settings settings, String settingPrefix, boolean acceptNonSecurePasswords) {
        super(settingPrefix);
        this.settings = settings;
        SSLConfigurationSettings sslConfigurationSettings = settingPrefix == null ? SSLConfigurationSettings.withoutPrefix(acceptNonSecurePasswords) : SSLConfigurationSettings.withPrefix(settingPrefix, acceptNonSecurePasswords);
        this.secureSettings = SslSettingsLoader.mapOf(sslConfigurationSettings.getSecureSettings());
        this.standardSettings = SslSettingsLoader.mapOf(sslConfigurationSettings.getEnabledSettings());
        this.disabledSettings = SslSettingsLoader.mapOf(sslConfigurationSettings.getDisabledSettings());
        this.setDefaultClientAuth(SslClientAuthenticationMode.REQUIRED);
    }

    private static <T> Map<String, Setting<? extends T>> mapOf(List<Setting<? extends T>> settingList) {
        return settingList.stream().collect(Collectors.toMap(Setting::getKey, Function.identity()));
    }

    protected boolean hasSettings(String prefix) {
        Settings group = this.settings;
        if (Strings.hasLength((String)prefix)) {
            if (prefix.endsWith(".")) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            group = this.settings.getAsSettings(prefix);
        }
        return !group.isEmpty();
    }

    protected String getSettingAsString(String key) {
        this.checkSetting(key);
        String val = this.settings.get(key);
        return val == null ? "" : val;
    }

    protected List<String> getSettingAsList(String key) throws Exception {
        this.checkSetting(key);
        return this.settings.getAsList(key);
    }

    private void checkSetting(String key) {
        Setting<?> setting = this.standardSettings.get(key);
        if (setting != null) {
            setting.get(this.settings);
        } else if (!this.disabledSettings.containsKey(key)) {
            throw new SslConfigException("The setting [" + key + "] is not supported, valid SSL settings are: [" + Strings.collectionToCommaDelimitedString(this.standardSettings.keySet()) + "]");
        }
    }

    protected char[] getSecureSetting(String key) {
        Setting<? extends SecureString> setting = this.secureSettings.get(key);
        if (setting == null) {
            throw new SslConfigException("The secure setting [" + key + "] is not supported, valid secure SSL settings are: [" + Strings.collectionToCommaDelimitedString(this.secureSettings.keySet()) + "]");
        }
        return setting.exists(this.settings) ? ((SecureString)setting.get(this.settings)).getChars() : null;
    }

    protected SslTrustConfig buildTrustConfig(Path basePath, SslVerificationMode verificationMode, SslKeyConfig keyConfig, Set<X509Field> restrictedTrustFields) {
        SslTrustConfig trustConfig = super.buildTrustConfig(basePath, verificationMode, keyConfig, null);
        Path trustRestrictions = super.resolvePath("trust_restrictions.path", basePath);
        if (trustRestrictions == null) {
            return trustConfig;
        }
        return new RestrictedTrustConfig(trustRestrictions, restrictedTrustFields, trustConfig);
    }

    public SslConfiguration load(Environment env) {
        return this.load(env.configFile());
    }

    public static SslConfiguration load(Settings settings, String prefix, Environment env) {
        return SslSettingsLoader.load(settings, prefix, env, null);
    }

    public static SslConfiguration load(Settings settings, String prefix, Environment env, @Nullable Function<KeyStore, KeyStore> keyStoreFilter) {
        SslSettingsLoader settingsLoader = new SslSettingsLoader(settings, prefix, true);
        settingsLoader.setKeyStoreFilter(keyStoreFilter);
        return settingsLoader.load(env);
    }
}

