/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils.time;

import java.time.DateTimeException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.Locale;
import org.elasticsearch.core.SuppressForbidden;
import org.elasticsearch.xpack.core.ml.utils.time.TimestampConverter;

public class DateTimeFormatterTimestampConverter
implements TimestampConverter {
    private final DateTimeFormatter formatter;
    private final boolean hasTimeZone;
    private final ZoneId defaultZoneId;

    private DateTimeFormatterTimestampConverter(DateTimeFormatter dateTimeFormatter, boolean hasTimeZone, ZoneId defaultTimezone) {
        this.formatter = dateTimeFormatter;
        this.hasTimeZone = hasTimeZone;
        this.defaultZoneId = defaultTimezone;
    }

    public static TimestampConverter ofPattern(String pattern, ZoneId defaultTimezone) {
        DateTimeFormatter formatter = new DateTimeFormatterBuilder().parseLenient().appendPattern(pattern).parseDefaulting(ChronoField.YEAR_OF_ERA, LocalDate.now(defaultTimezone).getYear()).toFormatter(Locale.ROOT);
        String formattedTime = formatter.format(ZonedDateTime.ofInstant(Instant.ofEpochSecond(0L), ZoneOffset.UTC));
        try {
            TemporalAccessor parsed = formatter.parse(formattedTime);
            boolean hasTimeZone = parsed.isSupported(ChronoField.INSTANT_SECONDS);
            if (hasTimeZone) {
                Instant.from(parsed);
            } else {
                LocalDateTime.from(parsed);
            }
            return new DateTimeFormatterTimestampConverter(formatter, hasTimeZone, defaultTimezone);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException("Timestamp cannot be derived from pattern: " + pattern, e);
        }
    }

    @Override
    public long toEpochSeconds(String timestamp) {
        return this.toInstant(timestamp).getEpochSecond();
    }

    @Override
    public long toEpochMillis(String timestamp) {
        return this.toInstant(timestamp).toEpochMilli();
    }

    private Instant toInstant(String timestamp) {
        TemporalAccessor parsed = this.formatter.parse(timestamp);
        if (this.hasTimeZone) {
            return Instant.from(parsed);
        }
        return this.toInstantUnsafelyIgnoringAmbiguity(parsed);
    }

    @SuppressForbidden(reason="TODO https://github.com/elastic/x-pack-elasticsearch/issues/3810")
    private Instant toInstantUnsafelyIgnoringAmbiguity(TemporalAccessor parsed) {
        return LocalDateTime.from(parsed).atZone(this.defaultZoneId).toInstant();
    }
}

