/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.regex.Regex;

public final class MlStrings {
    private static final Pattern NEEDS_QUOTING = Pattern.compile("\\W");
    private static final Pattern VALID_ID_CHAR_PATTERN = Pattern.compile("[a-z0-9](?:[a-z0-9_\\-\\.]*[a-z0-9])?");
    public static final int ID_LENGTH_LIMIT = 64;

    private MlStrings() {
    }

    public static String doubleQuoteIfNotAlphaNumeric(String input) {
        if (!NEEDS_QUOTING.matcher(input).find()) {
            return input;
        }
        StringBuilder quoted = new StringBuilder();
        quoted.append('\"');
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\"' || c == '\\') {
                quoted.append('\\');
            }
            quoted.append(c);
        }
        quoted.append('\"');
        return quoted.toString();
    }

    public static boolean isValidId(String id) {
        return id != null && VALID_ID_CHAR_PATTERN.matcher(id).matches() && !"_all".equals(id);
    }

    public static boolean hasValidLengthForId(String id) {
        return id.length() <= 64;
    }

    public static String getParentField(String fieldPath) {
        if (fieldPath == null) {
            return fieldPath;
        }
        int lastIndexOfDot = fieldPath.lastIndexOf(46);
        if (lastIndexOfDot < 0) {
            return fieldPath;
        }
        return fieldPath.substring(0, lastIndexOfDot);
    }

    public static Set<String> findMatching(String[] patterns, Set<String> items) {
        if (items.isEmpty()) {
            return Collections.emptySet();
        }
        if (Strings.isAllOrWildcard((String[])patterns)) {
            return items;
        }
        LinkedHashSet<String> matchingItems = new LinkedHashSet<String>();
        for (String pattern : patterns) {
            if (items.contains(pattern)) {
                matchingItems.add(pattern);
                continue;
            }
            if (!Regex.isSimpleMatchPattern((String)pattern)) continue;
            for (String item : items) {
                if (!Regex.simpleMatch((String)pattern, (String)item)) continue;
                matchingItems.add(item);
            }
        }
        return matchingItems;
    }
}

