/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.process.autodetect.state;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ModelState {
    public static final String TYPE = "model_state";
    private static final Pattern V_5_4_DOC_ID_SUFFIX_REGEX = Pattern.compile("^\\d{10}#\\d+$");

    public static String documentId(String jobId, String snapshotId, int docNum) {
        return jobId + "_model_state_" + snapshotId + "#" + docNum;
    }

    public static String extractJobId(String docId) {
        int suffixIndex = docId.lastIndexOf("_model_state_");
        return suffixIndex <= 0 ? ModelState.v54ExtractJobId(docId) : docId.substring(0, suffixIndex);
    }

    private static String v54ExtractJobId(String docId) {
        int potentialSuffixIndex = docId.lastIndexOf(45);
        if (potentialSuffixIndex <= 0 || potentialSuffixIndex >= docId.length() - 1) {
            return null;
        }
        Matcher matcher = V_5_4_DOC_ID_SUFFIX_REGEX.matcher(docId.subSequence(potentialSuffixIndex + 1, docId.length()));
        if (matcher.matches()) {
            return docId.substring(0, potentialSuffixIndex);
        }
        return null;
    }

    private ModelState() {
    }
}

