/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.VersionId;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.action.CreateTrainedModelAssignmentAction;
import org.elasticsearch.xpack.core.ml.action.StartTrainedModelDeploymentAction;
import org.elasticsearch.xpack.core.ml.inference.assignment.AdaptiveAllocationsSettings;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class UpdateTrainedModelDeploymentAction
extends ActionType<CreateTrainedModelAssignmentAction.Response> {
    public static final UpdateTrainedModelDeploymentAction INSTANCE = new UpdateTrainedModelDeploymentAction();
    public static final String NAME = "cluster:admin/xpack/ml/trained_models/deployment/update";

    public UpdateTrainedModelDeploymentAction() {
        super(NAME);
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        public static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:admin/xpack/ml/trained_models/deployment/update", Request::new);
        public static final ParseField TIMEOUT = new ParseField("timeout", new String[0]);
        private String deploymentId;
        private Integer numberOfAllocations;
        private AdaptiveAllocationsSettings adaptiveAllocationsSettings;
        private boolean isInternal;

        public static Request parseRequest(String deploymentId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (request.getDeploymentId() == null) {
                request.setDeploymentId(deploymentId);
            } else if (!Strings.isNullOrEmpty((String)deploymentId) && !deploymentId.equals(request.getDeploymentId())) {
                throw ExceptionsHelper.badRequestException(Messages.getMessage("Inconsistent {0}; ''{1}'' specified in the body differs from ''{2}'' specified as a URL argument", StartTrainedModelDeploymentAction.Request.MODEL_ID, request.getDeploymentId(), deploymentId), new Object[0]);
            }
            return request;
        }

        private Request() {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
        }

        public Request(String deploymentId) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.setDeploymentId(deploymentId);
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.deploymentId = in.readString();
            if (in.getTransportVersion().before((VersionId)TransportVersions.INFERENCE_ADAPTIVE_ALLOCATIONS)) {
                this.numberOfAllocations = in.readVInt();
                this.adaptiveAllocationsSettings = null;
                this.isInternal = false;
            } else {
                this.numberOfAllocations = in.readOptionalVInt();
                this.adaptiveAllocationsSettings = (AdaptiveAllocationsSettings)in.readOptionalWriteable(AdaptiveAllocationsSettings::new);
                this.isInternal = in.readBoolean();
            }
        }

        public final void setDeploymentId(String deploymentId) {
            this.deploymentId = ExceptionsHelper.requireNonNull(deploymentId, StartTrainedModelDeploymentAction.Request.MODEL_ID);
        }

        public String getDeploymentId() {
            return this.deploymentId;
        }

        public void setNumberOfAllocations(Integer numberOfAllocations) {
            this.numberOfAllocations = numberOfAllocations;
        }

        public Integer getNumberOfAllocations() {
            return this.numberOfAllocations;
        }

        public void setAdaptiveAllocationsSettings(AdaptiveAllocationsSettings adaptiveAllocationsSettings) {
            this.adaptiveAllocationsSettings = adaptiveAllocationsSettings;
        }

        public boolean isInternal() {
            return this.isInternal;
        }

        public void setIsInternal(boolean isInternal) {
            this.isInternal = isInternal;
        }

        public AdaptiveAllocationsSettings getAdaptiveAllocationsSettings() {
            return this.adaptiveAllocationsSettings;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.deploymentId);
            if (out.getTransportVersion().before((VersionId)TransportVersions.INFERENCE_ADAPTIVE_ALLOCATIONS)) {
                out.writeVInt(this.numberOfAllocations.intValue());
            } else {
                out.writeOptionalVInt(this.numberOfAllocations);
                out.writeOptionalWriteable((Writeable)this.adaptiveAllocationsSettings);
                out.writeBoolean(this.isInternal);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(StartTrainedModelDeploymentAction.Request.MODEL_ID.getPreferredName(), this.deploymentId);
            if (this.numberOfAllocations != null) {
                builder.field(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS.getPreferredName(), this.numberOfAllocations);
            }
            if (this.adaptiveAllocationsSettings != null) {
                builder.field(StartTrainedModelDeploymentAction.Request.ADAPTIVE_ALLOCATIONS.getPreferredName(), (ToXContent)this.adaptiveAllocationsSettings);
            }
            builder.endObject();
            return builder;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException autoscaleException;
            ActionRequestValidationException validationException = new ActionRequestValidationException();
            if (this.numberOfAllocations != null) {
                if (this.numberOfAllocations < 0 || !this.isInternal && this.numberOfAllocations == 0) {
                    validationException.addValidationError("[" + String.valueOf(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS) + "] must be a positive integer");
                }
                if (!this.isInternal && this.adaptiveAllocationsSettings != null && this.adaptiveAllocationsSettings.getEnabled() == Boolean.TRUE) {
                    validationException.addValidationError("[" + String.valueOf(StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS) + "] cannot be set if adaptive allocations is enabled");
                }
            }
            ActionRequestValidationException actionRequestValidationException = autoscaleException = this.adaptiveAllocationsSettings == null ? null : this.adaptiveAllocationsSettings.validate();
            if (autoscaleException != null) {
                validationException.addValidationErrors((Iterable)autoscaleException.validationErrors());
            }
            return validationException.validationErrors().isEmpty() ? null : validationException;
        }

        public int hashCode() {
            return Objects.hash(this.deploymentId, this.numberOfAllocations, this.adaptiveAllocationsSettings, this.isInternal);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.deploymentId, other.deploymentId) && Objects.equals(this.numberOfAllocations, other.numberOfAllocations) && Objects.equals(this.adaptiveAllocationsSettings, other.adaptiveAllocationsSettings) && this.isInternal == other.isInternal;
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(Request::setDeploymentId, StartTrainedModelDeploymentAction.Request.MODEL_ID);
            PARSER.declareInt(Request::setNumberOfAllocations, StartTrainedModelDeploymentAction.Request.NUMBER_OF_ALLOCATIONS);
            PARSER.declareObjectOrNull(Request::setAdaptiveAllocationsSettings, (p, c) -> ((AdaptiveAllocationsSettings.Builder)AdaptiveAllocationsSettings.PARSER.parse(p, c)).build(), (Object)AdaptiveAllocationsSettings.RESET_PLACEHOLDER, StartTrainedModelDeploymentAction.Request.ADAPTIVE_ALLOCATIONS);
            PARSER.declareString((r, val) -> r.ackTimeout(TimeValue.parseTimeValue((String)val, (String)TIMEOUT.getPreferredName())), TIMEOUT);
        }
    }
}

