/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.time.Instant;
import java.util.Locale;
import java.util.function.Supplier;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexMode;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.xpack.core.ilm.AsyncWaitStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.step.info.EmptyInfo;
import org.elasticsearch.xpack.core.ilm.step.info.SingleMessageFieldInfo;

public class WaitUntilTimeSeriesEndTimePassesStep
extends AsyncWaitStep {
    public static final String NAME = "check-ts-end-time-passed";
    private final Supplier<Instant> nowSupplier;

    public WaitUntilTimeSeriesEndTimePassesStep(Step.StepKey key, Step.StepKey nextStepKey, Supplier<Instant> nowSupplier, Client client) {
        super(key, nextStepKey, client);
        this.nowSupplier = nowSupplier;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void evaluateCondition(Metadata metadata, Index index, AsyncWaitStep.Listener listener, TimeValue masterTimeout) {
        IndexMetadata indexMetadata = metadata.index(index);
        assert (indexMetadata != null) : "the index metadata for index [" + index.getName() + "] must exist in the cluster state for step [check-ts-end-time-passed]";
        if (IndexSettings.MODE.get(indexMetadata.getSettings()) != IndexMode.TIME_SERIES) {
            listener.onResponse(true, EmptyInfo.INSTANCE);
            return;
        }
        Instant configuredEndTime = (Instant)IndexSettings.TIME_SERIES_END_TIME.get(indexMetadata.getSettings());
        assert (configuredEndTime != null) : "a time series index must have an end time configured but [" + index.getName() + "] does not";
        if (this.nowSupplier.get().isBefore(configuredEndTime)) {
            listener.onResponse(false, new SingleMessageFieldInfo(String.format(Locale.ROOT, "The [%s] setting for index [%s] is [%s]. Waiting until the index's time series end time lapses before proceeding with action [%s] as the index can still accept writes.", IndexSettings.TIME_SERIES_END_TIME.getKey(), index.getName(), configuredEndTime.toEpochMilli(), this.getKey().action())));
            return;
        }
        listener.onResponse(true, EmptyInfo.INSTANCE);
    }
}

