/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.LifecycleExecutionState;
import org.elasticsearch.cluster.routing.allocation.decider.ShardsLimitAllocationDecider;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.SearchableSnapshotAction;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotAction;
import org.elasticsearch.xpack.core.searchablesnapshots.MountSearchableSnapshotRequest;

public class MountSnapshotStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "mount-snapshot";
    private static final Logger logger = LogManager.getLogger(MountSnapshotStep.class);
    private final String restoredIndexPrefix;
    private final MountSearchableSnapshotRequest.Storage storageType;
    @Nullable
    private final Integer totalShardsPerNode;

    public MountSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String restoredIndexPrefix, MountSearchableSnapshotRequest.Storage storageType, @Nullable Integer totalShardsPerNode) {
        super(key, nextStepKey, client);
        this.restoredIndexPrefix = restoredIndexPrefix;
        this.storageType = Objects.requireNonNull(storageType, "a storage type must be specified");
        if (totalShardsPerNode != null && totalShardsPerNode < 1) {
            throw new IllegalArgumentException("[" + SearchableSnapshotAction.TOTAL_SHARDS_PER_NODE.getPreferredName() + "] must be >= 1");
        }
        this.totalShardsPerNode = totalShardsPerNode;
    }

    public MountSnapshotStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String restoredIndexPrefix, MountSearchableSnapshotRequest.Storage storageType) {
        this(key, nextStepKey, client, restoredIndexPrefix, storageType, null);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public String getRestoredIndexPrefix() {
        return this.restoredIndexPrefix;
    }

    public MountSearchableSnapshotRequest.Storage getStorage() {
        return this.storageType;
    }

    @Nullable
    public Integer getTotalShardsPerNode() {
        return this.totalShardsPerNode;
    }

    @Override
    void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentClusterState, ActionListener<Void> listener) {
        String snapshotName;
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = indexMetadata.getLifecycleExecutionState();
        SearchableSnapshotAction.SearchableSnapshotMetadata searchableSnapshotMetadata = SearchableSnapshotAction.extractSearchableSnapshotFromSettings(indexMetadata);
        String policyName = indexMetadata.getLifecyclePolicyName();
        String snapshotRepository = lifecycleState.snapshotRepository();
        if (!Strings.hasText((String)snapshotRepository)) {
            if (searchableSnapshotMetadata == null) {
                listener.onFailure((Exception)new IllegalStateException("snapshot repository is not present for policy [" + policyName + "] and index [" + indexName + "]"));
                return;
            }
            snapshotRepository = searchableSnapshotMetadata.repositoryName();
        }
        if (!Strings.hasText((String)(snapshotName = lifecycleState.snapshotName())) && searchableSnapshotMetadata == null) {
            listener.onFailure((Exception)new IllegalStateException("snapshot name was not generated for policy [" + policyName + "] and index [" + indexName + "]"));
            return;
        }
        if (searchableSnapshotMetadata != null) {
            snapshotName = searchableSnapshotMetadata.snapshotName();
        }
        String mountedIndexName = this.restoredIndexPrefix + indexName;
        if (currentClusterState.metadata().index(mountedIndexName) != null) {
            logger.debug("mounted index [{}] for policy [{}] and index [{}] already exists. will not attempt to mount the index again", (Object)mountedIndexName, (Object)policyName, (Object)indexName);
            listener.onResponse(null);
            return;
        }
        String snapshotIndexName = lifecycleState.snapshotIndexName();
        if (snapshotIndexName == null) {
            if (searchableSnapshotMetadata == null) {
                indexName = MountSnapshotStep.bestEffortIndexNameResolution(indexName);
                logger.debug("index [{}] using policy [{}] does not have a stored snapshot index name, using our best effort guess of [{}] for the original snapshotted index name", (Object)indexMetadata.getIndex().getName(), (Object)policyName, (Object)indexName);
            } else {
                indexName = searchableSnapshotMetadata.sourceIndex();
            }
        } else {
            logger.debug("index [{}] using policy [{}] has a different name [{}] within the snapshot to be restored, using the snapshot index name from generated metadata for mounting", (Object)indexName, (Object)policyName, (Object)snapshotIndexName);
            indexName = snapshotIndexName;
        }
        Settings.Builder settingsBuilder = Settings.builder();
        MountSnapshotStep.overrideTierPreference(this.getKey().phase()).ifPresent(override -> settingsBuilder.put("index.routing.allocation.include._tier_preference", override));
        if (this.totalShardsPerNode != null) {
            settingsBuilder.put(ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey(), this.totalShardsPerNode.intValue());
        }
        MountSearchableSnapshotRequest mountSearchableSnapshotRequest = new MountSearchableSnapshotRequest(TimeValue.MAX_VALUE, mountedIndexName, snapshotRepository, snapshotName, indexName, settingsBuilder.build(), this.ignoredIndexSettings(), false, this.storageType);
        this.getClient().execute((ActionType)MountSearchableSnapshotAction.INSTANCE, (ActionRequest)mountSearchableSnapshotRequest, listener.delegateFailureAndWrap((l, response) -> {
            if (response.status() != RestStatus.OK && response.status() != RestStatus.ACCEPTED) {
                logger.debug("mount snapshot response failed to complete");
                throw new ElasticsearchException("mount snapshot response failed to complete, got response " + String.valueOf(response.status()), new Object[0]);
            }
            l.onResponse(null);
        }));
    }

    static String bestEffortIndexNameResolution(String indexName) {
        String originalName = indexName.replaceFirst("^partial-", "");
        originalName = originalName.replaceFirst("^restored-", "");
        return originalName;
    }

    static Optional<String> overrideTierPreference(String phase) {
        if ("hot".equals(phase)) {
            return Optional.of("data_hot");
        }
        return Optional.empty();
    }

    String[] ignoredIndexSettings() {
        ArrayList<String> ignoredSettings = new ArrayList<String>();
        ignoredSettings.add("index.lifecycle.name");
        if ("frozen".equals(this.getKey().phase()) && this.totalShardsPerNode == null) {
            ignoredSettings.add(ShardsLimitAllocationDecider.INDEX_TOTAL_SHARDS_PER_NODE_SETTING.getKey());
        }
        return ignoredSettings.toArray(new String[0]);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.restoredIndexPrefix, this.storageType, this.totalShardsPerNode});
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MountSnapshotStep other = (MountSnapshotStep)obj;
        return super.equals(obj) && Objects.equals(this.restoredIndexPrefix, other.restoredIndexPrefix) && Objects.equals((Object)this.storageType, (Object)other.storageType) && Objects.equals(this.totalShardsPerNode, other.totalShardsPerNode);
    }
}

