/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.PostStartBasicRequest;
import org.elasticsearch.license.PostStartBasicResponse;
import org.elasticsearch.license.internal.MutableLicenseService;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportPostStartBasicAction
extends TransportMasterNodeAction<PostStartBasicRequest, PostStartBasicResponse> {
    private final MutableLicenseService licenseService;

    @Inject
    public TransportPostStartBasicAction(TransportService transportService, ClusterService clusterService, MutableLicenseService licenseService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/license/start_basic", transportService, clusterService, threadPool, actionFilters, PostStartBasicRequest::new, indexNameExpressionResolver, PostStartBasicResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseService = licenseService;
    }

    protected void masterOperation(Task task, PostStartBasicRequest request, ClusterState state, ActionListener<PostStartBasicResponse> listener) throws Exception {
        this.licenseService.startBasicLicense(request, listener);
    }

    protected ClusterBlockException checkBlock(PostStartBasicRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }
}

