/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.concurrent.Executor;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.ClusterStateLicenseService;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.license.LicenseService;
import org.elasticsearch.protocol.xpack.license.GetLicenseRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetLicenseAction
extends TransportMasterNodeReadAction<GetLicenseRequest, GetLicenseResponse> {
    private final LicenseService licenseService;

    @Inject
    public TransportGetLicenseAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, LicenseService licenseService) {
        super("cluster:monitor/xpack/license/get", transportService, clusterService, threadPool, actionFilters, GetLicenseRequest::new, indexNameExpressionResolver, GetLicenseResponse::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseService = licenseService;
    }

    protected ClusterBlockException checkBlock(GetLicenseRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    protected void masterOperation(Task task, GetLicenseRequest request, ClusterState state, ActionListener<GetLicenseResponse> listener) throws ElasticsearchException {
        LicenseService licenseService = this.licenseService;
        if (licenseService instanceof ClusterStateLicenseService) {
            ClusterStateLicenseService clusterStateLicenseService = (ClusterStateLicenseService)licenseService;
            listener.onResponse((Object)new GetLicenseResponse(clusterStateLicenseService.getLicense(state.metadata())));
        } else {
            listener.onResponse((Object)new GetLicenseResponse(this.licenseService.getLicense()));
        }
    }
}

