/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.results;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.Scope;
import org.elasticsearch.rest.ServerlessScope;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetInfluencersAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;

@ServerlessScope(value=Scope.INTERNAL)
public class RestGetInfluencersAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return List.of(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/results/influencers")).replaces(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/results/influencers", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/results/influencers")).replaces(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + String.valueOf(Job.ID) + "}/results/influencers", RestApiVersion.V_7).build());
    }

    public String getName() {
        return "ml_get_influencers_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetInfluencersAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String start = restRequest.param(GetInfluencersAction.Request.START.getPreferredName());
        String end = restRequest.param(GetInfluencersAction.Request.END.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = GetInfluencersAction.Request.parseRequest((String)jobId, (XContentParser)parser);
        } else {
            request = new GetInfluencersAction.Request(jobId);
            request.setStart(start);
            request.setEnd(end);
            request.setExcludeInterim(restRequest.paramAsBoolean(GetInfluencersAction.Request.EXCLUDE_INTERIM.getPreferredName(), request.isExcludeInterim()));
            request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            request.setInfluencerScore(Double.parseDouble(restRequest.param(GetInfluencersAction.Request.INFLUENCER_SCORE.getPreferredName(), String.valueOf(request.getInfluencerScore()))));
            request.setSort(restRequest.param(GetInfluencersAction.Request.SORT_FIELD.getPreferredName(), request.getSort()));
            request.setDescending(restRequest.paramAsBoolean(GetInfluencersAction.Request.DESCENDING_SORT.getPreferredName(), request.isDescending()));
        }
        return channel -> client.execute((ActionType)GetInfluencersAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

