/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.job.persistence;

import java.util.Objects;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.TimingStats;
import org.elasticsearch.xpack.core.ml.job.results.Bucket;
import org.elasticsearch.xpack.ml.job.persistence.JobResultsPersister;

public class TimingStatsReporter {
    private TimingStats persistedTimingStats;
    private volatile TimingStats currentTimingStats;
    private final JobResultsPersister.Builder bulkResultsPersister;
    private static final double MIN_VALID_RATIO = 0.9;

    public TimingStatsReporter(TimingStats timingStats, JobResultsPersister.Builder jobResultsPersister) {
        Objects.requireNonNull(timingStats);
        this.persistedTimingStats = new TimingStats(timingStats);
        this.currentTimingStats = new TimingStats(timingStats);
        this.bulkResultsPersister = Objects.requireNonNull(jobResultsPersister);
    }

    public TimingStats getCurrentTimingStats() {
        return new TimingStats(this.currentTimingStats);
    }

    public void reportBucket(Bucket bucket) {
        this.currentTimingStats.updateStats((double)bucket.getProcessingTimeMs());
        this.currentTimingStats.setLatestRecordTimestamp(bucket.getTimestamp().toInstant().plusSeconds(bucket.getBucketSpan()));
        if (TimingStatsReporter.differSignificantly(this.currentTimingStats, this.persistedTimingStats)) {
            this.flush();
        }
    }

    public void finishReporting() {
        if (this.currentTimingStats.equals((Object)this.persistedTimingStats)) {
            return;
        }
        this.flush();
    }

    private void flush() {
        this.persistedTimingStats = new TimingStats(this.currentTimingStats);
        this.bulkResultsPersister.persistTimingStats(this.persistedTimingStats);
    }

    public static boolean differSignificantly(TimingStats stats1, TimingStats stats2) {
        return TimingStatsReporter.differSignificantly(stats1.getMinBucketProcessingTimeMs(), stats2.getMinBucketProcessingTimeMs()) || TimingStatsReporter.differSignificantly(stats1.getMaxBucketProcessingTimeMs(), stats2.getMaxBucketProcessingTimeMs()) || TimingStatsReporter.differSignificantly(stats1.getAvgBucketProcessingTimeMs(), stats2.getAvgBucketProcessingTimeMs()) || TimingStatsReporter.differSignificantly(stats1.getExponentialAvgBucketProcessingTimeMs(), stats2.getExponentialAvgBucketProcessingTimeMs());
    }

    static boolean differSignificantly(Double value1, Double value2) {
        if (value1 != null && value2 != null) {
            return value2 / value1 < 0.9 || value1 / value2 < 0.9;
        }
        return value1 != null || value2 != null;
    }
}

