/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.util.concurrent.Executor;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningField;
import org.elasticsearch.xpack.core.ml.action.PutDatafeedAction;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.ml.datafeed.DatafeedManager;

public class TransportPutDatafeedAction
extends TransportMasterNodeAction<PutDatafeedAction.Request, PutDatafeedAction.Response> {
    private final XPackLicenseState licenseState;
    private final SecurityContext securityContext;
    private final DatafeedManager datafeedManager;

    @Inject
    public TransportPutDatafeedAction(Settings settings, TransportService transportService, ClusterService clusterService, ThreadPool threadPool, XPackLicenseState licenseState, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, DatafeedManager datafeedManager) {
        super("cluster:admin/xpack/ml/datafeeds/put", transportService, clusterService, threadPool, actionFilters, PutDatafeedAction.Request::new, indexNameExpressionResolver, PutDatafeedAction.Response::new, (Executor)EsExecutors.DIRECT_EXECUTOR_SERVICE);
        this.licenseState = licenseState;
        this.securityContext = (Boolean)XPackSettings.SECURITY_ENABLED.get(settings) != false ? new SecurityContext(settings, threadPool.getThreadContext()) : null;
        this.datafeedManager = datafeedManager;
    }

    protected void masterOperation(Task task, PutDatafeedAction.Request request, ClusterState state, ActionListener<PutDatafeedAction.Response> listener) {
        this.datafeedManager.putDatafeed(request, state, this.securityContext, this.threadPool, listener);
    }

    protected ClusterBlockException checkBlock(PutDatafeedAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    protected void doExecute(Task task, PutDatafeedAction.Request request, ActionListener<PutDatafeedAction.Response> listener) {
        if (MachineLearningField.ML_API_FEATURE.check(this.licenseState)) {
            super.doExecute(task, (MasterNodeRequest)request, listener);
        } else {
            listener.onFailure((Exception)LicenseUtils.newComplianceException((String)"ml"));
        }
    }
}

