/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.querydsl.container;

import org.elasticsearch.search.aggregations.bucket.composite.MissingOrder;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.ql.expression.Order;

public abstract class Sort {
    private final Direction direction;
    private final Missing missing;

    protected Sort(Direction direction, Missing nulls) {
        this.direction = direction;
        this.missing = nulls;
    }

    public Direction direction() {
        return this.direction;
    }

    public Missing missing() {
        return this.missing;
    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction from(Order.OrderDirection dir) {
            return dir == null || dir == Order.OrderDirection.ASC ? ASC : DESC;
        }

        public SortOrder asOrder() {
            return this == ASC ? SortOrder.ASC : SortOrder.DESC;
        }
    }

    public static enum Missing {
        FIRST("_first", MissingOrder.FIRST),
        LAST("_last", MissingOrder.LAST),
        ANY(null, null);

        private final String searchOrder;
        private final MissingOrder aggregationOrder;

        private Missing(String searchOrder, MissingOrder aggregationOrder) {
            this.searchOrder = searchOrder;
            this.aggregationOrder = aggregationOrder;
        }

        public static Missing from(Order.NullsPosition pos) {
            return switch (pos) {
                case Order.NullsPosition.FIRST -> FIRST;
                case Order.NullsPosition.LAST -> LAST;
                default -> ANY;
            };
        }

        public String searchOrder() {
            return this.searchOrder(null);
        }

        public String searchOrder(Direction fallbackDirection) {
            if (this.searchOrder != null) {
                return this.searchOrder;
            }
            return switch (fallbackDirection) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.ASC -> Missing.LAST.searchOrder;
                case Direction.DESC -> Missing.FIRST.searchOrder;
            };
        }

        public MissingOrder aggregationOrder() {
            return this.aggregationOrder;
        }
    }
}

