/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.phase;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.core.Strings;
import org.elasticsearch.painless.lookup.PainlessLookup;
import org.elasticsearch.painless.node.SClass;
import org.elasticsearch.painless.node.SFunction;
import org.elasticsearch.painless.phase.UserTreeBaseVisitor;
import org.elasticsearch.painless.symbol.FunctionTable;
import org.elasticsearch.painless.symbol.ScriptScope;

public class DefaultSemanticHeaderPhase
extends UserTreeBaseVisitor<ScriptScope> {
    @Override
    public void visitClass(SClass userClassNode, ScriptScope scriptScope) {
        for (SFunction userFunctionNode : userClassNode.getFunctionNodes()) {
            this.visitFunction(userFunctionNode, scriptScope);
        }
    }

    @Override
    public void visitFunction(SFunction userFunctionNode, ScriptScope scriptScope) {
        String returnCanonicalTypeName;
        String functionKey;
        String functionName = userFunctionNode.getFunctionName();
        List<String> canonicalTypeNameParameters = userFunctionNode.getCanonicalTypeNameParameters();
        List<String> parameterNames = userFunctionNode.getParameterNames();
        int parameterCount = canonicalTypeNameParameters.size();
        if (parameterCount != parameterNames.size()) {
            throw userFunctionNode.createError(new IllegalStateException(Strings.format((String)"invalid function definition: parameter types size [%d] is not equal to parameter names size [%d] for function [%s]", (Object[])new Object[]{canonicalTypeNameParameters.size(), parameterNames.size(), functionName})));
        }
        FunctionTable functionTable = scriptScope.getFunctionTable();
        if (functionTable.getFunction(functionKey = FunctionTable.buildLocalFunctionKey(functionName, canonicalTypeNameParameters.size())) != null) {
            throw userFunctionNode.createError(new IllegalArgumentException("invalid function definition: found duplicate function [" + functionKey + "]."));
        }
        PainlessLookup painlessLookup = scriptScope.getPainlessLookup();
        Class<?> returnType = painlessLookup.canonicalTypeNameToType(returnCanonicalTypeName = userFunctionNode.getReturnCanonicalTypeName());
        if (returnType == null) {
            throw userFunctionNode.createError(new IllegalArgumentException(Strings.format((String)"invalid function definition: return type [%s] not found for function [%s]", (Object[])new Object[]{returnCanonicalTypeName, functionKey})));
        }
        ArrayList typeParameters = new ArrayList();
        for (String typeParameter : canonicalTypeNameParameters) {
            Class<?> paramType = painlessLookup.canonicalTypeNameToType(typeParameter);
            if (paramType == null) {
                throw userFunctionNode.createError(new IllegalArgumentException(Strings.format((String)"invalid function definition: parameter type [%s] not found for function [%s]", (Object[])new Object[]{typeParameter, functionKey})));
            }
            typeParameters.add(paramType);
        }
        functionTable.addMangledFunction(functionName, returnType, typeParameters, userFunctionNode.isInternal(), userFunctionNode.isStatic());
    }
}

