/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.SimpleDiffable;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public class RegisteredPolicySnapshots
implements Metadata.Custom {
    public static final String TYPE = "registered_snapshots";
    private static final ParseField SNAPSHOTS = new ParseField("snapshots", new String[0]);
    public static final RegisteredPolicySnapshots EMPTY = new RegisteredPolicySnapshots(List.of());
    public static final ConstructingObjectParser<RegisteredPolicySnapshots, Void> PARSER = new ConstructingObjectParser("registered_snapshots", a -> new RegisteredPolicySnapshots((List)a[0]));
    private final List<PolicySnapshot> snapshots;

    public RegisteredPolicySnapshots(List<PolicySnapshot> snapshots) {
        this.snapshots = Collections.unmodifiableList(snapshots);
    }

    public RegisteredPolicySnapshots(StreamInput in) throws IOException {
        this.snapshots = in.readCollectionAsImmutableList(PolicySnapshot::new);
    }

    public List<PolicySnapshot> getSnapshots() {
        return this.snapshots;
    }

    public boolean contains(SnapshotId snapshotId) {
        return this.snapshots.stream().map(PolicySnapshot::getSnapshotId).anyMatch(snapshotId::equals);
    }

    public List<SnapshotId> getSnapshotsByPolicy(String policy) {
        return this.snapshots.stream().filter(s -> s.getPolicy().equals(policy)).map(PolicySnapshot::getSnapshotId).toList();
    }

    @Override
    public EnumSet<Metadata.XContentContext> context() {
        return Metadata.ALL_CONTEXTS;
    }

    @Override
    public Diff<Metadata.Custom> diff(Metadata.Custom previousState) {
        return new RegisteredSnapshotsDiff((RegisteredPolicySnapshots)previousState, this);
    }

    @Override
    public String getWriteableName() {
        return TYPE;
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersions.REGISTER_SLM_STATS;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeCollection(this.snapshots);
    }

    @Override
    public Iterator<? extends ToXContent> toXContentChunked(ToXContent.Params ignored) {
        return Iterators.concat(Iterators.single((builder, params) -> {
            builder.field(SNAPSHOTS.getPreferredName(), this.snapshots);
            return builder;
        }));
    }

    public static RegisteredPolicySnapshots parse(XContentParser parser) throws IOException {
        return (RegisteredPolicySnapshots)PARSER.parse(parser, null);
    }

    public String toString() {
        return "RegisteredSnapshots{snapshots=" + String.valueOf(this.snapshots) + "}";
    }

    public int hashCode() {
        return Objects.hash(this.snapshots);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RegisteredPolicySnapshots other = (RegisteredPolicySnapshots)obj;
        return Objects.equals(this.snapshots, other.snapshots);
    }

    public Builder builder() {
        return new Builder(this);
    }

    private static String getPolicyFromMetadata(Map<String, Object> userMetadata) {
        Object object;
        if (userMetadata != null && (object = userMetadata.get("policy")) instanceof String) {
            String p = (String)object;
            return p;
        }
        return null;
    }

    static {
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> PolicySnapshot.parse(p), SNAPSHOTS);
    }

    public static class RegisteredSnapshotsDiff
    implements NamedDiff<Metadata.Custom> {
        final List<PolicySnapshot> snapshots;

        RegisteredSnapshotsDiff(RegisteredPolicySnapshots before, RegisteredPolicySnapshots after) {
            this.snapshots = after.snapshots;
        }

        public RegisteredSnapshotsDiff(StreamInput in) throws IOException {
            this.snapshots = new RegisteredPolicySnapshots((StreamInput)in).snapshots;
        }

        @Override
        public Metadata.Custom apply(Metadata.Custom part) {
            return new RegisteredPolicySnapshots(this.snapshots);
        }

        @Override
        public String getWriteableName() {
            return RegisteredPolicySnapshots.TYPE;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeCollection(this.snapshots);
        }

        @Override
        public TransportVersion getMinimalSupportedVersion() {
            return TransportVersions.REGISTER_SLM_STATS;
        }
    }

    public static class Builder {
        final List<PolicySnapshot> snapshots;

        Builder(RegisteredPolicySnapshots registeredPolicySnapshots) {
            this.snapshots = new ArrayList<PolicySnapshot>(registeredPolicySnapshots.snapshots);
        }

        void maybeAdd(Map<String, Object> userMetadata, SnapshotId snapshotId) {
            String policy = RegisteredPolicySnapshots.getPolicyFromMetadata(userMetadata);
            if (policy != null) {
                this.snapshots.add(new PolicySnapshot(policy, snapshotId));
            }
        }

        RegisteredPolicySnapshots build() {
            return new RegisteredPolicySnapshots(this.snapshots);
        }
    }

    public static class PolicySnapshot
    implements SimpleDiffable<PolicySnapshot>,
    Writeable,
    ToXContentObject {
        private final String policy;
        private final SnapshotId snapshotId;
        private static final ParseField POLICY = new ParseField("policy", new String[0]);
        private static final ParseField SNAPSHOT_ID = new ParseField("snapshot_id", new String[0]);
        private static final ConstructingObjectParser<PolicySnapshot, String> PARSER = new ConstructingObjectParser("snapshot", true, (a, id) -> new PolicySnapshot((String)a[0], (SnapshotId)a[1]));

        public PolicySnapshot(String policy, SnapshotId snapshotId) {
            this.policy = policy;
            this.snapshotId = snapshotId;
        }

        public PolicySnapshot(StreamInput in) throws IOException {
            this.policy = in.readString();
            this.snapshotId = new SnapshotId(in);
        }

        public String getPolicy() {
            return this.policy;
        }

        public SnapshotId getSnapshotId() {
            return this.snapshotId;
        }

        public static PolicySnapshot parse(XContentParser parser) {
            return (PolicySnapshot)PARSER.apply(parser, null);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.policy);
            this.snapshotId.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(POLICY.getPreferredName(), this.policy);
            builder.field(SNAPSHOT_ID.getPreferredName(), (ToXContent)this.snapshotId);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.policy, this.snapshotId);
        }

        public boolean equals(Object obj) {
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            PolicySnapshot other = (PolicySnapshot)obj;
            return Objects.equals(this.policy, other.policy) && Objects.equals(this.snapshotId, other.snapshotId);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), POLICY);
            PARSER.declareObject(ConstructingObjectParser.constructorArg(), SnapshotId::parse, SNAPSHOT_ID);
        }
    }
}

