/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.query;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.CollectionTerminatedException;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorable;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.ScorerSupplier;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.search.internal.TwoPhaseCollector;

public final class QueryPhaseCollector
implements TwoPhaseCollector {
    private final Collector aggsCollector;
    private final Collector topDocsCollector;
    private final TerminateAfterChecker terminateAfterChecker;
    private final Weight postFilterWeight;
    private final Float minScore;
    private final boolean cacheScores;
    private boolean terminatedAfter = false;
    private static final TerminateAfterChecker NO_OP_TERMINATE_AFTER_CHECKER = new TerminateAfterChecker(){

        @Override
        boolean isThresholdReached() {
            return false;
        }

        @Override
        boolean incrementHitCountAndCheckThreshold() {
            return false;
        }
    };

    QueryPhaseCollector(Collector topDocsCollector, Weight postFilterWeight, TerminateAfterChecker terminateAfterChecker, Collector aggsCollector, Float minScore) {
        this.topDocsCollector = Objects.requireNonNull(topDocsCollector);
        this.postFilterWeight = postFilterWeight;
        this.terminateAfterChecker = terminateAfterChecker;
        this.aggsCollector = aggsCollector;
        this.minScore = minScore;
        this.cacheScores = aggsCollector != null && topDocsCollector.scoreMode().needsScores() && aggsCollector.scoreMode().needsScores();
    }

    Collector getTopDocsCollector() {
        return this.topDocsCollector;
    }

    Collector getAggsCollector() {
        return this.aggsCollector;
    }

    public void setWeight(Weight weight) {
        if (this.postFilterWeight == null && this.minScore == null) {
            this.topDocsCollector.setWeight(weight);
        }
        if (this.aggsCollector != null && this.minScore == null) {
            this.aggsCollector.setWeight(weight);
        }
    }

    public ScoreMode scoreMode() {
        ScoreMode scoreMode;
        if (this.aggsCollector == null) {
            scoreMode = this.topDocsCollector.scoreMode();
        } else {
            assert (this.aggsCollector.scoreMode() != ScoreMode.TOP_SCORES) : "aggs never rely on setMinCompetitiveScore";
            scoreMode = this.topDocsCollector.scoreMode() == this.aggsCollector.scoreMode() ? this.topDocsCollector.scoreMode() : (this.topDocsCollector.scoreMode().needsScores() || this.aggsCollector.scoreMode().needsScores() ? ScoreMode.COMPLETE : ScoreMode.COMPLETE_NO_SCORES);
        }
        if (this.minScore != null) {
            scoreMode = scoreMode == ScoreMode.TOP_SCORES ? ScoreMode.TOP_SCORES : ScoreMode.COMPLETE;
        }
        return scoreMode;
    }

    boolean isTerminatedAfter() {
        return this.terminatedAfter;
    }

    private boolean shouldCollectTopDocs(int doc, Scorable scorer, Bits postFilterBits) throws IOException {
        return this.isDocWithinMinScore(scorer) && (postFilterBits == null || postFilterBits.get(doc));
    }

    private boolean isDocWithinMinScore(Scorable scorer) throws IOException {
        return this.minScore == null || scorer.score() >= this.minScore.floatValue();
    }

    private void earlyTerminate() {
        this.terminatedAfter = true;
        throw new CollectionTerminatedException();
    }

    private Bits getPostFilterBits(LeafReaderContext context) throws IOException {
        if (this.postFilterWeight == null) {
            return null;
        }
        ScorerSupplier filterScorerSupplier = this.postFilterWeight.scorerSupplier(context);
        return Lucene.asSequentialAccessBits(context.reader().maxDoc(), filterScorerSupplier);
    }

    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        LeafCollector alf;
        LeafCollector topDocsLeafCollector;
        Bits postFilterBits;
        block9: {
            if (this.terminateAfterChecker.isThresholdReached()) {
                this.earlyTerminate();
            }
            postFilterBits = this.getPostFilterBits(context);
            if (this.aggsCollector == null) {
                LeafCollector topDocsLeafCollector2 = this.topDocsCollector.getLeafCollector(context);
                if (postFilterBits == null && this.terminateAfterChecker == NO_OP_TERMINATE_AFTER_CHECKER && this.minScore == null) {
                    return topDocsLeafCollector2;
                }
                return new TopDocsLeafCollector(postFilterBits, topDocsLeafCollector2);
            }
            LeafCollector tdlc = null;
            try {
                tdlc = this.topDocsCollector.getLeafCollector(context);
            }
            catch (CollectionTerminatedException collectionTerminatedException) {
                // empty catch block
            }
            topDocsLeafCollector = tdlc;
            alf = null;
            try {
                alf = this.aggsCollector.getLeafCollector(context);
            }
            catch (CollectionTerminatedException e) {
                if (topDocsLeafCollector != null) break block9;
                throw e;
            }
        }
        LeafCollector aggsLeafCollector = alf;
        if (topDocsLeafCollector == null && this.minScore == null) {
            return aggsLeafCollector;
        }
        if (aggsLeafCollector == null && postFilterBits == null && this.terminateAfterChecker == NO_OP_TERMINATE_AFTER_CHECKER && this.minScore == null) {
            return new FilterLeafCollector(topDocsLeafCollector){

                public void setScorer(Scorable scorer) throws IOException {
                    super.setScorer((Scorable)QueryPhaseCollector.wrapToIgnoreMinCompetitiveScore(scorer));
                }

                public DocIdSetIterator competitiveIterator() throws IOException {
                    return topDocsLeafCollector.competitiveIterator();
                }
            };
        }
        return new CompositeLeafCollector(postFilterBits, topDocsLeafCollector, aggsLeafCollector);
    }

    private static FilterScorable wrapToIgnoreMinCompetitiveScore(Scorable scorer) {
        return new FilterScorable(scorer){

            public void setMinCompetitiveScore(float minScore) {
            }
        };
    }

    static TerminateAfterChecker resolveTerminateAfterChecker(int terminateAfter) {
        if (terminateAfter < 0) {
            throw new IllegalArgumentException("terminateAfter must be greater than or equal to 0");
        }
        return terminateAfter == 0 ? NO_OP_TERMINATE_AFTER_CHECKER : new GlobalTerminateAfterChecker(terminateAfter);
    }

    @Override
    public void doPostCollection() throws IOException {
        Collector collector = this.aggsCollector;
        if (collector instanceof TwoPhaseCollector) {
            TwoPhaseCollector twoPhaseCollector = (TwoPhaseCollector)collector;
            twoPhaseCollector.doPostCollection();
        }
    }

    static abstract class TerminateAfterChecker {
        TerminateAfterChecker() {
        }

        abstract boolean isThresholdReached();

        abstract boolean incrementHitCountAndCheckThreshold();
    }

    private class TopDocsLeafCollector
    implements LeafCollector {
        private final Bits postFilterBits;
        private final LeafCollector topDocsLeafCollector;
        private Scorable scorer;

        TopDocsLeafCollector(Bits postFilterBits, LeafCollector topDocsLeafCollector) {
            assert (topDocsLeafCollector != null);
            assert (postFilterBits != null || QueryPhaseCollector.this.terminateAfterChecker != NO_OP_TERMINATE_AFTER_CHECKER || QueryPhaseCollector.this.minScore != null);
            this.postFilterBits = postFilterBits;
            this.topDocsLeafCollector = topDocsLeafCollector;
        }

        public void setScorer(Scorable scorer) throws IOException {
            this.topDocsLeafCollector.setScorer(scorer);
            this.scorer = scorer;
        }

        public DocIdSetIterator competitiveIterator() throws IOException {
            return this.topDocsLeafCollector.competitiveIterator();
        }

        public void collect(int doc) throws IOException {
            if (QueryPhaseCollector.this.shouldCollectTopDocs(doc, this.scorer, this.postFilterBits)) {
                if (QueryPhaseCollector.this.terminateAfterChecker.incrementHitCountAndCheckThreshold()) {
                    QueryPhaseCollector.this.earlyTerminate();
                }
                this.topDocsLeafCollector.collect(doc);
            }
        }
    }

    private class CompositeLeafCollector
    implements LeafCollector {
        private final Bits postFilterBits;
        private LeafCollector topDocsLeafCollector;
        private LeafCollector aggsLeafCollector;
        private Scorable scorer;

        CompositeLeafCollector(Bits postFilterBits, LeafCollector topDocsLeafCollector, LeafCollector aggsLeafCollector) {
            assert (topDocsLeafCollector != null || aggsLeafCollector != null);
            this.postFilterBits = postFilterBits;
            this.topDocsLeafCollector = topDocsLeafCollector;
            this.aggsLeafCollector = aggsLeafCollector;
        }

        public void setScorer(Scorable scorer) throws IOException {
            if (QueryPhaseCollector.this.cacheScores && this.topDocsLeafCollector != null && this.aggsLeafCollector != null) {
                scorer = ScoreCachingWrappingScorer.wrap((Scorable)scorer);
            }
            scorer = QueryPhaseCollector.wrapToIgnoreMinCompetitiveScore(scorer);
            if (this.topDocsLeafCollector != null) {
                this.topDocsLeafCollector.setScorer(scorer);
            }
            if (this.aggsLeafCollector != null) {
                this.aggsLeafCollector.setScorer(scorer);
            }
            this.scorer = scorer;
        }

        public void collect(int doc) throws IOException {
            block9: {
                block8: {
                    if (QueryPhaseCollector.this.shouldCollectTopDocs(doc, this.scorer, this.postFilterBits)) {
                        if (QueryPhaseCollector.this.terminateAfterChecker.incrementHitCountAndCheckThreshold()) {
                            QueryPhaseCollector.this.earlyTerminate();
                        }
                        if (this.topDocsLeafCollector != null) {
                            try {
                                this.topDocsLeafCollector.collect(doc);
                            }
                            catch (CollectionTerminatedException e) {
                                this.topDocsLeafCollector = null;
                                if (this.aggsLeafCollector != null) break block8;
                                throw e;
                            }
                        }
                    }
                }
                if (this.aggsLeafCollector != null && QueryPhaseCollector.this.isDocWithinMinScore(this.scorer)) {
                    try {
                        this.aggsLeafCollector.collect(doc);
                    }
                    catch (CollectionTerminatedException e) {
                        this.aggsLeafCollector = null;
                        if (this.topDocsLeafCollector != null) break block9;
                        throw e;
                    }
                }
            }
        }

        public DocIdSetIterator competitiveIterator() throws IOException {
            if (this.topDocsLeafCollector == null) {
                return this.aggsLeafCollector.competitiveIterator();
            }
            if (this.aggsLeafCollector == null) {
                return this.topDocsLeafCollector.competitiveIterator();
            }
            return null;
        }
    }

    private static final class GlobalTerminateAfterChecker
    extends TerminateAfterChecker {
        private final int terminateAfter;
        private final AtomicInteger numCollected = new AtomicInteger();

        GlobalTerminateAfterChecker(int terminateAfter) {
            assert (terminateAfter > 0);
            this.terminateAfter = terminateAfter;
        }

        @Override
        boolean isThresholdReached() {
            return this.numCollected.getAcquire() >= this.terminateAfter;
        }

        @Override
        boolean incrementHitCountAndCheckThreshold() {
            return this.numCollected.incrementAndGet() > this.terminateAfter;
        }
    }
}

