/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class Metadata {
    protected static final String INDEX = "_index";
    protected static final String ID = "_id";
    protected static final String ROUTING = "_routing";
    protected static final String VERSION_TYPE = "_version_type";
    protected static final String VERSION = "_version";
    protected static final String TYPE = "_type";
    protected static final String NOW = "_now";
    protected static final String OP = "op";
    protected static final String IF_SEQ_NO = "_if_seq_no";
    protected static final String IF_PRIMARY_TERM = "_if_primary_term";
    protected static final String DYNAMIC_TEMPLATES = "_dynamic_templates";
    public static FieldProperty<Object> ObjectField = new FieldProperty<Object>(Object.class);
    public static FieldProperty<String> StringField = new FieldProperty<String>(String.class);
    public static FieldProperty<Number> LongField = new FieldProperty<Number>(Number.class).withValidation(FieldProperty.LONGABLE_NUMBER);
    protected final Map<String, Object> map;
    private final Map<String, FieldProperty<?>> properties;
    protected static final FieldProperty<?> BAD_KEY = new FieldProperty(null, false, false, null);
    private static final Object NOT_FOUND = new Object();

    protected Metadata(Map<String, Object> map, Map<String, FieldProperty<?>> properties) {
        this.map = map;
        this.properties = Map.copyOf(properties);
        assert (this.properties == properties) : "properties map must be constructed via Map.of(...) or Map.copyOf(...)";
        this.validateMetadata();
    }

    protected void validateMetadata() {
        int numMetadata = 0;
        for (Map.Entry<String, FieldProperty<?>> entry : this.properties.entrySet()) {
            String key = entry.getKey();
            Object value = this.map.getOrDefault(key, NOT_FOUND);
            if (value == NOT_FOUND) {
                entry.getValue().check(MapOperation.INIT, key, null);
                continue;
            }
            ++numMetadata;
            entry.getValue().check(MapOperation.INIT, key, value);
        }
        if (numMetadata < this.map.size()) {
            HashSet<String> keys = new HashSet<String>(this.map.keySet());
            keys.removeAll(this.properties.keySet());
            throw new IllegalArgumentException("Unexpected metadata keys [" + keys.stream().sorted().map(k -> k + ":" + String.valueOf(this.map.get(k))).collect(Collectors.joining(", ")) + "]");
        }
    }

    public String getIndex() {
        return this.getString(INDEX);
    }

    public void setIndex(String index) {
        this.put(INDEX, index);
    }

    public String getId() {
        return this.getString(ID);
    }

    public void setId(String id) {
        this.put(ID, id);
    }

    public String getRouting() {
        return this.getString(ROUTING);
    }

    public void setRouting(String routing) {
        this.put(ROUTING, routing);
    }

    public String getVersionType() {
        return this.getString(VERSION_TYPE);
    }

    public void setVersionType(String versionType) {
        this.put(VERSION_TYPE, versionType);
    }

    public long getVersion() {
        return this.getNumber(VERSION).longValue();
    }

    public void setVersion(long version) {
        this.put(VERSION, version);
    }

    public ZonedDateTime getNow() {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.getNumber(NOW).longValue()), ZoneOffset.UTC);
    }

    public String getOp() {
        return this.getString(OP);
    }

    public void setOp(String op) {
        this.put(OP, op);
    }

    public Number getIfSeqNo() {
        return this.getNumber(IF_SEQ_NO);
    }

    public Number getIfPrimaryTerm() {
        return this.getNumber(IF_PRIMARY_TERM);
    }

    public Map<String, String> getDynamicTemplates() {
        return (Map)this.get(DYNAMIC_TEMPLATES);
    }

    protected String getString(String key) {
        return Objects.toString(this.get(key), null);
    }

    protected Number getNumber(String key) {
        Object value = this.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number;
        }
        throw new IllegalStateException("unexpected type for [" + key + "] with value [" + String.valueOf(value) + "], expected Number, got [" + value.getClass().getName() + "]");
    }

    public boolean isAvailable(String key) {
        return this.properties.containsKey(key);
    }

    public Object put(String key, Object value) {
        this.properties.getOrDefault(key, BAD_KEY).check(MapOperation.UPDATE, key, value);
        return this.map.put(key, value);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    public Object get(String key) {
        return this.map.get(key);
    }

    public Object remove(String key) {
        this.properties.getOrDefault(key, BAD_KEY).check(MapOperation.REMOVE, key, null);
        return this.map.remove(key);
    }

    public Set<String> keySet() {
        return Collections.unmodifiableSet(this.map.keySet());
    }

    public int size() {
        return this.map.size();
    }

    public Metadata clone() {
        return new Metadata(new HashMap<String, Object>(this.map), this.properties);
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Metadata)) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return this.map.equals(metadata.map);
    }

    public int hashCode() {
        return Objects.hash(this.map);
    }

    public static BiConsumer<String, String> stringSetValidator(Set<String> valid) {
        return (k, v) -> {
            if (!valid.contains(v)) {
                throw new IllegalArgumentException("[" + k + "] must be one of " + valid.stream().sorted().collect(Collectors.joining(", ")) + ", not [" + v + "]");
            }
        };
    }

    public record FieldProperty<T>(Class<T> type, boolean nullable, boolean writable, BiConsumer<String, T> extendedValidation) {
        public static BiConsumer<String, Number> LONGABLE_NUMBER = (k, v) -> {
            long version = v.longValue();
            if (v.doubleValue() == (double)version) {
                return;
            }
            throw new IllegalArgumentException(k + " may only be set to an int or a long but was [" + String.valueOf(v) + "] with type [" + v.getClass().getName() + "]");
        };
        public static FieldProperty<?> ALLOW_ALL = new FieldProperty(null, true, true, null);

        public FieldProperty(Class<T> type) {
            this(type, false, false, null);
        }

        public FieldProperty<T> withNullable() {
            if (this.nullable) {
                return this;
            }
            return new FieldProperty<T>(this.type, true, this.writable, this.extendedValidation);
        }

        public FieldProperty<T> withWritable() {
            if (this.writable) {
                return this;
            }
            return new FieldProperty<T>(this.type, this.nullable, true, this.extendedValidation);
        }

        public FieldProperty<T> withValidation(BiConsumer<String, T> extendedValidation) {
            if (this.extendedValidation == extendedValidation) {
                return this;
            }
            return new FieldProperty<T>(this.type, this.nullable, this.writable, extendedValidation);
        }

        public void check(MapOperation op, String key, Object value) {
            switch (op) {
                case UPDATE: {
                    if (!this.writable) {
                        throw new IllegalArgumentException(key + " cannot be updated");
                    }
                }
                case INIT: {
                    if (value == null) {
                        if (this.nullable) break;
                        throw new IllegalArgumentException(key + " cannot be null");
                    }
                    this.checkType(key, value);
                    break;
                }
                case REMOVE: {
                    if (this.writable && this.nullable) break;
                    throw new IllegalArgumentException(key + " cannot be removed");
                }
                default: {
                    throw new IllegalArgumentException("unexpected op [" + String.valueOf((Object)op) + "] for key [" + key + "] and value [" + String.valueOf(value) + "]");
                }
            }
        }

        private void checkType(String key, Object value) {
            if (this.type == null) {
                return;
            }
            if (!this.type.isAssignableFrom(value.getClass())) {
                throw new IllegalArgumentException(key + " [" + String.valueOf(value) + "] is wrong type, expected assignable to [" + this.type.getName() + "], not [" + value.getClass().getName() + "]");
            }
            if (this.extendedValidation != null) {
                this.extendedValidation.accept(key, (String)value);
            }
        }
    }

    public static enum MapOperation {
        INIT,
        UPDATE,
        REMOVE;

    }
}

