/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.lucene.queries;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryVisitor;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.lucene.queries.MinDocQuery;

public class SearchAfterSortedDocQuery
extends Query {
    private final Sort sort;
    private final FieldDoc after;
    private final FieldComparator<?>[] fieldComparators;
    private final int[] reverseMuls;

    public SearchAfterSortedDocQuery(Sort sort, FieldDoc after) {
        if (sort.getSort().length != after.fields.length) {
            throw new IllegalArgumentException("after doc  has " + after.fields.length + " value(s) but sort has " + sort.getSort().length + ".");
        }
        this.sort = Objects.requireNonNull(sort);
        this.after = after;
        int numFields = sort.getSort().length;
        this.fieldComparators = new FieldComparator[numFields];
        this.reverseMuls = new int[numFields];
        for (int i = 0; i < numFields; ++i) {
            FieldComparator fieldComparator;
            SortField sortField = sort.getSort()[i];
            FieldComparator comparator = fieldComparator = sortField.getComparator(1, Pruning.NONE);
            comparator.setTopValue(after.fields[i]);
            this.fieldComparators[i] = fieldComparator;
            this.reverseMuls[i] = sortField.getReverse() ? -1 : 1;
        }
    }

    public Weight createWeight(IndexSearcher searcher, final ScoreMode scoreMode, float boost) throws IOException {
        return new ConstantScoreWeight(this, 1.0f){

            public Scorer scorer(LeafReaderContext context) throws IOException {
                Sort segmentSort = context.reader().getMetaData().getSort();
                if (segmentSort == null || !Lucene.canEarlyTerminate(SearchAfterSortedDocQuery.this.sort, segmentSort)) {
                    throw new IOException("search sort :[" + String.valueOf(SearchAfterSortedDocQuery.this.sort) + "] does not match the index sort:[" + String.valueOf(segmentSort) + "]");
                }
                int afterDoc = SearchAfterSortedDocQuery.this.after.doc - context.docBase;
                TopComparator comparator = SearchAfterSortedDocQuery.getTopComparator(SearchAfterSortedDocQuery.this.fieldComparators, SearchAfterSortedDocQuery.this.reverseMuls, context, afterDoc);
                int maxDoc = context.reader().maxDoc();
                int firstDoc = SearchAfterSortedDocQuery.searchAfterDoc(comparator, 0, context.reader().maxDoc());
                if (firstDoc >= maxDoc) {
                    return null;
                }
                MinDocQuery.MinDocIterator disi = new MinDocQuery.MinDocIterator(firstDoc, maxDoc);
                return new ConstantScoreScorer((Weight)this, this.score(), scoreMode, (DocIdSetIterator)disi);
            }

            public boolean isCacheable(LeafReaderContext ctx) {
                return false;
            }
        };
    }

    public String toString(String field) {
        return "SearchAfterSortedDocQuery(sort=" + String.valueOf(this.sort) + ", afterDoc=" + this.after.toString() + ")";
    }

    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((SearchAfterSortedDocQuery)((Object)((Object)((Object)this)).getClass().cast(other)));
    }

    private boolean equalsTo(SearchAfterSortedDocQuery other) {
        return this.sort.equals((Object)other.sort) && this.after.doc == other.after.doc && Double.compare(this.after.score, other.after.score) == 0 && Arrays.equals(this.after.fields, other.after.fields);
    }

    public int hashCode() {
        return Objects.hash(this.classHash(), this.sort, this.after.doc, Float.valueOf(this.after.score), Arrays.hashCode(this.after.fields));
    }

    public void visit(QueryVisitor visitor) {
        visitor.visitLeaf((Query)this);
    }

    static TopComparator getTopComparator(FieldComparator<?>[] fieldComparators, int[] reverseMuls, LeafReaderContext leafReaderContext, int topDoc) {
        return doc -> {
            for (int i = 0; i < fieldComparators.length; ++i) {
                LeafFieldComparator comparator = fieldComparators[i].getLeafComparator(leafReaderContext);
                int value = reverseMuls[i] * comparator.compareTop(doc);
                if (value == 0) continue;
                return value < 0;
            }
            return doc > topDoc;
        };
    }

    static int searchAfterDoc(TopComparator comparator, int from, int to) throws IOException {
        int low = from;
        int high = to - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            if (comparator.lessThanTop(mid)) {
                high = mid - 1;
                continue;
            }
            low = mid + 1;
        }
        return low;
    }

    static interface TopComparator {
        public boolean lessThanTop(int var1) throws IOException;
    }
}

