/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.lucene.codecs.PostingsFormat;
import org.elasticsearch.cluster.metadata.InferenceFieldMetadata;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.CompletionFieldMapper;
import org.elasticsearch.index.mapper.DataStreamTimestampFieldMapper;
import org.elasticsearch.index.mapper.DateFieldMapper;
import org.elasticsearch.index.mapper.FieldAliasMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldTypeLookup;
import org.elasticsearch.index.mapper.InferenceFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.NestedLookup;
import org.elasticsearch.index.mapper.NestedObjectMapper;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.PassThroughObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.mapper.SourceFieldMapper;
import org.elasticsearch.index.mapper.SourceFieldMetrics;
import org.elasticsearch.index.mapper.SourceLoader;

public final class MappingLookup {
    public static final MappingLookup EMPTY = MappingLookup.fromMappers(Mapping.EMPTY, List.of(), List.of());
    private final CacheKey cacheKey = new CacheKey();
    private final Map<String, Mapper> fieldMappers;
    private final Map<String, ObjectMapper> objectMappers;
    private final Map<String, InferenceFieldMetadata> inferenceFields;
    private final int runtimeFieldMappersCount;
    private final NestedLookup nestedLookup;
    private final FieldTypeLookup fieldTypeLookup;
    private final FieldTypeLookup indexTimeLookup;
    private final Map<String, NamedAnalyzer> indexAnalyzersMap;
    private final List<FieldMapper> indexTimeScriptMappers;
    private final Mapping mapping;
    private final Set<String> completionFields;
    private final int totalFieldsCount;

    public static MappingLookup fromMapping(Mapping mapping) {
        ArrayList<ObjectMapper> newObjectMappers = new ArrayList<ObjectMapper>();
        ArrayList<FieldMapper> newFieldMappers = new ArrayList<FieldMapper>();
        ArrayList<FieldAliasMapper> newFieldAliasMappers = new ArrayList<FieldAliasMapper>();
        ArrayList<PassThroughObjectMapper> newPassThroughMappers = new ArrayList<PassThroughObjectMapper>();
        for (MetadataFieldMapper metadataMapper : mapping.getSortedMetadataMappers()) {
            if (metadataMapper == null) continue;
            newFieldMappers.add(metadataMapper);
        }
        for (Mapper child : mapping.getRoot()) {
            MappingLookup.collect(child, newObjectMappers, newFieldMappers, newFieldAliasMappers, newPassThroughMappers);
        }
        return new MappingLookup(mapping, newFieldMappers, newObjectMappers, newFieldAliasMappers, newPassThroughMappers);
    }

    private static void collect(Mapper mapper, Collection<ObjectMapper> objectMappers, Collection<FieldMapper> fieldMappers, Collection<FieldAliasMapper> fieldAliasMappers, Collection<PassThroughObjectMapper> passThroughMappers) {
        if (mapper instanceof PassThroughObjectMapper) {
            PassThroughObjectMapper passThroughObjectMapper = (PassThroughObjectMapper)mapper;
            passThroughMappers.add(passThroughObjectMapper);
            objectMappers.add(passThroughObjectMapper);
        } else if (mapper instanceof ObjectMapper) {
            ObjectMapper objectMapper = (ObjectMapper)mapper;
            objectMappers.add(objectMapper);
        } else if (mapper instanceof FieldMapper) {
            FieldMapper fieldMapper = (FieldMapper)mapper;
            fieldMappers.add(fieldMapper);
        } else if (mapper instanceof FieldAliasMapper) {
            FieldAliasMapper fieldAliasMapper = (FieldAliasMapper)mapper;
            fieldAliasMappers.add(fieldAliasMapper);
        } else {
            throw new IllegalStateException("Unrecognized mapper type [" + mapper.getClass().getSimpleName() + "].");
        }
        for (Mapper child : mapper) {
            MappingLookup.collect(child, objectMappers, fieldMappers, fieldAliasMappers, passThroughMappers);
        }
    }

    public static MappingLookup fromMappers(Mapping mapping, Collection<FieldMapper> mappers, Collection<ObjectMapper> objectMappers, Collection<FieldAliasMapper> aliasMappers, Collection<PassThroughObjectMapper> passThroughMappers) {
        return new MappingLookup(mapping, mappers, objectMappers, aliasMappers, passThroughMappers);
    }

    public static MappingLookup fromMappers(Mapping mapping, Collection<FieldMapper> mappers, Collection<ObjectMapper> objectMappers) {
        return new MappingLookup(mapping, mappers, objectMappers, List.of(), List.of());
    }

    private MappingLookup(Mapping mapping, Collection<FieldMapper> mappers, Collection<ObjectMapper> objectMappers, Collection<FieldAliasMapper> aliasMappers, Collection<PassThroughObjectMapper> passThroughMappers) {
        this.totalFieldsCount = mapping.getRoot().getTotalFieldsCount();
        this.mapping = mapping;
        HashMap<String, Mapper> fieldMappers = new HashMap<String, Mapper>();
        HashMap<String, ObjectMapper> objects = new HashMap<String, ObjectMapper>();
        ArrayList<NestedObjectMapper> nestedMappers = new ArrayList<NestedObjectMapper>();
        for (ObjectMapper mapper : objectMappers) {
            if (objects.put(mapper.fullPath(), mapper) != null) {
                throw new MapperParsingException("Object mapper [" + mapper.fullPath() + "] is defined more than once");
            }
            if (!mapper.isNested()) continue;
            nestedMappers.add((NestedObjectMapper)mapper);
        }
        this.nestedLookup = NestedLookup.build(nestedMappers);
        HashMap<String, NamedAnalyzer> indexAnalyzersMap = new HashMap<String, NamedAnalyzer>();
        HashSet<String> completionFields = new HashSet<String>();
        ArrayList<FieldMapper> indexTimeScriptMappers = new ArrayList<FieldMapper>();
        for (FieldMapper mapper : mappers) {
            if (objects.containsKey(mapper.fullPath())) {
                throw new MapperParsingException("Field [" + mapper.fullPath() + "] is defined both as an object and a field");
            }
            if (fieldMappers.put(mapper.fullPath(), mapper) != null) {
                throw new MapperParsingException("Field [" + mapper.fullPath() + "] is defined more than once");
            }
            indexAnalyzersMap.putAll(mapper.indexAnalyzers());
            if (mapper.hasScript()) {
                indexTimeScriptMappers.add(mapper);
            }
            if (!(mapper instanceof CompletionFieldMapper)) continue;
            completionFields.add(mapper.fullPath());
        }
        for (FieldAliasMapper aliasMapper : aliasMappers) {
            if (objects.containsKey(aliasMapper.fullPath())) {
                throw new MapperParsingException("Alias [" + aliasMapper.fullPath() + "] is defined both as an object and an alias");
            }
            if (fieldMappers.put(aliasMapper.fullPath(), aliasMapper) == null) continue;
            throw new MapperParsingException("Alias [" + aliasMapper.fullPath() + "] is defined both as an alias and a concrete field");
        }
        PassThroughObjectMapper.checkForDuplicatePriorities(passThroughMappers);
        Collection<RuntimeField> runtimeFields = mapping.getRoot().runtimeFields();
        this.fieldTypeLookup = new FieldTypeLookup(mappers, aliasMappers, passThroughMappers, runtimeFields);
        HashMap<String, InferenceFieldMetadata> inferenceFields = new HashMap<String, InferenceFieldMetadata>();
        for (FieldMapper mapper : mappers) {
            if (!(mapper instanceof InferenceFieldMapper)) continue;
            InferenceFieldMapper inferenceFieldMapper = (InferenceFieldMapper)((Object)mapper);
            inferenceFields.put(mapper.fullPath(), inferenceFieldMapper.getMetadata(this.fieldTypeLookup.sourcePaths(mapper.fullPath())));
        }
        this.inferenceFields = Map.copyOf(inferenceFields);
        this.indexTimeLookup = runtimeFields.isEmpty() ? this.fieldTypeLookup : new FieldTypeLookup(mappers, aliasMappers, passThroughMappers, Collections.emptyList());
        this.fieldMappers = Map.copyOf(fieldMappers);
        this.objectMappers = Map.copyOf(objects);
        this.runtimeFieldMappersCount = runtimeFields.size();
        this.indexAnalyzersMap = Map.copyOf(indexAnalyzersMap);
        this.completionFields = Set.copyOf(completionFields);
        this.indexTimeScriptMappers = List.copyOf(indexTimeScriptMappers);
        runtimeFields.stream().flatMap(RuntimeField::asMappedFieldTypes).map(MappedFieldType::name).forEach(this::validateDoesNotShadow);
        assert (MappingLookup.assertMapperNamesInterned(this.fieldMappers, this.objectMappers));
    }

    private static boolean assertMapperNamesInterned(Map<String, Mapper> mappers, Map<String, ObjectMapper> objectMappers) {
        mappers.forEach(MappingLookup::assertNamesInterned);
        objectMappers.forEach(MappingLookup::assertNamesInterned);
        return true;
    }

    private static void assertNamesInterned(String name, Mapper mapper) {
        assert (name == name.intern());
        assert (mapper.fullPath() == mapper.fullPath().intern());
        assert (mapper.leafName() == mapper.leafName().intern());
        if (mapper instanceof ObjectMapper) {
            ((ObjectMapper)mapper).mappers.forEach(MappingLookup::assertNamesInterned);
        }
    }

    public Mapper getMapper(String field) {
        return this.fieldMappers.get(field);
    }

    FieldTypeLookup fieldTypesLookup() {
        return this.fieldTypeLookup;
    }

    public long getTotalFieldsCount() {
        return this.totalFieldsCount;
    }

    public long getTotalMapperCount() {
        return this.fieldMappers.size() + this.objectMappers.size() + this.runtimeFieldMappersCount;
    }

    FieldTypeLookup indexTimeLookup() {
        return this.indexTimeLookup;
    }

    List<FieldMapper> indexTimeScriptMappers() {
        return this.indexTimeScriptMappers;
    }

    public NamedAnalyzer indexAnalyzer(String field, Function<String, NamedAnalyzer> unmappedFieldAnalyzer) {
        NamedAnalyzer analyzer = this.indexAnalyzersMap.get(field);
        if (analyzer != null) {
            return analyzer;
        }
        return unmappedFieldAnalyzer.apply(field);
    }

    public Iterable<Mapper> fieldMappers() {
        return this.fieldMappers.values();
    }

    public PostingsFormat getPostingsFormat(String field) {
        return this.completionFields.contains(field) ? CompletionFieldMapper.postingsFormat() : null;
    }

    void checkLimits(IndexSettings settings) {
        this.checkFieldLimit(settings.getMappingTotalFieldsLimit());
        this.checkObjectDepthLimit(settings.getMappingDepthLimit());
        this.checkFieldNameLengthLimit(settings.getMappingFieldNameLengthLimit());
        this.checkNestedLimit(settings.getMappingNestedFieldsLimit());
        this.checkDimensionFieldLimit(settings.getMappingDimensionFieldsLimit());
    }

    private void checkFieldLimit(long limit) {
        this.checkFieldLimit(limit, 0);
    }

    void checkFieldLimit(long limit, int additionalFieldsToAdd) {
        if (this.exceedsLimit(limit, additionalFieldsToAdd)) {
            throw new IllegalArgumentException("Limit of total fields [" + limit + "] has been exceeded" + (String)(additionalFieldsToAdd > 0 ? " while adding new fields [" + additionalFieldsToAdd + "]" : ""));
        }
    }

    boolean exceedsLimit(long limit, int additionalFieldsToAdd) {
        return this.remainingFieldsUntilLimit(limit) < (long)additionalFieldsToAdd;
    }

    long remainingFieldsUntilLimit(long mappingTotalFieldsLimit) {
        return mappingTotalFieldsLimit - (long)this.totalFieldsCount;
    }

    private void checkDimensionFieldLimit(long limit) {
        long dimensionFieldCount = this.fieldMappers.values().stream().filter(m -> m instanceof FieldMapper && ((FieldMapper)m).fieldType().isDimension()).count();
        if (dimensionFieldCount > limit) {
            throw new IllegalArgumentException("Limit of total dimension fields [" + limit + "] has been exceeded");
        }
    }

    private void checkObjectDepthLimit(long limit) {
        for (String objectPath : this.objectMappers.keySet()) {
            MappingLookup.checkObjectDepthLimit(limit, objectPath);
        }
    }

    static void checkObjectDepthLimit(long limit, String objectPath) {
        int numDots = 0;
        for (int i = 0; i < objectPath.length(); ++i) {
            if (objectPath.charAt(i) != '.') continue;
            ++numDots;
        }
        int depth = numDots + 2;
        if ((long)depth > limit) {
            throw new IllegalArgumentException("Limit of mapping depth [" + limit + "] has been exceeded due to object field [" + objectPath + "]");
        }
    }

    private void checkFieldNameLengthLimit(long limit) {
        MappingLookup.validateMapperNameIn(this.objectMappers.values(), limit);
        MappingLookup.validateMapperNameIn(this.fieldMappers.values(), limit);
    }

    private static void validateMapperNameIn(Collection<? extends Mapper> mappers, long limit) {
        for (Mapper mapper : mappers) {
            String name = mapper.leafName();
            if ((long)name.length() <= limit) continue;
            throw new IllegalArgumentException("Field name [" + name + "] is longer than the limit of [" + limit + "] characters");
        }
    }

    private void checkNestedLimit(long limit) {
        long actualNestedFields = 0L;
        for (ObjectMapper objectMapper : this.objectMappers.values()) {
            if (!objectMapper.isNested()) continue;
            ++actualNestedFields;
        }
        if (actualNestedFields > limit) {
            throw new IllegalArgumentException("Limit of nested fields [" + limit + "] has been exceeded");
        }
    }

    public Map<String, ObjectMapper> objectMappers() {
        return this.objectMappers;
    }

    public Map<String, InferenceFieldMetadata> inferenceFields() {
        return this.inferenceFields;
    }

    public NestedLookup nestedLookup() {
        return this.nestedLookup;
    }

    public boolean isMultiField(String field) {
        if (!this.fieldMappers.containsKey(field)) {
            return false;
        }
        if (this.indexTimeLookup.get(field) != this.fieldTypeLookup.get(field)) {
            return false;
        }
        String sourceParent = MappingLookup.parentObject(field);
        return sourceParent != null && this.fieldMappers.containsKey(sourceParent);
    }

    public boolean isObjectField(String field) {
        return this.objectMappers.containsKey(field);
    }

    private static String parentObject(String field) {
        int lastDot = field.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        return field.substring(0, lastDot);
    }

    public Set<String> getMatchingFieldNames(String pattern) {
        return this.fieldTypeLookup.getMatchingFieldNames(pattern);
    }

    public Map<String, MappedFieldType> getFullNameToFieldType() {
        return this.fieldTypeLookup.getFullNameToFieldType();
    }

    public MappedFieldType getFieldType(String field) {
        return this.fieldTypesLookup().get(field);
    }

    public Set<String> sourcePaths(String field) {
        return this.fieldTypesLookup().sourcePaths(field);
    }

    public String parentField(String field) {
        return this.fieldTypesLookup().parentField(field);
    }

    public boolean hasMappings() {
        return this != EMPTY;
    }

    public boolean isSourceEnabled() {
        SourceFieldMapper sfm = this.mapping.getMetadataMapperByClass(SourceFieldMapper.class);
        return sfm != null && sfm.enabled();
    }

    public boolean isSourceSynthetic() {
        SourceFieldMapper sfm = this.mapping.getMetadataMapperByClass(SourceFieldMapper.class);
        return sfm != null && sfm.isSynthetic();
    }

    public SourceLoader newSourceLoader(SourceFieldMetrics metrics) {
        SourceFieldMapper sfm = this.mapping.getMetadataMapperByClass(SourceFieldMapper.class);
        return sfm == null ? SourceLoader.FROM_STORED_SOURCE : sfm.newSourceLoader(this.mapping, metrics);
    }

    public boolean isDataStreamTimestampFieldEnabled() {
        DataStreamTimestampFieldMapper dtfm = this.mapping.getMetadataMapperByClass(DataStreamTimestampFieldMapper.class);
        return dtfm != null && dtfm.isEnabled();
    }

    public boolean hasTimestampField() {
        MappedFieldType mappedFieldType = this.fieldTypesLookup().get("@timestamp");
        if (mappedFieldType instanceof DateFieldMapper.DateFieldType) {
            return mappedFieldType.isIndexed() && mappedFieldType.hasDocValues();
        }
        return false;
    }

    public CacheKey cacheKey() {
        return this.cacheKey;
    }

    public Mapping getMapping() {
        return this.mapping;
    }

    public void validateDoesNotShadow(String name) {
        MappedFieldType shadowed = this.indexTimeLookup.get(name);
        if (shadowed == null) {
            return;
        }
        if (shadowed.isDimension()) {
            throw new MapperParsingException("Field [" + name + "] attempted to shadow a time_series_dimension");
        }
        if (shadowed.getMetricType() != null) {
            throw new MapperParsingException("Field [" + name + "] attempted to shadow a time_series_metric");
        }
    }

    public static class CacheKey {
        private CacheKey() {
        }
    }
}

