/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.index.mapper.LegacyTypeFieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MetadataFieldMapper;
import org.elasticsearch.index.mapper.PlaceHolderFieldMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.plugins.FieldPredicate;

public final class MapperRegistry {
    private final Map<String, Mapper.TypeParser> mapperParsers;
    private final Map<String, RuntimeField.Parser> runtimeFieldParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers7x;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers6x;
    private final Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers5x;
    private final Function<String, FieldPredicate> fieldFilter;

    public MapperRegistry(Map<String, Mapper.TypeParser> mapperParsers, Map<String, RuntimeField.Parser> runtimeFieldParsers, Map<String, MetadataFieldMapper.TypeParser> metadataMapperParsers, Function<String, FieldPredicate> fieldFilter) {
        this.mapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, Mapper.TypeParser>(mapperParsers));
        this.runtimeFieldParsers = runtimeFieldParsers;
        this.metadataMapperParsers = Collections.unmodifiableMap(new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadataMapperParsers));
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadata7x = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadataMapperParsers);
        metadata7x.remove("_nested_path");
        this.metadataMapperParsers7x = metadata7x;
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadata6x = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadata7x);
        this.metadataMapperParsers6x = metadata6x;
        LinkedHashMap<String, MetadataFieldMapper.TypeParser> metadata5x = new LinkedHashMap<String, MetadataFieldMapper.TypeParser>(metadata7x);
        metadata5x.put("_type", LegacyTypeFieldMapper.PARSER);
        this.metadataMapperParsers5x = metadata5x;
        this.fieldFilter = fieldFilter;
    }

    public Mapper.TypeParser getMapperParser(String type, IndexVersion indexVersionCreated) {
        Mapper.TypeParser parser = this.mapperParsers.get(type);
        if (indexVersionCreated.isLegacyIndexVersion() && (parser == null || !parser.supportsVersion(indexVersionCreated))) {
            return PlaceHolderFieldMapper.PARSER.apply(type);
        }
        return parser;
    }

    public Map<String, RuntimeField.Parser> getRuntimeFieldParsers() {
        return this.runtimeFieldParsers;
    }

    public Map<String, MetadataFieldMapper.TypeParser> getMetadataMapperParsers(IndexVersion indexCreatedVersion) {
        if (indexCreatedVersion.onOrAfter(IndexVersions.V_8_0_0)) {
            return this.metadataMapperParsers;
        }
        if (indexCreatedVersion.onOrAfter(IndexVersions.V_7_0_0)) {
            return this.metadataMapperParsers7x;
        }
        if (indexCreatedVersion.onOrAfter(IndexVersion.fromId(6000099))) {
            return this.metadataMapperParsers6x;
        }
        if (indexCreatedVersion.onOrAfter(IndexVersion.fromId(5000099))) {
            return this.metadataMapperParsers5x;
        }
        throw new AssertionError((Object)("unknown version: " + String.valueOf(indexCreatedVersion)));
    }

    public Function<String, FieldPredicate> getFieldFilter() {
        return this.fieldFilter;
    }
}

