/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentFragment;
import org.elasticsearch.xcontent.XContentBuilder;

public final class CommitStats
implements Writeable,
ToXContentFragment {
    private final Map<String, String> userData;
    private final long generation;
    private final String id;
    private final int numDocs;
    private final int numLeaves;

    public CommitStats(SegmentInfos segmentInfos) {
        this.userData = Map.copyOf(segmentInfos.getUserData());
        this.generation = segmentInfos.getLastGeneration();
        this.id = Base64.getEncoder().encodeToString(segmentInfos.getId());
        this.numDocs = Lucene.getNumDocs(segmentInfos);
        this.numLeaves = segmentInfos.size();
    }

    CommitStats(StreamInput in) throws IOException {
        this.userData = in.readImmutableMap(StreamInput::readString);
        this.generation = in.readLong();
        this.id = in.readOptionalString();
        this.numDocs = in.readInt();
        this.numLeaves = in.getTransportVersion().onOrAfter(TransportVersions.SEGMENT_LEVEL_FIELDS_STATS) ? in.readVInt() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommitStats that = (CommitStats)o;
        return this.userData.equals(that.userData) && this.generation == that.generation && Objects.equals(this.id, that.id) && this.numDocs == that.numDocs && this.numLeaves == that.numLeaves;
    }

    public int hashCode() {
        return Objects.hash(this.userData, this.generation, this.id, this.numDocs, this.numLeaves);
    }

    public static CommitStats readOptionalCommitStatsFrom(StreamInput in) throws IOException {
        return in.readOptionalWriteable(CommitStats::new);
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public long getGeneration() {
        return this.generation;
    }

    public String getId() {
        return this.id;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    public int getNumLeaves() {
        return this.numLeaves;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.userData, StreamOutput::writeString);
        out.writeLong(this.generation);
        out.writeOptionalString(this.id);
        out.writeInt(this.numDocs);
        if (out.getTransportVersion().onOrAfter(TransportVersions.SEGMENT_LEVEL_FIELDS_STATS)) {
            out.writeVInt(this.numLeaves);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("commit");
        builder.field("id", this.id);
        builder.field("generation", this.generation);
        builder.field("user_data", this.userData);
        builder.field("num_docs", this.numDocs);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final String GENERATION = "generation";
        static final String USER_DATA = "user_data";
        static final String ID = "id";
        static final String COMMIT = "commit";
        static final String NUM_DOCS = "num_docs";

        Fields() {
        }
    }
}

