/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.codec.vectors;

import java.io.IOException;
import org.apache.lucene.util.VectorUtil;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.elasticsearch.index.codec.vectors.BQVectorUtils;
import org.elasticsearch.index.codec.vectors.BinaryQuantizer;

public interface RandomAccessBinarizedByteVectorValues
extends RandomAccessVectorValues.Bytes {
    public float getCentroidDistance(int var1) throws IOException;

    public float getVectorMagnitude(int var1) throws IOException;

    public float getOOQ(int var1) throws IOException;

    public float getNormOC(int var1) throws IOException;

    public float getODotC(int var1) throws IOException;

    public BinaryQuantizer getQuantizer();

    default public int discretizedDimensions() {
        return BQVectorUtils.discretize(this.dimension(), 64);
    }

    default public float sqrtDimensions() {
        return (float)BQVectorUtils.constSqrt(this.dimension());
    }

    default public float maxX1() {
        return (float)(1.9 / BQVectorUtils.constSqrt((double)this.discretizedDimensions() - 1.0));
    }

    public float[] getCentroid() throws IOException;

    public RandomAccessBinarizedByteVectorValues copy() throws IOException;

    default public float getCentroidDP() throws IOException {
        float[] centroid = this.getCentroid();
        return VectorUtil.dotProduct((float[])centroid, (float[])centroid);
    }
}

