/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.time;

import java.util.stream.IntStream;

class CharSubSequence
implements CharSequence {
    private final CharSequence wrapped;
    private final int startOffset;
    private final int endOffset;

    CharSubSequence(CharSequence wrapped, int startOffset, int endOffset) {
        if (startOffset < 0) {
            throw new IllegalArgumentException();
        }
        if (endOffset > wrapped.length()) {
            throw new IllegalArgumentException();
        }
        if (endOffset < startOffset) {
            throw new IllegalArgumentException();
        }
        this.wrapped = wrapped;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public int length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public char charAt(int index) {
        int adjustedIndex = index + this.startOffset;
        if (adjustedIndex < this.startOffset || adjustedIndex >= this.endOffset) {
            throw new IndexOutOfBoundsException(index);
        }
        return this.wrapped.charAt(adjustedIndex);
    }

    @Override
    public boolean isEmpty() {
        return this.startOffset == this.endOffset;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        int adjustedStart = start + this.startOffset;
        int adjustedEnd = end + this.startOffset;
        if (adjustedStart < this.startOffset) {
            throw new IndexOutOfBoundsException(start);
        }
        if (adjustedEnd > this.endOffset) {
            throw new IndexOutOfBoundsException(end);
        }
        if (adjustedStart > adjustedEnd) {
            throw new IndexOutOfBoundsException();
        }
        return this.wrapped.subSequence(adjustedStart, adjustedEnd);
    }

    @Override
    public IntStream chars() {
        return this.wrapped.chars().skip(this.startOffset).limit(this.endOffset - this.startOffset);
    }

    @Override
    public String toString() {
        return this.wrapped.subSequence(this.startOffset, this.endOffset).toString();
    }
}

