/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;

public abstract class BaseNodesRequest<Request extends BaseNodesRequest<Request>>
extends ActionRequest {
    private final String[] nodesIds;
    private final DiscoveryNode[] concreteNodes;
    @Nullable
    private TimeValue timeout;

    protected BaseNodesRequest(String[] nodesIds) {
        this.nodesIds = nodesIds;
        this.concreteNodes = null;
    }

    protected BaseNodesRequest(DiscoveryNode ... concreteNodes) {
        this.nodesIds = null;
        this.concreteNodes = concreteNodes;
    }

    public final String[] nodesIds() {
        return this.nodesIds;
    }

    public TimeValue timeout() {
        return this.timeout;
    }

    public final Request timeout(TimeValue timeout) {
        this.timeout = timeout;
        return (Request)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public final void writeTo(StreamOutput out) throws IOException {
        TransportAction.localOnly();
    }

    DiscoveryNode[] resolveNodes(ClusterState clusterState) {
        assert (this.nodesIds == null || this.concreteNodes == null);
        return Objects.requireNonNullElseGet(this.concreteNodes, () -> (DiscoveryNode[])Arrays.stream(clusterState.nodes().resolveNodes(this.nodesIds)).map(clusterState.nodes()::get).toArray(DiscoveryNode[]::new));
    }
}

