/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.elasticsearch.action.search.SearchPhaseContext;
import org.elasticsearch.action.search.SearchPhaseExecutionException;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchShardIterator;
import org.elasticsearch.action.search.ShardSearchFailure;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.core.CheckedRunnable;
import org.elasticsearch.search.SearchPhaseResult;
import org.elasticsearch.search.SearchShardTarget;
import org.elasticsearch.transport.Transport;

abstract class SearchPhase
implements CheckedRunnable<IOException> {
    private final String name;

    protected SearchPhase(String name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
    }

    public String getName() {
        return this.name;
    }

    public void start() {
        try {
            this.run();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected String missingShardsErrorMessage(StringBuilder missingShards) {
        return "Search rejected due to missing shards [" + String.valueOf(missingShards) + "]. Consider using `allow_partial_search_results` setting to bypass this error.";
    }

    protected void doCheckNoMissingShards(String phaseName, SearchRequest request, GroupShardsIterator<SearchShardIterator> shardsIts) {
        assert (request.allowPartialSearchResults() != null) : "SearchRequest missing setting for allowPartialSearchResults";
        if (!request.allowPartialSearchResults().booleanValue()) {
            StringBuilder missingShards = new StringBuilder();
            for (int index = 0; index < shardsIts.size(); ++index) {
                SearchShardIterator shardRoutings = shardsIts.get(index);
                if (shardRoutings.size() != 0) continue;
                if (!missingShards.isEmpty()) {
                    missingShards.append(", ");
                }
                missingShards.append(shardRoutings.shardId());
            }
            if (!missingShards.isEmpty()) {
                String msg = this.missingShardsErrorMessage(missingShards);
                throw new SearchPhaseExecutionException(phaseName, msg, null, ShardSearchFailure.EMPTY_ARRAY);
            }
        }
    }

    protected void releaseIrrelevantSearchContext(SearchPhaseResult searchPhaseResult, SearchPhaseContext context) {
        SearchPhaseResult phaseResult;
        if (searchPhaseResult == null) {
            return;
        }
        SearchPhaseResult searchPhaseResult2 = phaseResult = searchPhaseResult.queryResult() != null ? searchPhaseResult.queryResult() : searchPhaseResult.rankFeatureResult();
        if (phaseResult != null && phaseResult.hasSearchContext() && context.getRequest().scroll() == null && !context.isPartOfPointInTime(phaseResult.getContextId())) {
            try {
                context.getLogger().trace("trying to release search context [{}]", (Object)phaseResult.getContextId());
                SearchShardTarget shardTarget = phaseResult.getSearchShardTarget();
                Transport.Connection connection = context.getConnection(shardTarget.getClusterAlias(), shardTarget.getNodeId());
                context.sendReleaseSearchContext(phaseResult.getContextId(), connection, context.getOriginalIndices(phaseResult.getShardIndex()));
            }
            catch (Exception e) {
                context.getLogger().trace("failed to release context", (Throwable)e);
            }
        }
    }
}

