/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchGenerationException;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.CompositeIndicesRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.replication.ReplicatedWriteRequest;
import org.elasticsearch.client.internal.Requests;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.IndexRouting;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.StringLiteralDeduplicator;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.plugins.internal.XContentParserDecorator;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentType;

public class IndexRequest
extends ReplicatedWriteRequest<IndexRequest>
implements DocWriteRequest<IndexRequest>,
CompositeIndicesRequest {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(IndexRequest.class);
    private static final TransportVersion PIPELINES_HAVE_RUN_FIELD_ADDED = TransportVersions.V_8_10_X;
    private static final Supplier<String> ID_GENERATOR = UUIDs::base64UUID;
    private static final Supplier<String> K_SORTED_TIME_BASED_ID_GENERATOR = UUIDs::base64TimeBasedKOrderedUUID;
    static final int MAX_SOURCE_LENGTH_IN_TOSTRING = 2048;
    public static final int MAX_DOCUMENT_ID_LENGTH_IN_BYTES = 512;
    private static final ShardId NO_SHARD_ID = null;
    private String id;
    @Nullable
    private String routing;
    private BytesReference source;
    private DocWriteRequest.OpType opType = DocWriteRequest.OpType.INDEX;
    private long version = -3L;
    private VersionType versionType = VersionType.INTERNAL;
    private XContentType contentType;
    private String pipeline;
    private String finalPipeline;
    private boolean isPipelineResolved;
    private boolean requireAlias;
    private boolean requireDataStream;
    private boolean writeToFailureStore = false;
    private boolean listExecutedPipelines;
    @Nullable
    private List<String> executedPipelines = null;
    public static final long UNSET_AUTO_GENERATED_TIMESTAMP = -1L;
    private long autoGeneratedTimestamp = -1L;
    private boolean isRetry = false;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;
    private Map<String, String> dynamicTemplates = Map.of();
    private Object rawTimestamp;
    private static final StringLiteralDeduplicator pipelineNameDeduplicator = new StringLiteralDeduplicator();

    public IndexRequest(StreamInput in) throws IOException {
        this(null, in);
    }

    public IndexRequest(@Nullable ShardId shardId, StreamInput in) throws IOException {
        super(shardId, in);
        if (in.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            String type = in.readOptionalString();
            assert ("_doc".equals(type)) : "Expected [_doc] but received [" + type + "]";
        }
        this.id = in.readOptionalString();
        this.routing = in.readOptionalString();
        this.source = in.readBytesReference();
        this.opType = DocWriteRequest.OpType.fromId(in.readByte());
        this.version = in.readLong();
        this.versionType = VersionType.fromValue(in.readByte());
        this.pipeline = IndexRequest.readPipelineName(in);
        this.finalPipeline = IndexRequest.readPipelineName(in);
        this.isPipelineResolved = in.readBoolean();
        this.isRetry = in.readBoolean();
        this.autoGeneratedTimestamp = in.readLong();
        this.contentType = in.readBoolean() ? XContentType.ofOrdinal((int)in.readByte()) : null;
        this.ifSeqNo = in.readZLong();
        this.ifPrimaryTerm = in.readVLong();
        this.requireAlias = in.readBoolean();
        this.dynamicTemplates = in.readMap(StreamInput::readString);
        if (in.getTransportVersion().onOrAfter(PIPELINES_HAVE_RUN_FIELD_ADDED) && in.getTransportVersion().before(TransportVersions.V_8_13_0)) {
            in.readBoolean();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            this.listExecutedPipelines = in.readBoolean();
            if (this.listExecutedPipelines) {
                List<String> possiblyImmutableExecutedPipelines = in.readOptionalCollectionAsList(StreamInput::readString);
                this.executedPipelines = possiblyImmutableExecutedPipelines == null ? null : new ArrayList<String>(possiblyImmutableExecutedPipelines);
            }
        }
        this.requireDataStream = in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0) ? in.readBoolean() : false;
        if (in.getTransportVersion().before(TransportVersions.INDEX_REQUEST_REMOVE_METERING)) {
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
                in.readZLong();
            }
            if (in.getTransportVersion().onOrAfter(TransportVersions.INDEX_REQUEST_UPDATE_BY_SCRIPT_ORIGIN)) {
                in.readBoolean();
            }
            if (in.getTransportVersion().onOrAfter(TransportVersions.INDEX_REQUEST_UPDATE_BY_DOC_ORIGIN)) {
                in.readBoolean();
            }
        }
    }

    public IndexRequest() {
        super(NO_SHARD_ID);
    }

    public IndexRequest(String index) {
        super(NO_SHARD_ID);
        this.index = index;
    }

    @Nullable
    private static String readPipelineName(StreamInput in) throws IOException {
        String read = in.readOptionalString();
        if (read == null) {
            return null;
        }
        if ("_none".equals(read)) {
            return "_none";
        }
        return pipelineNameDeduplicator.deduplicate(read);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = super.validate();
        if (this.source == null) {
            validationException = ValidateActions.addValidationError("source is missing", validationException);
        }
        if (this.contentType == null) {
            validationException = ValidateActions.addValidationError("content type is missing", validationException);
        }
        assert (this.opType == DocWriteRequest.OpType.INDEX || this.opType == DocWriteRequest.OpType.CREATE) : "unexpected op-type: " + String.valueOf((Object)this.opType);
        long resolvedVersion = this.resolveVersionDefaults();
        if (this.opType == DocWriteRequest.OpType.CREATE) {
            if (this.versionType != VersionType.INTERNAL) {
                validationException = ValidateActions.addValidationError("create operations only support internal versioning. use index instead", validationException);
                return validationException;
            }
            if (resolvedVersion != -4L) {
                validationException = ValidateActions.addValidationError("create operations do not support explicit versions. use index instead", validationException);
                return validationException;
            }
            if (this.ifSeqNo != -2L || this.ifPrimaryTerm != 0L) {
                validationException = ValidateActions.addValidationError("create operations do not support compare and set. use index instead", validationException);
                return validationException;
            }
        }
        if (this.id == null && (this.versionType != VersionType.INTERNAL || resolvedVersion != -4L && resolvedVersion != -3L)) {
            validationException = ValidateActions.addValidationError("an id must be provided if version type or value are set", validationException);
        }
        validationException = DocWriteRequest.validateSeqNoBasedCASParams(this, validationException);
        validationException = DocWriteRequest.validateDocIdLength(this.id, validationException);
        if (this.pipeline != null && this.pipeline.isEmpty()) {
            validationException = ValidateActions.addValidationError("pipeline cannot be an empty string", validationException);
        }
        if (this.finalPipeline != null && this.finalPipeline.isEmpty()) {
            validationException = ValidateActions.addValidationError("final pipeline cannot be an empty string", validationException);
        }
        return validationException;
    }

    public XContentType getContentType() {
        return this.contentType;
    }

    @Override
    public String id() {
        return this.id;
    }

    public IndexRequest id(String id) {
        this.id = id;
        return this;
    }

    @Override
    public IndexRequest routing(String routing) {
        this.routing = routing != null && routing.isEmpty() ? null : routing;
        return this;
    }

    @Override
    public String routing() {
        return this.routing;
    }

    public IndexRequest setPipeline(String pipeline) {
        this.pipeline = pipeline;
        return this;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public IndexRequest setFinalPipeline(String finalPipeline) {
        this.finalPipeline = finalPipeline;
        return this;
    }

    public String getFinalPipeline() {
        return this.finalPipeline;
    }

    public IndexRequest isPipelineResolved(boolean isPipelineResolved) {
        this.isPipelineResolved = isPipelineResolved;
        return this;
    }

    public boolean isPipelineResolved() {
        return this.isPipelineResolved;
    }

    public BytesReference source() {
        return this.source;
    }

    public Map<String, Object> sourceAsMap() {
        return (Map)XContentHelper.convertToMap(this.source, false, this.contentType).v2();
    }

    public Map<String, Object> sourceAsMap(XContentParserDecorator parserDecorator) {
        return (Map)XContentHelper.convertToMap(this.source, false, this.contentType, parserDecorator).v2();
    }

    public IndexRequest source(Map<String, ?> source) throws ElasticsearchGenerationException {
        return this.source(source, Requests.INDEX_CONTENT_TYPE);
    }

    public IndexRequest source(Map<String, ?> source, XContentType contentType) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
            builder.map(source);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public IndexRequest source(Map<String, ?> source, XContentType contentType, boolean ensureNoSelfReferences) throws ElasticsearchGenerationException {
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)contentType);
            builder.map(source, ensureNoSelfReferences);
            return this.source(builder);
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate [" + String.valueOf(source) + "]", e);
        }
    }

    public IndexRequest source(String source, XContentType xContentType) {
        return this.source(new BytesArray(source), xContentType);
    }

    public IndexRequest source(XContentBuilder sourceBuilder) {
        return this.source(BytesReference.bytes(sourceBuilder), sourceBuilder.contentType());
    }

    public IndexRequest source(Object ... source) {
        return this.source(Requests.INDEX_CONTENT_TYPE, source);
    }

    public IndexRequest source(XContentType xContentType, Object ... source) {
        return this.source(IndexRequest.getXContentBuilder(xContentType, source));
    }

    public static XContentBuilder getXContentBuilder(XContentType xContentType, Object ... source) {
        if (source.length % 2 != 0) {
            throw new IllegalArgumentException("The number of object passed must be even but was [" + source.length + "]");
        }
        if (source.length == 2 && source[0] instanceof BytesReference && source[1] instanceof Boolean) {
            throw new IllegalArgumentException("you are using the removed method for source with bytes and unsafe flag, the unsafe flag was removed, please just use source(BytesReference)");
        }
        try {
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)xContentType);
            builder.startObject();
            for (int i = 0; i < source.length; i += 2) {
                String field = source[i].toString();
                Object value = source[i + 1];
                builder.field(field, value);
            }
            builder.endObject();
            return builder;
        }
        catch (IOException e) {
            throw new ElasticsearchGenerationException("Failed to generate", e);
        }
    }

    public IndexRequest source(BytesReference source, XContentType xContentType) {
        this.source = Objects.requireNonNull(source);
        this.contentType = Objects.requireNonNull(xContentType);
        return this;
    }

    public IndexRequest source(byte[] source, XContentType xContentType) {
        return this.source(source, 0, source.length, xContentType);
    }

    public IndexRequest source(byte[] source, int offset, int length, XContentType xContentType) {
        return this.source(new BytesArray(source, offset, length), xContentType);
    }

    public IndexRequest opType(DocWriteRequest.OpType opType) {
        if (opType != DocWriteRequest.OpType.CREATE && opType != DocWriteRequest.OpType.INDEX) {
            throw new IllegalArgumentException("opType must be 'create' or 'index', found: [" + String.valueOf((Object)opType) + "]");
        }
        this.opType = opType;
        return this;
    }

    public IndexRequest opType(String opType) {
        String op = opType.toLowerCase(Locale.ROOT);
        if (op.equals("create")) {
            this.opType(DocWriteRequest.OpType.CREATE);
        } else if (op.equals("index")) {
            this.opType(DocWriteRequest.OpType.INDEX);
        } else {
            throw new IllegalArgumentException("opType must be 'create' or 'index', found: [" + opType + "]");
        }
        return this;
    }

    public IndexRequest create(boolean create) {
        if (create) {
            return this.opType(DocWriteRequest.OpType.CREATE);
        }
        return this.opType(DocWriteRequest.OpType.INDEX);
    }

    @Override
    public DocWriteRequest.OpType opType() {
        return this.opType;
    }

    @Override
    public IndexRequest version(long version) {
        this.version = version;
        return this;
    }

    @Override
    public long version() {
        return this.resolveVersionDefaults();
    }

    private long resolveVersionDefaults() {
        if (this.opType == DocWriteRequest.OpType.CREATE && this.version == -3L) {
            return -4L;
        }
        return this.version;
    }

    @Override
    public IndexRequest versionType(VersionType versionType) {
        this.versionType = versionType;
        return this;
    }

    @Override
    public IndexRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    @Override
    public IndexRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    @Override
    public long ifSeqNo() {
        return this.ifSeqNo;
    }

    @Override
    public long ifPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    @Override
    public VersionType versionType() {
        return this.versionType;
    }

    @Override
    public void process(IndexRouting indexRouting) {
        indexRouting.process(this);
    }

    public void autoGenerateId() {
        this.assertBeforeGeneratingId();
        this.autoGenerateTimestamp();
        this.id(ID_GENERATOR.get());
    }

    public void autoGenerateTimeBasedId() {
        this.assertBeforeGeneratingId();
        this.autoGenerateTimestamp();
        this.id(K_SORTED_TIME_BASED_ID_GENERATOR.get());
    }

    private void autoGenerateTimestamp() {
        this.autoGeneratedTimestamp = Math.max(0L, System.currentTimeMillis());
    }

    private void assertBeforeGeneratingId() {
        assert (this.id == null);
        assert (this.autoGeneratedTimestamp == -1L) : "timestamp has already been generated!";
        assert (this.ifSeqNo == -2L);
        assert (this.ifPrimaryTerm == 0L);
    }

    public void reset() {
        this.autoGeneratedTimestamp = -1L;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.writeBody(out);
    }

    @Override
    public void writeThin(StreamOutput out) throws IOException {
        super.writeThin(out);
        this.writeBody(out);
    }

    private void writeBody(StreamOutput out) throws IOException {
        if (out.getTransportVersion().before(TransportVersions.V_8_0_0)) {
            out.writeOptionalString("_doc");
        }
        out.writeOptionalString(this.id);
        out.writeOptionalString(this.routing);
        out.writeBytesReference(this.source);
        out.writeByte(this.opType.getId());
        out.writeLong(this.version);
        out.writeByte(this.versionType.getValue());
        out.writeOptionalString(this.pipeline);
        out.writeOptionalString(this.finalPipeline);
        out.writeBoolean(this.isPipelineResolved);
        out.writeBoolean(this.isRetry);
        out.writeLong(this.autoGeneratedTimestamp);
        if (this.contentType != null) {
            out.writeBoolean(true);
            XContentHelper.writeTo(out, this.contentType);
        } else {
            out.writeBoolean(false);
        }
        out.writeZLong(this.ifSeqNo);
        out.writeVLong(this.ifPrimaryTerm);
        out.writeBoolean(this.requireAlias);
        out.writeMap(this.dynamicTemplates, StreamOutput::writeString);
        if (out.getTransportVersion().onOrAfter(PIPELINES_HAVE_RUN_FIELD_ADDED) && out.getTransportVersion().before(TransportVersions.V_8_13_0)) {
            out.writeBoolean(false);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_12_0)) {
            out.writeBoolean(this.listExecutedPipelines);
            if (this.listExecutedPipelines) {
                out.writeOptionalCollection(this.executedPipelines, StreamOutput::writeString);
            }
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeBoolean(this.requireDataStream);
        }
        if (out.getTransportVersion().before(TransportVersions.INDEX_REQUEST_REMOVE_METERING)) {
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
                out.writeZLong(-1L);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.INDEX_REQUEST_UPDATE_BY_SCRIPT_ORIGIN)) {
                out.writeBoolean(false);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.INDEX_REQUEST_UPDATE_BY_DOC_ORIGIN)) {
                out.writeBoolean(false);
            }
        }
    }

    @Override
    public String toString() {
        Object sSource = "_na_";
        try {
            sSource = this.source.length() > 2048 ? "n/a, actual length: [" + ByteSizeValue.ofBytes(this.source.length()).toString() + "], max length: " + ByteSizeValue.ofBytes(2048L).toString() : XContentHelper.convertToJson(this.source, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "index {[" + this.index + "][" + this.id + "], source[" + (String)sSource + "]}";
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean isRetry() {
        return this.isRetry;
    }

    @Override
    public void onRetry() {
        this.isRetry = true;
    }

    public long getAutoGeneratedTimestamp() {
        return this.autoGeneratedTimestamp;
    }

    public long ramBytesUsed() {
        return SHALLOW_SIZE + RamUsageEstimator.sizeOf((String)this.id) + (long)(this.source == null ? 0 : this.source.length());
    }

    @Override
    public boolean isRequireAlias() {
        return this.requireAlias;
    }

    @Override
    public boolean isRequireDataStream() {
        return this.requireDataStream;
    }

    public IndexRequest setRequireDataStream(boolean requireDataStream) {
        this.requireDataStream = requireDataStream;
        return this;
    }

    @Override
    public Index getConcreteWriteIndex(IndexAbstraction ia, Metadata metadata) {
        if (DataStream.isFailureStoreFeatureFlagEnabled() && this.writeToFailureStore) {
            if (!ia.isDataStreamRelated()) {
                throw new ElasticsearchException("Attempting to write a document to a failure store but the targeted index is not a data stream", new Object[0]);
            }
            String defaultWriteIndexName = ia.getWriteIndex().getName();
            DataStream dataStream = ((IndexAbstraction)metadata.getIndicesLookup().get(defaultWriteIndexName)).getParentDataStream();
            if (dataStream.getFailureIndices().getIndices().size() < 1) {
                throw new ElasticsearchException("Attempting to write a document to a failure store but the target data stream does not have one enabled", new Object[0]);
            }
            return dataStream.getFailureIndices().getIndices().get(dataStream.getFailureIndices().getIndices().size() - 1);
        }
        return ia.getWriteIndex(this, metadata);
    }

    @Override
    public int route(IndexRouting indexRouting) {
        return indexRouting.indexShard(this.id, this.routing, this.contentType, this.source, this::routing);
    }

    public IndexRequest setRequireAlias(boolean requireAlias) {
        this.requireAlias = requireAlias;
        return this;
    }

    public boolean isWriteToFailureStore() {
        return this.writeToFailureStore;
    }

    public IndexRequest setWriteToFailureStore(boolean writeToFailureStore) {
        this.writeToFailureStore = writeToFailureStore;
        return this;
    }

    public IndexRequest setListExecutedPipelines(boolean listExecutedPipelines) {
        this.listExecutedPipelines = listExecutedPipelines;
        return this;
    }

    public boolean getListExecutedPipelines() {
        return this.listExecutedPipelines;
    }

    public IndexRequest setDynamicTemplates(Map<String, String> dynamicTemplates) {
        this.dynamicTemplates = Objects.requireNonNull(dynamicTemplates);
        return this;
    }

    public Map<String, String> getDynamicTemplates() {
        return this.dynamicTemplates;
    }

    public Object getRawTimestamp() {
        return this.rawTimestamp;
    }

    public void setRawTimestamp(Object rawTimestamp) {
        assert (this.rawTimestamp == null) : "rawTimestamp only set in ingest phase, it can't be set twice";
        this.rawTimestamp = rawTimestamp;
    }

    public void addPipeline(String pipeline) {
        if (this.listExecutedPipelines) {
            if (this.executedPipelines == null) {
                this.executedPipelines = new ArrayList<String>();
            }
            this.executedPipelines.add(pipeline);
        }
    }

    @Nullable
    public List<String> getExecutedPipelines() {
        if (!this.listExecutedPipelines) {
            return null;
        }
        if (this.executedPipelines == null) {
            return List.of();
        }
        return Collections.unmodifiableList(this.executedPipelines);
    }
}

