/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesNodeRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;

public final class FieldCapabilitiesRequest
extends ActionRequest
implements IndicesRequest.Replaceable,
ToXContentObject {
    public static final String NAME = "field_caps_request";
    public static final IndicesOptions DEFAULT_INDICES_OPTIONS = IndicesOptions.strictExpandOpenAndForbidClosed();
    private String[] indices = Strings.EMPTY_ARRAY;
    private IndicesOptions indicesOptions = DEFAULT_INDICES_OPTIONS;
    private String[] fields = Strings.EMPTY_ARRAY;
    private String[] filters = Strings.EMPTY_ARRAY;
    private String[] types = Strings.EMPTY_ARRAY;
    private boolean includeUnmapped = false;
    private boolean includeEmptyFields = true;
    private boolean mergeResults = true;
    private QueryBuilder indexFilter;
    private Map<String, Object> runtimeFields = Collections.emptyMap();
    private Long nowInMillis;

    public FieldCapabilitiesRequest(StreamInput in) throws IOException {
        super(in);
        this.fields = in.readStringArray();
        this.indices = in.readStringArray();
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        this.mergeResults = in.readBoolean();
        this.includeUnmapped = in.readBoolean();
        this.indexFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        this.nowInMillis = in.readOptionalLong();
        this.runtimeFields = in.readGenericMap();
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            this.filters = in.readStringArray();
            this.types = in.readStringArray();
        }
        if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            this.includeEmptyFields = in.readBoolean();
        }
    }

    public FieldCapabilitiesRequest() {
    }

    public boolean isMergeResults() {
        return this.mergeResults;
    }

    public void setMergeResults(boolean mergeResults) {
        this.mergeResults = mergeResults;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArray(this.fields);
        out.writeStringArray(this.indices);
        this.indicesOptions.writeIndicesOptions(out);
        out.writeBoolean(this.mergeResults);
        out.writeBoolean(this.includeUnmapped);
        out.writeOptionalNamedWriteable(this.indexFilter);
        out.writeOptionalLong(this.nowInMillis);
        out.writeGenericMap(this.runtimeFields);
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
            out.writeStringArray(this.filters);
            out.writeStringArray(this.types);
        }
        if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_13_0)) {
            out.writeBoolean(this.includeEmptyFields);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.indexFilter != null) {
            builder.field("index_filter", (ToXContent)this.indexFilter);
        }
        if (!this.runtimeFields.isEmpty()) {
            builder.field("runtime_mappings", this.runtimeFields);
        }
        builder.endObject();
        return builder;
    }

    public FieldCapabilitiesRequest fields(String ... fields) {
        if (fields == null || fields.length == 0) {
            throw new IllegalArgumentException("specified fields can't be null or empty");
        }
        HashSet<String> fieldSet = new HashSet<String>(Arrays.asList(fields));
        this.fields = fieldSet.toArray(new String[0]);
        return this;
    }

    public String[] fields() {
        return this.fields;
    }

    public FieldCapabilitiesRequest filters(String ... filters) {
        this.filters = filters;
        return this;
    }

    public String[] filters() {
        return this.filters;
    }

    public FieldCapabilitiesRequest types(String ... types) {
        this.types = types;
        return this;
    }

    public String[] types() {
        return this.types;
    }

    @Override
    public FieldCapabilitiesRequest indices(String ... indices) {
        this.indices = Objects.requireNonNull(indices, "indices must not be null");
        return this;
    }

    public FieldCapabilitiesRequest indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = Objects.requireNonNull(indicesOptions, "indices options must not be null");
        return this;
    }

    public FieldCapabilitiesRequest includeUnmapped(boolean includeUnmapped) {
        this.includeUnmapped = includeUnmapped;
        return this;
    }

    public FieldCapabilitiesRequest includeEmptyFields(boolean includeEmptyFields) {
        this.includeEmptyFields = includeEmptyFields;
        return this;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    @Override
    public boolean allowsRemoteIndices() {
        return true;
    }

    @Override
    public boolean includeDataStreams() {
        return true;
    }

    public boolean includeUnmapped() {
        return this.includeUnmapped;
    }

    public boolean includeEmptyFields() {
        return this.includeEmptyFields;
    }

    public FieldCapabilitiesRequest indexFilter(QueryBuilder indexFilter) {
        this.indexFilter = indexFilter;
        return this;
    }

    public QueryBuilder indexFilter() {
        return this.indexFilter;
    }

    public FieldCapabilitiesRequest runtimeFields(Map<String, Object> runtimeFieldsSection) {
        this.runtimeFields = runtimeFieldsSection;
        return this;
    }

    public Map<String, Object> runtimeFields() {
        return this.runtimeFields;
    }

    Long nowInMillis() {
        return this.nowInMillis;
    }

    void nowInMillis(long nowInMillis) {
        this.nowInMillis = nowInMillis;
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.fields == null || this.fields.length == 0) {
            validationException = ValidateActions.addValidationError("no fields specified", validationException);
        }
        return validationException;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldCapabilitiesRequest that = (FieldCapabilitiesRequest)o;
        return this.includeUnmapped == that.includeUnmapped && this.mergeResults == that.mergeResults && Arrays.equals(this.indices, that.indices) && this.indicesOptions.equals(that.indicesOptions) && Arrays.equals(this.fields, that.fields) && Objects.equals(this.indexFilter, that.indexFilter) && Objects.equals(this.nowInMillis, that.nowInMillis) && Arrays.equals(this.filters, that.filters) && Arrays.equals(this.types, that.types) && Objects.equals(this.runtimeFields, that.runtimeFields) && this.includeEmptyFields == that.includeEmptyFields;
    }

    public int hashCode() {
        int result = Objects.hash(this.indicesOptions, this.includeUnmapped, this.mergeResults, this.indexFilter, this.nowInMillis, this.runtimeFields, this.includeEmptyFields);
        result = 31 * result + Arrays.hashCode(this.indices);
        result = 31 * result + Arrays.hashCode(this.fields);
        result = 31 * result + Arrays.hashCode(this.filters);
        result = 31 * result + Arrays.hashCode(this.types);
        return result;
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("indices[");
        Strings.collectionToDelimitedStringWithLimit(Arrays.asList(this.indices), ",", "", "", 1024, stringBuilder);
        return FieldCapabilitiesNodeRequest.completeDescription(stringBuilder, this.fields, this.filters, this.types, this.includeEmptyFields);
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new CancellableTask(id, type, action, "", parentTaskId, headers){

            @Override
            public String getDescription() {
                return FieldCapabilitiesRequest.this.getDescription();
            }
        };
    }
}

