/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.template.post;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.admin.indices.template.post.SimulateIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.put.TransportPutComposableIndexTemplateAction;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Nullable;

public class SimulateTemplateAction
extends ActionType<SimulateIndexTemplateResponse> {
    public static final SimulateTemplateAction INSTANCE = new SimulateTemplateAction();
    public static final String NAME = "indices:admin/index_template/simulate";

    private SimulateTemplateAction() {
        super(NAME);
    }

    public static class Request
    extends MasterNodeReadRequest<Request> {
        @Nullable
        private String templateName;
        @Nullable
        private TransportPutComposableIndexTemplateAction.Request indexTemplateRequest;
        private boolean includeDefaults = false;

        public Request() {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
        }

        public Request(String templateName) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            if (templateName == null) {
                throw new IllegalArgumentException("template name cannot be null");
            }
            this.templateName = templateName;
        }

        public Request(TransportPutComposableIndexTemplateAction.Request indexTemplateRequest) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT);
            if (indexTemplateRequest == null) {
                throw new IllegalArgumentException("index template body must be present");
            }
            this.indexTemplateRequest = indexTemplateRequest;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.templateName = in.readOptionalString();
            this.indexTemplateRequest = in.readOptionalWriteable(TransportPutComposableIndexTemplateAction.Request::new);
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                this.includeDefaults = in.readBoolean();
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.templateName);
            out.writeOptionalWriteable(this.indexTemplateRequest);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_9_X)) {
                out.writeBoolean(this.includeDefaults);
            }
        }

        @Override
        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indexTemplateRequest != null) {
                validationException = this.indexTemplateRequest.validateIndexTemplate(validationException);
            }
            if (this.templateName == null && this.indexTemplateRequest == null) {
                validationException = ValidateActions.addValidationError("either index name or index template body must be specified for simulation", validationException);
            }
            return validationException;
        }

        @Nullable
        public String getTemplateName() {
            return this.templateName;
        }

        public boolean includeDefaults() {
            return this.includeDefaults;
        }

        @Nullable
        public TransportPutComposableIndexTemplateAction.Request getIndexTemplateRequest() {
            return this.indexTemplateRequest;
        }

        public Request templateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public Request indexTemplateRequest(TransportPutComposableIndexTemplateAction.Request indexTemplateRequest) {
            this.indexTemplateRequest = indexTemplateRequest;
            return this;
        }

        public Request includeDefaults(boolean includeDefaults) {
            this.includeDefaults = includeDefaults;
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Request that = (Request)o;
            return this.templateName.equals(that.templateName) && Objects.equals(this.indexTemplateRequest, that.indexTemplateRequest) && this.includeDefaults == that.includeDefaults;
        }

        public int hashCode() {
            return Objects.hash(this.templateName, this.indexTemplateRequest, this.includeDefaults);
        }
    }
}

