/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.rollover;

import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.rollover.MetadataRolloverService;
import org.elasticsearch.action.admin.indices.rollover.RolloverRequest;
import org.elasticsearch.action.admin.indices.rollover.RolloverResponse;
import org.elasticsearch.action.admin.indices.rollover.TransportRolloverAction;
import org.elasticsearch.action.datastreams.autosharding.DataStreamAutoShardingService;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ActiveShardsObserver;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateTaskListener;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.metadata.MetadataDataStreamsService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.allocator.AllocationActionMultiListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.cluster.service.MasterServiceTaskQueue;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.features.NodeFeature;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public final class LazyRolloverAction
extends ActionType<RolloverResponse> {
    private static final Logger logger = LogManager.getLogger(LazyRolloverAction.class);
    public static final NodeFeature DATA_STREAM_LAZY_ROLLOVER = new NodeFeature("data_stream.rollover.lazy");
    public static final LazyRolloverAction INSTANCE = new LazyRolloverAction();
    public static final String NAME = "indices:admin/data_stream/lazy_rollover";

    private LazyRolloverAction() {
        super(NAME);
    }

    @Override
    public String name() {
        return NAME;
    }

    private static boolean isLazyRolloverNeeded(DataStream dataStream, boolean failureStore) {
        DataStream.DataStreamIndices indices = dataStream.getDataStreamIndices(failureStore);
        return indices.isRolloverOnWrite() || failureStore && indices.getIndices().isEmpty();
    }

    private static void notifyAllListeners(List<ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>> taskContexts, Consumer<ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>> onPublicationSuccess) {
        taskContexts.forEach(context -> context.success(() -> onPublicationSuccess.accept((ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>)context)));
    }

    private static RolloverResponse noopLazyRolloverResponse(DataStream.DataStreamIndices indices) {
        String latestWriteIndex = indices.getWriteIndex().getName();
        return new RolloverResponse(latestWriteIndex, latestWriteIndex, Map.of(), false, false, true, true, false);
    }

    record LazyRolloverExecutor(ClusterService clusterService, AllocationService allocationService, MetadataRolloverService rolloverService, ThreadPool threadPool) implements ClusterStateTaskExecutor<LazyRolloverTask>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterState execute(ClusterStateTaskExecutor.BatchExecutionContext<LazyRolloverTask> batchExecutionContext) {
            AllocationActionMultiListener<RolloverResponse> listener = new AllocationActionMultiListener<RolloverResponse>(this.threadPool.getThreadContext());
            ArrayList<String> results = new ArrayList<String>(batchExecutionContext.taskContexts().size());
            ClusterState state = batchExecutionContext.initialState();
            HashMap<RolloverRequest, List> groupedRequests = new HashMap<RolloverRequest, List>();
            for (ClusterStateTaskExecutor.TaskContext<LazyRolloverTask> taskContext2 : batchExecutionContext.taskContexts()) {
                groupedRequests.computeIfAbsent(taskContext2.getTask().rolloverRequest(), ignored -> new ArrayList()).add(taskContext2);
            }
            for (Map.Entry entry : groupedRequests.entrySet()) {
                List rolloverTaskContexts = (List)entry.getValue();
                try {
                    RolloverRequest rolloverRequest = (RolloverRequest)entry.getKey();
                    state = this.executeTask(state, rolloverRequest, results, rolloverTaskContexts, listener);
                }
                catch (Exception e) {
                    rolloverTaskContexts.forEach(taskContext -> taskContext.onFailure(e));
                }
                finally {
                    rolloverTaskContexts.forEach(taskContext -> taskContext.captureResponseHeaders().close());
                }
            }
            if (state != batchExecutionContext.initialState()) {
                StringBuilder reason = new StringBuilder();
                Strings.collectionToDelimitedStringWithLimit(results, ",", "lazy bulk rollover [", "]", 1024, reason);
                try (Releasable releasable = batchExecutionContext.dropHeadersContext();){
                    state = this.allocationService.reroute(state, reason.toString(), listener.reroute());
                }
            } else {
                listener.noRerouteNeeded();
            }
            return state;
        }

        public ClusterState executeTask(ClusterState currentState, RolloverRequest rolloverRequest, ArrayList<String> results, List<ClusterStateTaskExecutor.TaskContext<LazyRolloverTask>> rolloverTaskContexts, AllocationActionMultiListener<RolloverResponse> allocationActionMultiListener) throws Exception {
            DataStream dataStream = currentState.metadata().dataStreams().get(rolloverRequest.getRolloverTarget());
            assert (dataStream != null);
            if (!LazyRolloverAction.isLazyRolloverNeeded(dataStream, rolloverRequest.targetsFailureStore())) {
                DataStream.DataStreamIndices targetIndices = dataStream.getDataStreamIndices(rolloverRequest.targetsFailureStore());
                RolloverResponse noopResponse = LazyRolloverAction.noopLazyRolloverResponse(targetIndices);
                LazyRolloverAction.notifyAllListeners(rolloverTaskContexts, context -> ((LazyRolloverTask)context.getTask()).listener.onResponse(noopResponse));
                return currentState;
            }
            MetadataRolloverService.RolloverResult rolloverResult = this.rolloverService.rolloverClusterState(currentState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), List.of(), Instant.now(), false, false, null, null, rolloverRequest.targetsFailureStore());
            results.add(rolloverResult.sourceIndexName() + "->" + rolloverResult.rolloverIndexName());
            logger.trace("lazy rollover result [{}]", (Object)rolloverResult);
            String rolloverIndexName = rolloverResult.rolloverIndexName();
            String sourceIndexName = rolloverResult.sourceIndexName();
            TimeValue waitForActiveShardsTimeout = rolloverRequest.masterNodeTimeout().millis() < 0L ? null : rolloverRequest.masterNodeTimeout();
            LazyRolloverAction.notifyAllListeners(rolloverTaskContexts, context -> ActiveShardsObserver.waitForActiveShards(this.clusterService, new String[]{rolloverIndexName}, rolloverRequest.getCreateIndexRequest().waitForActiveShards(), waitForActiveShardsTimeout, allocationActionMultiListener.delay(((LazyRolloverTask)context.getTask()).listener()).map(isShardsAcknowledged -> new RolloverResponse(sourceIndexName, rolloverIndexName, Map.of(), false, true, true, (boolean)isShardsAcknowledged, false))));
            return rolloverResult.clusterState();
        }
    }

    record LazyRolloverTask(RolloverRequest rolloverRequest, ActionListener<RolloverResponse> listener) implements ClusterStateTaskListener
    {
        @Override
        public void onFailure(Exception e) {
            this.listener.onFailure(e);
        }
    }

    public static final class TransportLazyRolloverAction
    extends TransportRolloverAction {
        private final MasterServiceTaskQueue<LazyRolloverTask> lazyRolloverTaskQueue;

        @Inject
        public TransportLazyRolloverAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, MetadataRolloverService rolloverService, AllocationService allocationService, MetadataDataStreamsService metadataDataStreamsService, DataStreamAutoShardingService dataStreamAutoShardingService, Client client) {
            super(INSTANCE, transportService, clusterService, threadPool, actionFilters, indexNameExpressionResolver, rolloverService, client, allocationService, metadataDataStreamsService, dataStreamAutoShardingService);
            this.lazyRolloverTaskQueue = clusterService.createTaskQueue("lazy-rollover", Priority.NORMAL, new LazyRolloverExecutor(clusterService, allocationService, rolloverService, threadPool));
        }

        @Override
        protected void masterOperation(Task task, RolloverRequest rolloverRequest, ClusterState clusterState, ActionListener<RolloverResponse> listener) throws Exception {
            assert (task instanceof CancellableTask);
            assert (!(rolloverRequest.getConditions().hasConditions() || rolloverRequest.isDryRun() || rolloverRequest.isLazy())) : "The auto rollover action does not expect any other parameters in the request apart from the data stream name";
            Metadata metadata = clusterState.metadata();
            DataStream dataStream = metadata.dataStreams().get(rolloverRequest.getRolloverTarget());
            if (!LazyRolloverAction.isLazyRolloverNeeded(dataStream, rolloverRequest.targetsFailureStore())) {
                DataStream.DataStreamIndices targetIndices = dataStream.getDataStreamIndices(rolloverRequest.targetsFailureStore());
                listener.onResponse(LazyRolloverAction.noopLazyRolloverResponse(targetIndices));
                return;
            }
            MetadataRolloverService.NameResolution trialRolloverNames = MetadataRolloverService.resolveRolloverNames(clusterState, rolloverRequest.getRolloverTarget(), rolloverRequest.getNewIndexName(), rolloverRequest.getCreateIndexRequest(), rolloverRequest.targetsFailureStore());
            String trialSourceIndexName = trialRolloverNames.sourceName();
            String trialRolloverIndexName = trialRolloverNames.rolloverName();
            MetadataCreateIndexService.validateIndexName(trialRolloverIndexName, clusterState.metadata(), clusterState.routingTable());
            assert (metadata.dataStreams().containsKey(rolloverRequest.getRolloverTarget())) : "Auto-rollover applies only to data streams";
            String source = "lazy_rollover source [" + trialSourceIndexName + "] to target [" + trialRolloverIndexName + "]";
            RolloverRequest newRolloverRequest = new RolloverRequest(rolloverRequest.getRolloverTarget(), null);
            newRolloverRequest.setIndicesOptions(rolloverRequest.indicesOptions());
            LazyRolloverTask rolloverTask = new LazyRolloverTask(newRolloverRequest, listener);
            this.lazyRolloverTaskQueue.submitTask(source, rolloverTask, rolloverRequest.masterNodeTimeout());
        }
    }
}

