/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.node.reload;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsRequest;
import org.elasticsearch.action.admin.cluster.node.reload.NodesReloadSecureSettingsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.injection.guice.Inject;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.plugins.ReloadablePlugin;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportNodesReloadSecureSettingsAction
extends TransportNodesAction<NodesReloadSecureSettingsRequest, NodesReloadSecureSettingsResponse, NodesReloadSecureSettingsRequest.NodeRequest, NodesReloadSecureSettingsResponse.NodeResponse, Void> {
    public static final ActionType<NodesReloadSecureSettingsResponse> TYPE = new ActionType("cluster:admin/nodes/reload_secure_settings");
    private static final Logger logger = LogManager.getLogger(TransportNodesReloadSecureSettingsAction.class);
    private final Environment environment;
    private final PluginsService pluginsService;

    @Inject
    public TransportNodesReloadSecureSettingsAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, Environment environment, PluginsService pluginService) {
        super(TYPE.name(), clusterService, transportService, actionFilters, NodesReloadSecureSettingsRequest.NodeRequest::new, threadPool.executor("generic"));
        this.environment = environment;
        this.pluginsService = pluginService;
    }

    @Override
    protected NodesReloadSecureSettingsResponse newResponse(NodesReloadSecureSettingsRequest request, List<NodesReloadSecureSettingsResponse.NodeResponse> responses, List<FailedNodeException> failures) {
        return new NodesReloadSecureSettingsResponse(this.clusterService.getClusterName(), responses, failures);
    }

    @Override
    protected NodesReloadSecureSettingsRequest.NodeRequest newNodeRequest(NodesReloadSecureSettingsRequest request) {
        return request.newNodeRequest();
    }

    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse newNodeResponse(StreamInput in, DiscoveryNode node) throws IOException {
        return new NodesReloadSecureSettingsResponse.NodeResponse(in);
    }

    @Override
    protected DiscoveryNode[] resolveRequest(NodesReloadSecureSettingsRequest request, ClusterState clusterState) {
        boolean isNodeLocal;
        DiscoveryNode[] concreteNodes = super.resolveRequest(request, clusterState);
        boolean bl = isNodeLocal = concreteNodes.length == 1 && concreteNodes[0].getId().equals(clusterState.nodes().getLocalNodeId());
        if (request.hasPassword() && !isNodeLocal && !this.isNodeTransportTLSEnabled()) {
            throw new ElasticsearchException("Secure settings cannot be updated cluster wide when TLS for the transport layer is not enabled. Enable TLS or use the API with a `_local` filter on each node.", new Object[0]);
        }
        return concreteNodes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected NodesReloadSecureSettingsResponse.NodeResponse nodeOperation(NodesReloadSecureSettingsRequest.NodeRequest request, Task task) {
        try (KeyStoreWrapper keystore = KeyStoreWrapper.load(this.environment.configFile());){
            if (keystore == null) {
                NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), new IllegalStateException("Keystore is missing"));
                return nodeResponse;
            }
            keystore.decrypt(request.hasPassword() ? request.getSecureSettingsPassword().getChars() : new char[]{});
            Settings settingsWithKeystore = Settings.builder().put(this.environment.settings(), false).setSecureSettings(keystore).build();
            this.clusterService.getClusterSettings().validate(settingsWithKeystore, true);
            ArrayList exceptions = new ArrayList();
            this.pluginsService.filterPlugins(ReloadablePlugin.class).forEach(p -> {
                logger.debug("Reloading plugin [" + p.getClass().getSimpleName() + "]");
                try {
                    p.reload(settingsWithKeystore);
                }
                catch (Exception e) {
                    logger.warn(() -> "Reload failed for plugin [" + p.getClass().getSimpleName() + "]", (Throwable)e);
                    exceptions.add(e);
                }
            });
            ExceptionsHelper.rethrowAndSuppress(exceptions);
            NodesReloadSecureSettingsResponse.NodeResponse nodeResponse = new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), null);
            return nodeResponse;
        }
        catch (Exception e) {
            return new NodesReloadSecureSettingsResponse.NodeResponse(this.clusterService.localNode(), e);
        }
    }

    private boolean isNodeTransportTLSEnabled() {
        return this.transportService.isTransportSecure();
    }
}

