/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.matrix.decomposition.CholeskyDecomposition;
import org.ojalgo.matrix.decomposition.LDU;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.RawCholesky;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.structure.Access2D;
import org.ojalgo.type.context.NumberContext;

public interface Cholesky<N extends Comparable<N>>
extends LDU<N>,
MatrixDecomposition.Hermitian<N> {
    public static final Factory<ComplexNumber> COMPLEX = typical -> new CholeskyDecomposition.Complex();
    public static final Factory<Double> PRIMITIVE = typical -> {
        if (32L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
            return new CholeskyDecomposition.Primitive();
        }
        return new RawCholesky();
    };
    public static final Factory<Quaternion> QUATERNION = typical -> new CholeskyDecomposition.Quat();
    public static final Factory<RationalNumber> RATIONAL = typical -> new CholeskyDecomposition.Rational();

    public static <N extends Comparable<N>> boolean equals(MatrixStore<N> matrix, Cholesky<N> decomposition, NumberContext context) {
        boolean retVal = false;
        MatrixStore<Object> tmpL = decomposition.getL();
        retVal = Access2D.equals(tmpL.multiply(tmpL.conjugate()), matrix, context);
        return retVal;
    }

    default public MatrixStore<N> getL() {
        return this.getR().conjugate();
    }

    default public MatrixStore<N> getR() {
        return this.getL().conjugate();
    }

    public boolean isSPD();

    @Override
    default public MatrixStore<N> reconstruct() {
        MatrixStore<Object> mtrxL = this.getL();
        return mtrxL.multiply(mtrxL.conjugate());
    }

    public static interface Factory<N extends Comparable<N>>
    extends MatrixDecomposition.Factory<Cholesky<N>> {
    }
}

