/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.repositories.s3.S3BasicCredentials;
import org.elasticsearch.repositories.s3.S3Repository;

final class S3ClientSettings {
    private static final String PREFIX = "s3.client.";
    private static final String PLACEHOLDER_CLIENT = "placeholder";
    static final Setting.AffixSetting<SecureString> ACCESS_KEY_SETTING;
    static final Setting.AffixSetting<SecureString> SECRET_KEY_SETTING;
    static final Setting.AffixSetting<SecureString> SESSION_TOKEN_SETTING;
    static final Setting.AffixSetting<String> ENDPOINT_SETTING;
    static final Setting.AffixSetting<Protocol> PROTOCOL_SETTING;
    static final Setting.AffixSetting<String> PROXY_HOST_SETTING;
    static final Setting.AffixSetting<Integer> PROXY_PORT_SETTING;
    static final Setting.AffixSetting<Protocol> PROXY_SCHEME_SETTING;
    static final Setting.AffixSetting<SecureString> PROXY_USERNAME_SETTING;
    static final Setting.AffixSetting<SecureString> PROXY_PASSWORD_SETTING;
    static final Setting.AffixSetting<TimeValue> READ_TIMEOUT_SETTING;
    static final Setting.AffixSetting<Integer> MAX_CONNECTIONS_SETTING;
    static final Setting.AffixSetting<Integer> MAX_RETRIES_SETTING;
    static final Setting.AffixSetting<Boolean> USE_THROTTLE_RETRIES_SETTING;
    static final Setting.AffixSetting<Boolean> USE_PATH_STYLE_ACCESS;
    static final Setting.AffixSetting<Boolean> DISABLE_CHUNKED_ENCODING;
    static final Setting.AffixSetting<String> REGION;
    static final Setting.AffixSetting<String> SIGNER_OVERRIDE;
    final S3BasicCredentials credentials;
    final String endpoint;
    final Protocol protocol;
    final String proxyHost;
    final int proxyPort;
    final Protocol proxyScheme;
    final String proxyUsername;
    final String proxyPassword;
    final int readTimeoutMillis;
    final int maxConnections;
    final int maxRetries;
    final boolean throttleRetries;
    final boolean pathStyleAccess;
    final boolean disableChunkedEncoding;
    final String region;
    final String signerOverride;

    private S3ClientSettings(S3BasicCredentials credentials, String endpoint, Protocol protocol, String proxyHost, int proxyPort, Protocol proxyScheme, String proxyUsername, String proxyPassword, int readTimeoutMillis, int maxConnections, int maxRetries, boolean throttleRetries, boolean pathStyleAccess, boolean disableChunkedEncoding, String region, String signerOverride) {
        this.credentials = credentials;
        this.endpoint = endpoint;
        this.protocol = protocol;
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.proxyScheme = proxyScheme;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.readTimeoutMillis = readTimeoutMillis;
        this.maxConnections = maxConnections;
        this.maxRetries = maxRetries;
        this.throttleRetries = throttleRetries;
        this.pathStyleAccess = pathStyleAccess;
        this.disableChunkedEncoding = disableChunkedEncoding;
        this.region = region;
        this.signerOverride = signerOverride;
    }

    S3ClientSettings refine(Settings repositorySettings) {
        Settings normalizedSettings = Settings.builder().put(repositorySettings).normalizePrefix("s3.client.placeholder.").build();
        String newEndpoint = S3ClientSettings.getRepoSettingOrDefault(ENDPOINT_SETTING, normalizedSettings, this.endpoint);
        Protocol newProtocol = S3ClientSettings.getRepoSettingOrDefault(PROTOCOL_SETTING, normalizedSettings, this.protocol);
        String newProxyHost = S3ClientSettings.getRepoSettingOrDefault(PROXY_HOST_SETTING, normalizedSettings, this.proxyHost);
        int newProxyPort = S3ClientSettings.getRepoSettingOrDefault(PROXY_PORT_SETTING, normalizedSettings, this.proxyPort);
        Protocol newProxyScheme = S3ClientSettings.getRepoSettingOrDefault(PROXY_SCHEME_SETTING, normalizedSettings, this.proxyScheme);
        int newReadTimeoutMillis = Math.toIntExact(S3ClientSettings.getRepoSettingOrDefault(READ_TIMEOUT_SETTING, normalizedSettings, TimeValue.timeValueMillis((long)this.readTimeoutMillis)).millis());
        int newMaxConnections = S3ClientSettings.getRepoSettingOrDefault(MAX_CONNECTIONS_SETTING, normalizedSettings, this.maxConnections);
        int newMaxRetries = S3ClientSettings.getRepoSettingOrDefault(MAX_RETRIES_SETTING, normalizedSettings, this.maxRetries);
        boolean newThrottleRetries = S3ClientSettings.getRepoSettingOrDefault(USE_THROTTLE_RETRIES_SETTING, normalizedSettings, this.throttleRetries);
        boolean newPathStyleAccess = S3ClientSettings.getRepoSettingOrDefault(USE_PATH_STYLE_ACCESS, normalizedSettings, this.pathStyleAccess);
        boolean newDisableChunkedEncoding = S3ClientSettings.getRepoSettingOrDefault(DISABLE_CHUNKED_ENCODING, normalizedSettings, this.disableChunkedEncoding);
        S3BasicCredentials newCredentials = S3ClientSettings.checkDeprecatedCredentials(repositorySettings) ? S3ClientSettings.loadDeprecatedCredentials(repositorySettings) : this.credentials;
        String newRegion = S3ClientSettings.getRepoSettingOrDefault(REGION, normalizedSettings, this.region);
        String newSignerOverride = S3ClientSettings.getRepoSettingOrDefault(SIGNER_OVERRIDE, normalizedSettings, this.signerOverride);
        if (Objects.equals(this.endpoint, newEndpoint) && this.protocol == newProtocol && Objects.equals(this.proxyHost, newProxyHost) && this.proxyPort == newProxyPort && this.proxyScheme == newProxyScheme && newReadTimeoutMillis == this.readTimeoutMillis && this.maxConnections == newMaxConnections && this.maxRetries == newMaxRetries && newThrottleRetries == this.throttleRetries && Objects.equals(this.credentials, newCredentials) && newPathStyleAccess == this.pathStyleAccess && newDisableChunkedEncoding == this.disableChunkedEncoding && Objects.equals(this.region, newRegion) && Objects.equals(this.signerOverride, newSignerOverride)) {
            return this;
        }
        return new S3ClientSettings(newCredentials, newEndpoint, newProtocol, newProxyHost, newProxyPort, newProxyScheme, this.proxyUsername, this.proxyPassword, newReadTimeoutMillis, newMaxConnections, newMaxRetries, newThrottleRetries, newPathStyleAccess, newDisableChunkedEncoding, newRegion, newSignerOverride);
    }

    static Map<String, S3ClientSettings> load(Settings settings) {
        Set clientNames = settings.getGroups(PREFIX).keySet();
        HashMap<String, S3ClientSettings> clients = new HashMap<String, S3ClientSettings>();
        for (String clientName : clientNames) {
            clients.put(clientName, S3ClientSettings.getClientSettings(settings, clientName));
        }
        if (!clients.containsKey("default")) {
            clients.put("default", S3ClientSettings.getClientSettings(settings, "default"));
        }
        return Collections.unmodifiableMap(clients);
    }

    static boolean checkDeprecatedCredentials(Settings repositorySettings) {
        if (S3Repository.ACCESS_KEY_SETTING.exists(repositorySettings)) {
            if (!S3Repository.SECRET_KEY_SETTING.exists(repositorySettings)) {
                throw new IllegalArgumentException("Repository setting [" + S3Repository.ACCESS_KEY_SETTING.getKey() + " must be accompanied by setting [" + S3Repository.SECRET_KEY_SETTING.getKey() + "]");
            }
            return true;
        }
        if (S3Repository.SECRET_KEY_SETTING.exists(repositorySettings)) {
            throw new IllegalArgumentException("Repository setting [" + S3Repository.SECRET_KEY_SETTING.getKey() + " must be accompanied by setting [" + S3Repository.ACCESS_KEY_SETTING.getKey() + "]");
        }
        return false;
    }

    private static S3BasicCredentials loadDeprecatedCredentials(Settings repositorySettings) {
        assert (S3ClientSettings.checkDeprecatedCredentials(repositorySettings));
        try (SecureString key = (SecureString)S3Repository.ACCESS_KEY_SETTING.get(repositorySettings);){
            S3BasicCredentials s3BasicCredentials;
            block13: {
                SecureString secret = (SecureString)S3Repository.SECRET_KEY_SETTING.get(repositorySettings);
                try {
                    s3BasicCredentials = new S3BasicCredentials(key.toString(), secret.toString());
                    if (secret == null) break block13;
                }
                catch (Throwable throwable) {
                    if (secret != null) {
                        try {
                            secret.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                secret.close();
            }
            return s3BasicCredentials;
        }
    }

    /*
     * Exception decompiling
     */
    private static S3BasicCredentials loadCredentials(Settings settings, String clientName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static S3ClientSettings getClientSettings(Settings settings, String clientName) {
        try (SecureString proxyUsername = S3ClientSettings.getConfigValue(settings, clientName, PROXY_USERNAME_SETTING);){
            S3ClientSettings s3ClientSettings;
            block12: {
                SecureString proxyPassword = S3ClientSettings.getConfigValue(settings, clientName, PROXY_PASSWORD_SETTING);
                try {
                    s3ClientSettings = new S3ClientSettings(S3ClientSettings.loadCredentials(settings, clientName), S3ClientSettings.getConfigValue(settings, clientName, ENDPOINT_SETTING), S3ClientSettings.getConfigValue(settings, clientName, PROTOCOL_SETTING), S3ClientSettings.getConfigValue(settings, clientName, PROXY_HOST_SETTING), S3ClientSettings.getConfigValue(settings, clientName, PROXY_PORT_SETTING), S3ClientSettings.getConfigValue(settings, clientName, PROXY_SCHEME_SETTING), proxyUsername.toString(), proxyPassword.toString(), Math.toIntExact(S3ClientSettings.getConfigValue(settings, clientName, READ_TIMEOUT_SETTING).millis()), S3ClientSettings.getConfigValue(settings, clientName, MAX_CONNECTIONS_SETTING), S3ClientSettings.getConfigValue(settings, clientName, MAX_RETRIES_SETTING), S3ClientSettings.getConfigValue(settings, clientName, USE_THROTTLE_RETRIES_SETTING), S3ClientSettings.getConfigValue(settings, clientName, USE_PATH_STYLE_ACCESS), S3ClientSettings.getConfigValue(settings, clientName, DISABLE_CHUNKED_ENCODING), S3ClientSettings.getConfigValue(settings, clientName, REGION), S3ClientSettings.getConfigValue(settings, clientName, SIGNER_OVERRIDE));
                    if (proxyPassword == null) break block12;
                }
                catch (Throwable throwable) {
                    if (proxyPassword != null) {
                        try {
                            proxyPassword.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                proxyPassword.close();
            }
            return s3ClientSettings;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3ClientSettings that = (S3ClientSettings)o;
        return this.proxyPort == that.proxyPort && this.readTimeoutMillis == that.readTimeoutMillis && this.maxConnections == that.maxConnections && this.maxRetries == that.maxRetries && this.throttleRetries == that.throttleRetries && Objects.equals(this.credentials, that.credentials) && Objects.equals(this.endpoint, that.endpoint) && this.protocol == that.protocol && Objects.equals(this.proxyHost, that.proxyHost) && this.proxyScheme == that.proxyScheme && Objects.equals(this.proxyUsername, that.proxyUsername) && Objects.equals(this.proxyPassword, that.proxyPassword) && Objects.equals(this.disableChunkedEncoding, that.disableChunkedEncoding) && Objects.equals(this.region, that.region) && Objects.equals(this.signerOverride, that.signerOverride);
    }

    public int hashCode() {
        return Objects.hash(this.credentials, this.endpoint, this.protocol, this.proxyHost, this.proxyPort, this.proxyScheme, this.proxyUsername, this.proxyPassword, this.readTimeoutMillis, this.maxRetries, this.maxConnections, this.throttleRetries, this.disableChunkedEncoding, this.region, this.signerOverride);
    }

    private static <T> T getConfigValue(Settings settings, String clientName, Setting.AffixSetting<T> clientSetting) {
        Setting concreteSetting = clientSetting.getConcreteSettingForNamespace(clientName);
        return (T)concreteSetting.get(settings);
    }

    private static <T> T getRepoSettingOrDefault(Setting.AffixSetting<T> setting, Settings normalizedSettings, T defaultValue) {
        if (setting.getConcreteSettingForNamespace(PLACEHOLDER_CLIENT).exists(normalizedSettings)) {
            return S3ClientSettings.getConfigValue(normalizedSettings, PLACEHOLDER_CLIENT, setting);
        }
        return defaultValue;
    }

    static {
        try {
            Class.forName("org.elasticsearch.repositories.s3.S3RepositoryPlugin");
        }
        catch (ClassNotFoundException e) {
            throw new AssertionError((Object)e);
        }
        ACCESS_KEY_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"access_key", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        SECRET_KEY_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"secret_key", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        SESSION_TOKEN_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"session_token", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        ENDPOINT_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"endpoint", key -> new Setting(key, "", s -> s.toLowerCase(Locale.ROOT), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        PROTOCOL_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"protocol", key -> new Setting(key, "https", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        PROXY_HOST_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"proxy.host", key -> Setting.simpleString((String)key, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        PROXY_PORT_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"proxy.port", key -> Setting.intSetting((String)key, (int)80, (int)0, (int)65536, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        PROXY_SCHEME_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"proxy.scheme", key -> new Setting(key, "http", s -> Protocol.valueOf((String)s.toUpperCase(Locale.ROOT)), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        PROXY_USERNAME_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"proxy.username", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        PROXY_PASSWORD_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"proxy.password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueMillis((long)50000L), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        MAX_CONNECTIONS_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"max_connections", key -> Setting.intSetting((String)key, (int)50, (int)1, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        MAX_RETRIES_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"max_retries", key -> Setting.intSetting((String)key, (int)ClientConfiguration.DEFAULT_RETRY_POLICY.getMaxErrorRetry(), (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        USE_THROTTLE_RETRIES_SETTING = Setting.affixKeySetting((String)PREFIX, (String)"use_throttle_retries", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        USE_PATH_STYLE_ACCESS = Setting.affixKeySetting((String)PREFIX, (String)"path_style_access", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        DISABLE_CHUNKED_ENCODING = Setting.affixKeySetting((String)PREFIX, (String)"disable_chunked_encoding", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        REGION = Setting.affixKeySetting((String)PREFIX, (String)"region", key -> new Setting(key, "", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
        SIGNER_OVERRIDE = Setting.affixKeySetting((String)PREFIX, (String)"signer_override", key -> new Setting(key, "", Function.identity(), new Setting.Property[]{Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[0]);
    }
}

