SYD(5)

# NAME

syd - document format for writing Syd profiles

# API

Current version of the Syd command API is *3*. This version is *stable*.

# CONFIGURATION

Syd is configured through sandbox commands. For multiple matching rules
(e.g.  two rules matching the same path), _the last matching rule wins_.
There are two ways to supply sandbox commands. First, Syd may be
configured using a configuration file. The path to the configuration
file is speficied using the *-P* command line switch. More than one
configuration file may be specified this way. Single commands may also
be passed via *-m* command line switch.  Configuration profiles may be
applied using the *-p* command line switch. See the *PROFILES* section
for more information. Second, Syd may be configured using *magic*
_stat_(2) calls during runtime.  This is achieved by calling _stat_(2)
system call on the special path */dev/syd* followed by the sandbox
command. Note that runtime configuration is only possible if the sandbox
lock is *unset*. The system call _stat_(2) was chosen because it is
practical to invoke using builtin shell commands like:

```
; test -c /dev/syd/sandbox/read:on
```

which enables *Read Sandboxing* for a shell running under Syd. It is
also possible to query certain values using the return value of the
_stat_(2) call:

```
test -c /dev/syd/sandbox/read? && echo read sandboxing on || echo read sandboxing off
```

Note, some of these shell builtins may actually call other system calls such as
_fstat_(2), _lstat_(2), _newfstatat_(2), or _statx_(2). Syd supports the same
interface through all these system calls transparently. Check the manual page
_syd_(2) for a description of the _stat_(2) interface.

# NAMING

Configuration file naming of Syd follows a naming scheme which makes it
possible to extract command API version from the file name. A Syd
configuration file must have the extension *syd-* followed by the API version
(e.g. *"syd-3"* for API version *3*).

# SYNTAX

Input files must use the UTF-8 encoding. Config format is line oriented.
Comments start with "#". Inline comments are _not_ supported.  Blank
lines are ignored.  All the other lines are treated as if they were
supplied to Syd via the *-m* command line switch. For a list of
available sandbox commands, consult _syd_(2). For a VIM syntax file for
Syd profiles check here:
https://gitlab.exherbo.org/sydbox/sydbox/-/tree/main/vim

As of verson 3.15.1, Syd adds two additional features to configuration
file parsing:

. Enviroment variable expansion is performed on arguments. \
Notably, unset environment variables are not expanded \
to empty strings. On environment variable lookup errors and UTF-8 \
decoding errors Syd stops parsing and exits with error. This is done for \
safety as an unintended empty-string expansion can potentially cause the \
resulting sandboxing rule to allowlist unintended paths without the user \
easily noticing it. The user is recommended to set default values for \
environment variables using the familiar "${HOME:-/var/empty}" notation. \
If you really want empty-string expansion on unset environment \
variables, you can get this effect using the notation "${HOME:-}" but \
this is not recommended and should be used with care.
. "include" directives can be used to request the inclusion of another \
configuration file. Upon reading an include line, Syd stops parsing the \
current file, validates the given include path and start to parse the \
new configuration file. The file must not be writable by group or others \
for safety. For include files with relative paths, Syd searches the file \
under the directory of the previous configuration file rather \
than the current working directory for safety and ease of \
configuration.  Loops in include directives are detected by \
caching the device id and inode of the configuration files. Note, \
this directive is not permitted when loading configuration \
from a file descriptor using the "load" command.

As of version 3.17.6, Syd adds the "include_profile" directive which may be
used to include a Syd profile. See "syd-cat -p list" for the list of profiles.

# PROFILES

Syd has a number of predefined profiles to make configuration easier.
These profiles may be used standalone or stacked with other profiles and
custom configuration to create various levels of isolation and
confinement. To see the complete list of profiles, use "syd-cat -p list".
To list the rules of a profile, use "syd-cat -p <profile-name>". Below you
may find a brief list of common profiles and their functionality:

|[ *container*
:< Enables Linux namespaces.
|[
:< You may refer to this profile shortly as just *c*.
|[ *immutable*
:< Enables Linux namespaces and remounts the following directories _read only_ in the new mount namespace:
|[
:< */etc*, */home*, */media*, */mnt*, */opt*, */srv*, and */usr*.
|[
:< Further mount options such as *nodev*, *noexec*, *nosuid*, and *noatime* are also applied as necessary.
|[
:< In addition, */dev/shm* and */tmp* are mounted private and kernel filesystems are masked.
|[
:< See *syd-cat -p immutable* for the full list of mount options.
|[
:< You may refer to this profile shortly as just *i*.
|[ *privileged*
:< Do not drop Linux capabilities at startup. Used to construct privileged containers.
|[
:< You may refer to this profile shortly as just *p*.
|[ *readonly*
:< Deny all write sandbox capabilities to the entire root filesystem.
|[
:< You may refer to this profile shortly as just *ro*.
|[ *landlock*
:< Enables *LandLock* and allows system directories for *Lock Sandboxing*.
|[
:< You may refer to this profile shortly as just *l*.
|[ *linux*
:< Common Linux system profile, used by *oci*, *paludis* and *user* profiles.
|[ *oci*
:< Used by _syd-oci_(1) as the default container profile.
|[ *paludis*
:< Used by the *Paludis* package mangler.
|[ *noipv4*
:< Disables *IPv4* connectivity.
|[
:< You may refer to this profile shortly as just *6*.
|[ *noipv6*
:< Disables *IPv6* connectivity.
|[
:< You may refer to this profile shortly as just *4*.
|[ *core*
:< Allows generation of coredumps.
|[
:< You may refer to this profile shortly as just *C*.
|[ *debug*
:< Allows debuggers inside the sandbox.
|[
:< Syd does not use _ptrace_(1) with this profile, so tracers may attach.
|[
:< You may refer to this profile shortly as just *D*.
|[ *nomem*
:< Allows unsafe memory (no W^X, no Memory-Deny-Write-Execute, allows e.g. JITs).
|[
:< You may refer to this profile shortly as just *M*.
|[ *nopie*
:< Relaxes PIE (Position Independent Executable) restriction.
|[
:< You may refer to this profile shortly as just *P*.
|[ *quiet*
:< Silences all access violations.
|[
:< You may refer to this profile shortly as just *q*.
|[ *off*
:< Turns all sandboxing off.
|[ *lib*
:< *libsyd* helper profile. Turns all sandboxing off and sets sandbox lock to "exec".
|[
:< Useful to configure Syd in the application using *libsyd*.
|[ *user*
:< Allows user-specific directories, and connections, and parses the files
|[
:< */etc/user.syd-3*, and *~/.user.syd-3* if they exist.
|[
:< Syd sets the environment variables *SYD_UID*, *SYD_GID*, *SYD_USER*, *SYD_HOME* before parsing this profile.
|[
:< To enforce system-wide settings, set "lock:on" at the end of */etc/user.syd-3*.
|[
:< You may refer to this profile shortly as just *u*.
|[ *kvm*
:< Profile to allowlist KVM _ioctl_(2) requests without path check.
|[
:< Read: https://www.kernel.org/doc/Documentation/virtual/kvm/api.txt
|[ *tty*
:< Profile to allow TTY access, used by *oci*, *paludis*, and *user* profiles.
|[
:< Syd sets the environment variable *SYD_TTY* before parsing this profile.
|[
:< If the process has no controlling terminal, *SYD_TTY* variable is set to "/dev/null".
|[ *firefox*
:< Profile to relax restrictions to enable running Firefox family browsers.
|[
:< You may refer to this profile shortly as just *ff*.

## Stacking Profiles

It is possible to stack multiple profiles to configure a more restricted
sandbox. Remember the order you stack the profiles matter, _the last matching
rule wins_. Below are some examples:

- syd -puser -pimmutable -mroot:/mnt/gnu ...
- syd -ppaludis -plandlock -mallow/lock/write+/var/tmp ...

It is also possible to combine the one character shortcuts of helper profiles,
in order to stack them together. Below are some examples:

- syd -pMPX ... # Disable MDWE, PIE and exec restrictions.
- syd -puiq ... # Parse user profile, create an immutable container, and silence access violations.

## Login shell and the User Profile

When invoked without arguments, */bin/sh* is executed under Syd with the
*user* profile as a login shell, use *SYD_SH* environment variable to override
the shell to execute.

# SECURITY

As of version 3.30.0, Syd aborts with error if path to a specified
configuration file has a symbolic link in _any_ of its path components.

Therefore, the user _must_ supply canonicalized paths as configuration
file arguments.

# EXAMPLE

```
# Syd profile for OpenNTPD

# Seccomp sandbox
sandbox/read,stat,write,exec,net:on

# Landlock
sandbox/lock:on

# Provide isolation using namespaces.
unshare/mount,uts,pid,ipc,cgroup:1

# Allow adjtimex and keep CAP_SYS_TIME.
trace/allow_unsafe_time:1

# Mount everything ro except /var
bind+tmpfs:/dev/shm:nodev,nosuid,noexec
bind+tmpfs:/tmp:nodev,nosuid
bind+/etc:/etc:ro,nodev,noexec,nosuid,noatime
bind+/home:/home:ro,nodev,noexec,nosuid,noatime
bind+/media:/media:ro,nodev,noexec,nosuid,noatime
bind+/mnt:/mnt:ro,nodev,noexec,nosuid,noatime
bind+/opt:/opt:ro,nodev,nosuid,noatime
bind+/srv:/srv:ro,nodev,noexec,nosuid,noatime
bind+/usr:/usr:ro,nodev,noatime

# Hide Syd
deny/read,stat,write+/proc/1/***

# Allow listen to the ntp port on loopback.
allow/net/bind+loopback!123

# Allow connections to NTP servers.
allow/net/connect+any!53
allow/net/connect+any!123
allow/net/connect+any!65535

# Allow logging to syslog.
allow/net/connect+/dev/log

# Allow `listen wildcard`
allow/net/bind+0.0.0.0!0
allow/net/connect+0.0.0.0!0

# Allow listen to the ntpd socket.
allow/net/bind+/run/ntpd.sock
allow/net/bind+/var/run/ntpd.sock
allow/write+/run/ntpd.sock
allow/write+/var/run/ntpd.sock

# Allow access to system paths
allow/read,stat+/dev/urandom
allow/lock/read+/dev/urandom
allow/read,stat+/etc/hosts
allow/lock/read+/etc/hosts
allow/read,stat+/etc/ntpd.conf
allow/lock/read+/etc/ntpd.conf
allow/read,stat+/etc/passwd
allow/lock/read+/etc/passwd
allow/read,stat+/etc/resolv.conf
allow/lock/read+/etc/resolv.conf
allow/read,stat+/etc/services
allow/lock/read+/etc/services
allow/read,stat+/usr/share/zoneinfo-posix/UTC

# chroot /var/empty && cd /
allow/stat+/
allow/stat+/var/empty
allow/write+/dev/null
allow/lock/write+/dev/null

# Allow executing the ntp binary.
allow/lock/read+/proc
allow/lock/read+/usr
allow/lock/write+/run
allow/lock/write+/var/run
allow/exec+/usr/**/bin/openntpd*

# Allow writing the drift file.
allow/write+/var/db/ntpd.drift
allow/lock/write+/var/db/ntpd.drift

# Lock configuration
lock:on
```

# SEE ALSO

_syd_(1), _syd_(2), _syd_(7)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
