#ifndef FILE_H
#define FILE_H

#include <QDir>

namespace File {
    enum LoadMode { NewMap, DefaultMap, ImportAdd, ImportReplace };
    enum SaveMode { PartOfMap, CompleteMap, CodeBlock };
    enum FileType { VymMap, FreemindMap, IThoughtsMap, UnknownMap };
}

/////////////////////////////////////////////////////////////////////////////
QString convertToRel(const QString &, const QString &);
QString convertToAbs(const QString &, const QString &);
QString basename(const QString &);
QString dirname(const QString &);

QStringList openImageDialog(const QString &windowTitle);

bool confirmDirectoryOverwrite(const QDir &dir);

QString makeTmpDir(bool &ok, const QString &dirPath, const QString &prefix);
QString makeTmpDir(bool &ok, const QString &prefix);
bool isInTmpDir(QString fn);
QString makeUniqueDir(bool &ok, QString);
bool removeDir(QDir);
bool copyDir(QDir src, QDir dst, const bool &override = false);
bool subDirsExist();
void makeSubDirs(const QString &);

bool loadStringFromDisk(const QString &fn, QString &s);
bool saveStringToDisk(const QString &fn, const QString &s);
bool appendStringToFile(const QString &fn, const QString &s);

File::FileType getMapType(const QString &fn);

//////////////////////////////////////////////////////////
// Helper function to select image format while in SaveDialogs

class ImageIO {
  public:
    ImageIO();
    QStringList getFilters();
    QString getType(QString);
    QString guessType(QString);

  private:
    QStringList imageFilters;
    QStringList imageTypes;
};

#endif
