---
myst:
  html_meta:
    keywords: LaTeX, fichiers, fontes, concepts, polices de caractères, 
              noms des fichiers
---

# Qu'est-ce que la convention de nommage de Berry ?

Fut un temps, les distributions de (La)TeX étaient limitées 
par la faible capacité des systèmes de fichiers à représenter des noms longs.
Ainsi, le système de fichiers MS-DOS était particulièrement pénible : 
fort heureusement, tous les systèmes Microsoft actuels permettent une plus grande liberté 
dans la spécification des noms de fichiers. 
De même, la norme ISO 9660 pour la structure des CD-ROM présente un défaut similaire, 
mais elle a également été modifiée par divers mécanismes d'extension.

Un domaine dans lequel ces noms de fichiers courts posent un problème particulier 
est celui des noms de fichiers pour les polices de type 1. 
Ces polices sont distribuées par leurs vendeurs avec des noms courts assez vides de sens. 
Naturellement, certains souhaiteraient changer ces noms pour quelque chose 
qui identifie la police avec une certaine précision. 

Malheureusement, des noms tels que `BaskervilleMT` dépassent déjà largement 
les faibles capacités de ces systèmes à noms de fichiers courts et, 
si l'on ajoute la spécification d'une forme ou d'une variante de police, 
les difficultés deviennent incontrôlables. 
Les fonderies traitent le problème en inventant chacune son sytème de nom et 
en fournissant un fichier de correspondance pour indiquer les "vrais" noms. 
Ainsi, la société Monotype Corporation fournit par exemple les correspondances suivantes :

```text
bas_____ BaskervilleMT
basb____ BaskervilleMT-Bold
basbi___ BaskervilleMT-BoldItalic
```

Ces noms pourraient être utilisés dans les programmes (La)TeX, 
sauf qu'ils ne sont pas uniques : 
rien n'empêche Adobe d'utiliser `bas_____` pour *leur* police *Baskerville*.

C'est ainsi qu'est né la convention de nommage de Berry (*Berry naming scheme*).

La base de ce système est d'encoder les significations 
des différentes parties de la spécification du fichier d'une manière extrêmement laconique,
de sorte que suffisamment de noms de polices puissent être exprimés 
même dans des espaces de noms de fichiers appauvris. 
Le codage attribue un caractère à la fonderie (Adobe, Monotype, etc.), 
deux au nom de la police (*Baskerville*, *Times Roman*, etc.), 
un à la graisse, à la forme, au codage, etc.

L'ensemble du système est décrit dans la distribution <ctanpkg:fontname>, 
qui comprend une documentation complète 
et un ensemble de tableaux de polices dont les noms ont été systématisés.

:::{sources}
[What is the "Berry naming scheme"?](faquk:FAQ-fontname)
:::
