% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uwot.R
\name{save_uwot}
\alias{save_uwot}
\title{Save or Load a Model}
\usage{
save_uwot(model, file, unload = FALSE, verbose = FALSE)
}
\arguments{
\item{model}{a UMAP model create by \code{\link{umap}}.}

\item{file}{name of the file where the model is to be saved or read from.}

\item{unload}{if \code{TRUE}, unload all nearest neighbor indexes for the
model. The \code{model} will no longer be valid for use in
\code{\link{umap_transform}} and the temporary working directory used
during model saving will be deleted. You will need to reload the model with
\code{load_uwot} to use the model. If \code{FALSE}, then the model can be
re-used without reloading, but you must manually unload the NN index when
you are finished using it if you want to delete the temporary working
directory. To unload manually, use \code{\link{unload_uwot}}. The absolute
path of the working directory is found in the \code{mod_dir} item of the
return value.}

\item{verbose}{if \code{TRUE}, log information to the console.}
}
\value{
\code{model} with one extra item: \code{mod_dir}, which contains the
  path to the working directory. If \code{unload = FALSE} then this directory
  still exists after this function returns, and can be cleaned up with
  \code{\link{unload_uwot}}. If you don't care about cleaning up this
  directory, or \code{unload = TRUE}, then you can ignore the return value.
}
\description{
Functions to write a UMAP model to a file, and to restore.
}
\examples{
iris_train <- iris[c(1:10, 51:60), ]
iris_test <- iris[100:110, ]

# create model
model <- umap(iris_train, ret_model = TRUE, n_epochs = 20)

# save without unloading: this leaves behind a temporary working directory
model_file <- tempfile("iris_umap")
model <- save_uwot(model, file = model_file)

# The model can continue to be used
test_embedding <- umap_transform(iris_test, model)

# To manually unload the model from memory when finished and to clean up
# the working directory (this doesn't touch your model file)
unload_uwot(model)

# At this point, model cannot be used with umap_transform, this would fail:
# test_embedding2 <- umap_transform(iris_test, model)

# restore the model: this also creates a temporary working directory
model2 <- load_uwot(file = model_file)
test_embedding2 <- umap_transform(iris_test, model2)

# Unload and clean up the loaded model temp directory
unload_uwot(model2)

# clean up the model file
unlink(model_file)

# save with unloading: this deletes the temporary working directory but
# doesn't allow the model to be re-used
model3 <- umap(iris_train, ret_model = TRUE, n_epochs = 20)
model_file3 <- tempfile("iris_umap")
model3 <- save_uwot(model3, file = model_file3, unload = TRUE)

}
\seealso{
\code{\link{load_uwot}}, \code{\link{unload_uwot}}
}
