% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/usethis-package.R
\name{usethis_options}
\alias{usethis_options}
\title{Options consulted by usethis}
\description{
User-configurable options consulted by usethis, which provide a mechanism
for setting default behaviors for various functions.

If the built-in defaults don't suit you, set one or more of these options.
Typically, this is done in the \code{.Rprofile} startup file, which you can open
for editing with \code{\link[=edit_r_profile]{edit_r_profile()}} - this will set the specified options for
all future R sessions. Your code will look something like:

\if{html}{\out{<div class="sourceCode">}}\preformatted{options(
  usethis.description = list(
    "Authors@R" = utils::person(
      "Jane", "Doe",
      email = "jane@example.com",
      role = c("aut", "cre"),
      comment = c(ORCID = "YOUR-ORCID-ID")
    ),
    License = "MIT + file LICENSE"
  ),
  usethis.destdir = "/path/to/folder/", # for use_course(), create_from_github()
  usethis.protocol = "ssh", # Use ssh git protocol
  usethis.overwrite = TRUE # overwrite files in Git repos without confirmation
)
}\if{html}{\out{</div>}}
}
\section{Options for the usethis package}{

\itemize{
\item \code{usethis.description}: customize the default content of new \code{DESCRIPTION}
files by setting this option to a named list.
If you are a frequent package developer, it is worthwhile to pre-configure
your preferred name, email, license, etc. See the example above and the
\href{https://usethis.r-lib.org/articles/articles/usethis-setup.html}{article on usethis setup}
for more details.
\item \code{usethis.destdir}: Default directory in which to place new projects
downloaded by \code{\link[=use_course]{use_course()}} and \code{\link[=create_from_github]{create_from_github()}}.
If this option is unset, the user's Desktop or similarly conspicuous place
will be used.
\item \code{usethis.protocol}: specifies your preferred transport protocol for Git.
Either "https" (default) or "ssh":
\itemize{
\item \code{usethis.protocol = "https"} implies \verb{https://github.com/<OWNER>/<REPO>.git}
\item \code{usethis.protocol = "ssh"} implies \verb{git@github.com:<OWNER>/<REPO>.git}
}

You can also change this for the duration of your R session with
\code{\link[=use_git_protocol]{use_git_protocol()}}.
\item \code{usethis.overwrite}: If \code{TRUE}, usethis overwrites an existing file without
asking for user confirmation if the file is inside a Git repo. The
rationale is that the normal Git workflow makes it easy to see and
selectively accept/discard any proposed changes.
\item \code{usethis.quiet}: Set to \code{TRUE} to suppress user-facing messages. Default
\code{FALSE}.
\item \code{usethis.allow_nested_project}: Whether or not to allow
you to create a project inside another project. This is rarely a good idea,
so this option defaults to \code{FALSE}.
}
}

