% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot.npsurv.r
\name{ggplot.npsurv}
\alias{ggplot.npsurv}
\title{Title Plot npsurv Nonparametric Survival Curves Using ggplot2}
\usage{
\method{ggplot}{npsurv}(
  data,
  mapping,
  conf = c("bands", "none"),
  trans = c("identity", "logit", "probit", "loglog"),
  logt = FALSE,
  curtail = c(0, 1),
  xlab,
  ylab = "Survival Probability",
  abbrev.label = FALSE,
  levels.only = TRUE,
  alpha = 0.15,
  facet = FALSE,
  npretty = 10,
  onlydata = FALSE,
  ...,
  environment
)
}
\arguments{
\item{data}{the result of npsurv}

\item{mapping}{unused}

\item{conf}{set to \code{"none"} to suppress confidence bands}

\item{trans}{the name of a transformation for the survival probabilities to use in drawing the y-axis scale.  The default is no transformation, and other choices are \verb{"logit", "probit", "loglog"}.  \code{"loglog"} represents \eqn{-log(-log(S(t)))}}

\item{logt}{set to \code{TRUE} to use a log scale for the x-axis}

\item{curtail}{set to a (lower, upper) 2-vector to curtail survival probabilities and confidence limits before transforming and plotting}

\item{xlab}{x-axis label, the default coming from \code{fit}}

\item{ylab}{y-axis label, the default coming from \code{fit}}

\item{abbrev.label}{set to \code{TRUE} to abbreviate strata levels}

\item{levels.only}{set to \code{FALSE} to keep the original strata name in the levels}

\item{alpha}{transparency for confidence bands}

\item{facet}{when strata are present, set to \code{TRUE} to facet them rather than using colors on one panel}

\item{npretty}{the number of major tick mark labels to be constructed by \code{\link[scales:breaks_pretty]{scales::breaks_pretty()}} or \code{\link[=pretty]{pretty()}}.  For transformed scales, twice this number is used.}

\item{onlydata}{set to \code{TRUE} to return the data frame to be plotted, and no plot}

\item{...}{ignored}

\item{environment}{unused}
}
\value{
a \code{ggplot2} object, if \code{onlydata=FALSE}
}
\description{
Title Plot npsurv Nonparametric Survival Curves Using ggplot2
}
\examples{
set.seed(1)
g <- c(rep('a', 500), rep('b', 500))
y <- exp(-1 + 2 * (g == 'b') + rlogis(1000) / 3)
f <- npsurv(Surv(y) ~ g)
ggplot(f, trans='logit', logt=TRUE)
}
\author{
Frank Harrell
}
