% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list-simplify.R
\name{list_simplify}
\alias{list_simplify}
\title{Simplify a list to an atomic or S3 vector}
\usage{
list_simplify(x, ..., strict = TRUE, ptype = NULL)
}
\arguments{
\item{x}{A list.}

\item{...}{These dots are for future extensions and must be empty.}

\item{strict}{What should happen if simplification fails? If \code{TRUE}
(the default) it will error. If \code{FALSE} and \code{ptype} is not supplied,
it will return \code{x} unchanged.}

\item{ptype}{An optional prototype to ensure that the output type is always
the same.}
}
\value{
A vector the same length as \code{x}.
}
\description{
Simplification maintains a one-to-one correspondence between the input
and output, implying that each element of \code{x} must contain a one element
vector or a one-row data frame. If you don't want to maintain this
correspondence, then you probably want either \code{\link[=list_c]{list_c()}}/\code{\link[=list_rbind]{list_rbind()}} or
\code{\link[=list_flatten]{list_flatten()}}.
}
\examples{
list_simplify(list(1, 2, 3))

# Only works when vectors are length one and have compatible types:
try(list_simplify(list(1, 2, 1:3)))
try(list_simplify(list(1, 2, "x")))

# Unless you strict = FALSE, in which case you get the input back:
list_simplify(list(1, 2, 1:3), strict = FALSE)
list_simplify(list(1, 2, "x"), strict = FALSE)
}
