% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Classification.R
\name{PRAUC}
\alias{PRAUC}
\title{Area Under the Precision-Recall Curve (PR AUC)}
\usage{
PRAUC(y_pred, y_true)
}
\arguments{
\item{y_pred}{Predicted probabilities vector, as returned by a classifier}

\item{y_true}{Ground truth (correct) 0-1 labels vector}
}
\value{
Area Under the PR Curve (PR AUC)
}
\description{
Compute the Area Under the Precision-Recall Curve (PR AUC) from prediction scores.
}
\examples{
data(cars)
logreg <- glm(formula = vs ~ hp + wt,
              family = binomial(link = "logit"), data = mtcars)
PRAUC(y_pred = logreg$fitted.values, y_true = mtcars$vs)
}

