% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge_aes.R
\name{edge_aes}
\alias{edge_aes}
\title{Insert edge aesthetic attributes during edge creation}
\usage{
edge_aes(
  style = NULL,
  penwidth = NULL,
  color = NULL,
  arrowsize = NULL,
  arrowhead = NULL,
  arrowtail = NULL,
  fontname = NULL,
  fontsize = NULL,
  fontcolor = NULL,
  len = NULL,
  tooltip = NULL,
  URL = NULL,
  label = NULL,
  labelfontname = NULL,
  labelfontsize = NULL,
  labelfontcolor = NULL,
  labeltooltip = NULL,
  labelURL = NULL,
  edgetooltip = NULL,
  edgeURL = NULL,
  dir = NULL,
  headtooltip = NULL,
  headURL = NULL,
  headclip = NULL,
  headlabel = NULL,
  headport = NULL,
  tailtooltip = NULL,
  tailURL = NULL,
  tailclip = NULL,
  taillabel = NULL,
  tailport = NULL,
  decorate = NULL
)
}
\arguments{
\item{style}{The edge line style. The \code{style} types that can be used are
\code{solid}, \code{bold}, \code{dashed}, \code{dotted}, \code{tapered}, and \code{invisible}.}

\item{penwidth}{The thickness of the stroke line for the edge itself.}

\item{color}{The color of the edge. Can be an X11 color or a hexadecimal
color code.}

\item{arrowsize}{A scaling factor for arrowheads. The default value is \code{1.0}
and the minimum is \code{0}.}

\item{arrowhead}{The type of arrowhead to use. The \code{style} attribute can be
any of these types: \code{normal}, \code{vee}, \code{tee}, \code{dot}, \code{diamond}, \code{box},
\code{curve}, \code{icurve}, \code{inv}, \code{crow}, or \code{none}.}

\item{arrowtail}{The type of arrowtail to use. The \code{style} attribute can any
of these types: \code{normal}, \code{vee}, \code{tee}, \code{dot}, \code{diamond}, \code{box}, \code{curve},
\code{icurve}, \code{inv}, \code{crow}, or \code{none}.}

\item{fontname}{The name of the system font that will be used for any edge
text.}

\item{fontsize}{The point size of the font used for any edge text.}

\item{fontcolor}{The color used for any edge text. Can be an X11 color or a
hexadecimal color code.}

\item{len}{The preferred edge length for an edge, in inches. Default value is
\code{1.0}.}

\item{tooltip}{Text for a tooltip that appears when hovering over an edge. If
text is not provided, then the default tooltip text will provide the edge
definition (i.e., \verb{[id]->[id] or [id]--[id]}).}

\item{URL}{A URL to associate with an edge. Upon rendering the plot, clicking
edges with any associated URLs will open the URL in the default browser.}

\item{label}{The label text associated with the edge. This text will appear
near the center of the edge.}

\item{labelfontname}{The name of the system font that will be used for the
\code{headlabel} and the \code{taillabel} label text. If not set, the \code{fontname}
value will instead be used.}

\item{labelfontsize}{The point size of the font used for the \code{headlabel} and
the \code{taillabel} label text. If not set, the \code{fontsize} value will instead
be used.}

\item{labelfontcolor}{The color used for the label text of the \code{headlabel}
and the \code{taillabel} label text. If not set, the \code{fontcolor} value will
instead be used. Can be an X11 color or a hexadecimal color code.}

\item{labeltooltip}{Text for a tooltip that will appear when hovering over
the main label of an edge (if label text provided in the \code{label} edge
attribute). If text is not provided and an edge label is visible, then the
default tooltip text will provide the edge definition (i.e., \verb{[id]->[id] or [id]--[id]}).}

\item{labelURL}{A URL to associate with edge label text. Upon rendering the
plot, clicking edge labels with any associated URLs will open the URL in
the default browser.}

\item{edgetooltip}{This option provides a means to specify a tooltip with
only the non-label parts of an edge. If this is defined, the value
overrides any \code{tooltip} defined for the edge. This tooltip text is when
hovering along the edge (even near the head or tail node) unless overridden
by a \code{headtooltip} or \code{tailtooltip} value.}

\item{edgeURL}{This option provides a means to specify a URL with only the
non-label parts of an edge. If this is defined, the value overrides any
\code{URL} defined for the edge. This URL is used along the edge (even near the
head or tail node) unless overridden by a \code{headURL} or \code{tailURL} value.}

\item{dir}{An optional direction type. Normally, for directed graphs, this is
\code{forward} and needn't be set. For undirected graphs, this would be \code{none}
and again no explicit setting is required. However, one can also use the
\code{back} or \code{both} options. The \code{back} option draws an arrowhead in the
reverse direction of an edge. The \code{both} option draws two arrowheads. When
using any of these options in such an explicit manner, the \code{head...} and
\code{tail...} edge attributes allow control over aesthetic edge attributes in
either side of the edge.}

\item{headtooltip}{This option provides a means to specify a tooltip that can
be displayed by hovering over the part of an edge that is adjacent to
incoming node (see the \code{tooltip} argument for further details).}

\item{headURL}{This option provides a means to specify a URL that can be
accessed by clicking the part of an edge that is adjacent to incoming node
(see the \code{URL} argument for further details).}

\item{headclip}{If \code{TRUE} (the default behavior), then the head of the
affected edge is clipped to the node boundary. Using \code{FALSE} places the
head of the outgoing edge at the center of its node.}

\item{headlabel}{This option provides a means to display a label near the
part of an edge that is adjacent to incoming node (see the \code{label} argument
for further details).}

\item{headport}{Allows one to specify which compass position on the incoming
node the head of the edge will alight. Options are \code{n}, \code{ne}, \code{e}, \code{se},
\code{s}, \code{sw}, \code{w}, and \code{nw}.}

\item{tailtooltip}{This option provides a means to specify a tooltip that can
be displayed by hovering over the part of an edge that is adjacent to
outgoing node (see the \code{tooltip} argument for further details).}

\item{tailURL}{This option provides a means to specify a URL that can be
accessed by clicking the part of an edge that is adjacent to outgoing node
(see the \code{URL} argument for further details).}

\item{tailclip}{If \code{TRUE} (the default behavior), then the tail of the
affected edge is clipped to the node boundary. Using \code{FALSE} places the
tail of the outgoing edge at the center of its node.}

\item{taillabel}{This option provides a means to display a label near the
part of an edge that is adjacent to outgoing node (see the \code{label} argument
for further details).}

\item{tailport}{Allows one to specify which compass position on the outgoing
node the tail of the edge will be emitted from. Options are \code{n}, \code{ne}, \code{e},
\code{se}, \code{s}, \code{sw}, \code{w}, and \code{nw}.}

\item{decorate}{If \code{TRUE} then attach any edge label to the edge line via a
2-segment polyline, underlining the label text and partially overlapping
the edge line.}
}
\description{
This helper function should be invoked to provide values for the namesake
\code{edge_aes} argument, which is present in any function where edges are
created.
}
\examples{
# Create a new graph and add
# a path with several edge
# aesthetic attributes
graph <-
  create_graph() \%>\%
  add_path(
    n = 3,
    type = "path",
    edge_aes = edge_aes(
      style = "dot",
      color = c("red", "blue")))

# View the graph's internal
# node data frame; the node
# aesthetic attributes have
# been inserted
graph \%>\%
  get_edge_df()

}
\seealso{
Other aesthetics: 
\code{\link{node_aes}()},
\code{\link{node_edge_aes_data}}
}
\concept{aesthetics}
