% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{condition_summary}
\alias{condition_summary}
\alias{condition_summary.data.frame}
\alias{condition_summary.basis}
\title{Produce basis summary statistics for each (environmental) condition}
\usage{
condition_summary(data, ...)

\method{condition_summary}{data.frame}(data, x, condition, ref_condition = NULL, ...)

\method{condition_summary}{basis}(data, ref_condition = NULL, ...)
}
\arguments{
\item{data}{a \code{data.frame} or a \code{basis} object}

\item{...}{not used}

\item{x}{the column name of the variable of interest (usually strength)}

\item{condition}{the column name for the condition}

\item{ref_condition}{a \code{character} representing the reference condition}
}
\value{
a \code{data.frame}
}
\description{
Produces a \code{data.frame} containing the sample size and mean for each
condition. If a reference condition (e.g. "RTD") is specified, the ratio
of each condition mean value to the mean value for the reference condition
is also calculated. If a \code{basis} object returned by one of the
\code{basis_pooled} functions is given as an argument, this table also contains
the basis value for each condition.
}
\examples{
library(dplyr)
carbon.fabric.2 \%>\%
  filter(test == "WT") \%>\%
  condition_summary(strength, condition, "RTD")

##   condition  n     mean mean_fraction
## 1       CTD 19 135.4719     0.9702503
## 2       RTD 28 139.6257     1.0000000
## 3       ETW 18 134.1009     0.9604312
## 4      ETW2 21 130.1545     0.9321673

carbon.fabric \%>\%
  filter(test == "FT") \%>\%
  basis_pooled_sd(strength, condition, batch) \%>\%
  condition_summary("RTD")

##   condition  n     mean mean_fraction    basis basis_fraction
## 1       RTD 18 127.6211     1.0000000 116.8894      1.0000000
## 2       ETW 18 117.8080     0.9231072 107.0762      0.9160476
## 3       CTD 18 125.9629     0.9870063 115.2311      0.9858133

}
