% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{gaiaCNVplot}
\alias{gaiaCNVplot}
\title{Creates a plot for GAIA output (all significant aberrant regions.)}
\usage{
gaiaCNVplot(calls, threshold = 0.01)
}
\arguments{
\item{calls}{A matrix with the following columns: Chromossome, Aberration Kind
Region Start, Region End, Region Size and score}

\item{threshold}{Score threshold (orange horizontal line in the plot)}
}
\value{
A plot with all significant aberrant regions.
}
\description{
This function is a auxiliary function to visualize GAIA output
(all significant aberrant regions.)
}
\examples{
call <- data.frame("Chromossome" = rep(9,100),
                   "Aberration Kind" = rep(c(-2,-1,0,1,2),20),
                   "Region Start [bp]" = 18259823:18259922,
                   "Region End [bp]" = 18259823:18259922,
                   "score" = rep(c(1,2,3,4),25))
 gaiaCNVplot(call,threshold = 0.01)
 call <- data.frame("Chromossome" = rep(c(1,9),50),
                    "Aberration Kind" = rep(c(-2,-1,0,1,2),20),
                    "Region Start [bp]" = 18259823:18259922,
                    "Region End [bp]" = 18259823:18259922,
                    "score" = rep(c(1,2,3,4),25))
 gaiaCNVplot(call,threshold = 0.01)
}
