% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cds_conversion.R
\name{importCDS}
\alias{importCDS}
\title{Import a Seurat object and convert it to a monocle cds.}
\usage{
importCDS(otherCDS, import_all = FALSE)
}
\arguments{
\item{otherCDS}{the object you would like to convert into a monocle cds}

\item{import_all}{Whether or not to import all the slots in seurat. Default is FALSE (or only keep
minimal dataset).}
}
\value{
a new monocle cell dataset object converted from Seurat object.
}
\description{
This function takes a Seurat object and converts it to a monocle cds. It currently
supports only the Seurat package.
}
\examples{
\dontrun{
lung <- load_lung()
seurat_lung <- exportCDS(lung)
seurat_lung_all <- exportCDS(lung, export_all = T)

importCDS(seurat_lung)
importCDS(seurat_lung, import_all = T)
importCDS(seurat_lung_all)
importCDS(seurat_lung_all, import_all = T)
}
}
