# coding=utf-8
# pylint: disable=too-many-lines
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Any, Dict, List, Optional, TYPE_CHECKING, Union

from ... import _serialization

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from .. import models as _models


class AadConnectivityState(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar connectivity_state: The connectivity state of the external AAD solution. Known values
     are: "Discovered", "NotLicensed", and "Connected".
    :vartype connectivity_state: str or
     ~azure.mgmt.security.v2020_01_01.models.AadConnectivityStateEnum
    """

    _attribute_map = {
        "connectivity_state": {"key": "connectivityState", "type": "str"},
    }

    def __init__(
        self, *, connectivity_state: Optional[Union[str, "_models.AadConnectivityStateEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword connectivity_state: The connectivity state of the external AAD solution. Known values
         are: "Discovered", "NotLicensed", and "Connected".
        :paramtype connectivity_state: str or
         ~azure.mgmt.security.v2020_01_01.models.AadConnectivityStateEnum
        """
        super().__init__(**kwargs)
        self.connectivity_state = connectivity_state


class Location(_serialization.Model):
    """Describes an Azure resource with location.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    """

    _validation = {
        "location": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location = None


class ExternalSecuritySolutionKind(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(
        self, *, kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or
         ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
        """
        super().__init__(**kwargs)
        self.kind = kind


class Resource(_serialization.Model):
    """Describes an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ExternalSecuritySolution(Resource, ExternalSecuritySolutionKind, Location):
    """Represents a security solution external to Microsoft Defender for Cloud which sends information
    to an OMS workspace and whose data is displayed by Microsoft Defender for Cloud.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
    }

    def __init__(
        self, *, kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or
         ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
        """
        super().__init__(kind=kind, **kwargs)
        self.location = None
        self.kind = kind
        self.id = None
        self.name = None
        self.type = None


class AadExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an AAD identity protection solution which sends logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The external security solution properties for AAD solutions.
    :vartype properties: ~azure.mgmt.security.v2020_01_01.models.AadSolutionProperties
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "AadSolutionProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None,
        properties: Optional["_models.AadSolutionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or
         ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
        :keyword properties: The external security solution properties for AAD solutions.
        :paramtype properties: ~azure.mgmt.security.v2020_01_01.models.AadSolutionProperties
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class ExternalSecuritySolutionProperties(_serialization.Model):
    """The solution properties (correspond to the solution kind).

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
        """
        super().__init__(**kwargs)
        self.additional_properties = additional_properties
        self.device_vendor = device_vendor
        self.device_type = device_type
        self.workspace = workspace


class AadSolutionProperties(ExternalSecuritySolutionProperties, AadConnectivityState):
    """The external security solution properties for AAD solutions.

    :ivar connectivity_state: The connectivity state of the external AAD solution. Known values
     are: "Discovered", "NotLicensed", and "Connected".
    :vartype connectivity_state: str or
     ~azure.mgmt.security.v2020_01_01.models.AadConnectivityStateEnum
    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
    """

    _attribute_map = {
        "connectivity_state": {"key": "connectivityState", "type": "str"},
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
    }

    def __init__(
        self,
        *,
        connectivity_state: Optional[Union[str, "_models.AadConnectivityStateEnum"]] = None,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword connectivity_state: The connectivity state of the external AAD solution. Known values
         are: "Discovered", "NotLicensed", and "Connected".
        :paramtype connectivity_state: str or
         ~azure.mgmt.security.v2020_01_01.models.AadConnectivityStateEnum
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
        """
        super().__init__(
            additional_properties=additional_properties,
            device_vendor=device_vendor,
            device_type=device_type,
            workspace=workspace,
            connectivity_state=connectivity_state,
            **kwargs
        )
        self.connectivity_state = connectivity_state
        self.additional_properties = additional_properties
        self.device_vendor = device_vendor
        self.device_type = device_type
        self.workspace = workspace


class AdaptiveApplicationControlGroup(Resource, Location):  # pylint: disable=too-many-instance-attributes
    """AdaptiveApplicationControlGroup.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar enforcement_mode: The application control policy enforcement/protection mode of the
     machine group. Known values are: "Audit", "Enforce", and "None".
    :vartype enforcement_mode: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
    :ivar protection_mode: The protection mode of the collection/file types. Exe/Msi/Script are
     used for Windows, Executable is used for Linux.
    :vartype protection_mode: ~azure.mgmt.security.v2020_01_01.models.ProtectionMode
    :ivar configuration_status: The configuration status of the machines group or machine or rule.
     Known values are: "Configured", "NotConfigured", "InProgress", "Failed", and "NoStatus".
    :vartype configuration_status: str or
     ~azure.mgmt.security.v2020_01_01.models.ConfigurationStatus
    :ivar recommendation_status: The initial recommendation status of the machine group or machine.
     Known values are: "Recommended", "NotRecommended", "NotAvailable", and "NoStatus".
    :vartype recommendation_status: str or
     ~azure.mgmt.security.v2020_01_01.models.RecommendationStatus
    :ivar issues:
    :vartype issues:
     list[~azure.mgmt.security.v2020_01_01.models.AdaptiveApplicationControlIssueSummary]
    :ivar source_system: The source type of the machine group. Known values are: "Azure_AppLocker",
     "Azure_AuditD", "NonAzure_AppLocker", "NonAzure_AuditD", and "None".
    :vartype source_system: str or ~azure.mgmt.security.v2020_01_01.models.SourceSystem
    :ivar vm_recommendations:
    :vartype vm_recommendations: list[~azure.mgmt.security.v2020_01_01.models.VmRecommendation]
    :ivar path_recommendations:
    :vartype path_recommendations: list[~azure.mgmt.security.v2020_01_01.models.PathRecommendation]
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "configuration_status": {"readonly": True},
        "recommendation_status": {"readonly": True},
        "issues": {"readonly": True},
        "source_system": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "enforcement_mode": {"key": "properties.enforcementMode", "type": "str"},
        "protection_mode": {"key": "properties.protectionMode", "type": "ProtectionMode"},
        "configuration_status": {"key": "properties.configurationStatus", "type": "str"},
        "recommendation_status": {"key": "properties.recommendationStatus", "type": "str"},
        "issues": {"key": "properties.issues", "type": "[AdaptiveApplicationControlIssueSummary]"},
        "source_system": {"key": "properties.sourceSystem", "type": "str"},
        "vm_recommendations": {"key": "properties.vmRecommendations", "type": "[VmRecommendation]"},
        "path_recommendations": {"key": "properties.pathRecommendations", "type": "[PathRecommendation]"},
    }

    def __init__(
        self,
        *,
        enforcement_mode: Optional[Union[str, "_models.EnforcementMode"]] = None,
        protection_mode: Optional["_models.ProtectionMode"] = None,
        vm_recommendations: Optional[List["_models.VmRecommendation"]] = None,
        path_recommendations: Optional[List["_models.PathRecommendation"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword enforcement_mode: The application control policy enforcement/protection mode of the
         machine group. Known values are: "Audit", "Enforce", and "None".
        :paramtype enforcement_mode: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
        :keyword protection_mode: The protection mode of the collection/file types. Exe/Msi/Script are
         used for Windows, Executable is used for Linux.
        :paramtype protection_mode: ~azure.mgmt.security.v2020_01_01.models.ProtectionMode
        :keyword vm_recommendations:
        :paramtype vm_recommendations: list[~azure.mgmt.security.v2020_01_01.models.VmRecommendation]
        :keyword path_recommendations:
        :paramtype path_recommendations:
         list[~azure.mgmt.security.v2020_01_01.models.PathRecommendation]
        """
        super().__init__(**kwargs)
        self.location = None
        self.enforcement_mode = enforcement_mode
        self.protection_mode = protection_mode
        self.configuration_status = None
        self.recommendation_status = None
        self.issues = None
        self.source_system = None
        self.vm_recommendations = vm_recommendations
        self.path_recommendations = path_recommendations
        self.id = None
        self.name = None
        self.type = None


class AdaptiveApplicationControlGroups(_serialization.Model):
    """Represents a list of VM/server groups and set of rules that are Recommended by Microsoft
    Defender for Cloud to be allowed.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.AdaptiveApplicationControlGroup]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AdaptiveApplicationControlGroup]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.AdaptiveApplicationControlGroup"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.AdaptiveApplicationControlGroup]
        """
        super().__init__(**kwargs)
        self.value = value


class AdaptiveApplicationControlIssueSummary(_serialization.Model):
    """Represents a summary of the alerts of the machine group.

    :ivar issue: An alert that machines within a group can have. Known values are:
     "ViolationsAudited", "ViolationsBlocked", "MsiAndScriptViolationsAudited",
     "MsiAndScriptViolationsBlocked", "ExecutableViolationsAudited", and "RulesViolatedManually".
    :vartype issue: str or ~azure.mgmt.security.v2020_01_01.models.AdaptiveApplicationControlIssue
    :ivar number_of_vms: The number of machines in the group that have this alert.
    :vartype number_of_vms: float
    """

    _attribute_map = {
        "issue": {"key": "issue", "type": "str"},
        "number_of_vms": {"key": "numberOfVms", "type": "float"},
    }

    def __init__(
        self,
        *,
        issue: Optional[Union[str, "_models.AdaptiveApplicationControlIssue"]] = None,
        number_of_vms: Optional[float] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword issue: An alert that machines within a group can have. Known values are:
         "ViolationsAudited", "ViolationsBlocked", "MsiAndScriptViolationsAudited",
         "MsiAndScriptViolationsBlocked", "ExecutableViolationsAudited", and "RulesViolatedManually".
        :paramtype issue: str or
         ~azure.mgmt.security.v2020_01_01.models.AdaptiveApplicationControlIssue
        :keyword number_of_vms: The number of machines in the group that have this alert.
        :paramtype number_of_vms: float
        """
        super().__init__(**kwargs)
        self.issue = issue
        self.number_of_vms = number_of_vms


class AdaptiveNetworkHardening(Resource):
    """The resource whose properties describes the Adaptive Network Hardening settings for some Azure
    resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar rules: The security rules which are recommended to be effective on the VM.
    :vartype rules: list[~azure.mgmt.security.v2020_01_01.models.Rule]
    :ivar rules_calculation_time: The UTC time on which the rules were calculated.
    :vartype rules_calculation_time: ~datetime.datetime
    :ivar effective_network_security_groups: The Network Security Groups effective on the network
     interfaces of the protected resource.
    :vartype effective_network_security_groups:
     list[~azure.mgmt.security.v2020_01_01.models.EffectiveNetworkSecurityGroups]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "rules": {"key": "properties.rules", "type": "[Rule]"},
        "rules_calculation_time": {"key": "properties.rulesCalculationTime", "type": "iso-8601"},
        "effective_network_security_groups": {
            "key": "properties.effectiveNetworkSecurityGroups",
            "type": "[EffectiveNetworkSecurityGroups]",
        },
    }

    def __init__(
        self,
        *,
        rules: Optional[List["_models.Rule"]] = None,
        rules_calculation_time: Optional[datetime.datetime] = None,
        effective_network_security_groups: Optional[List["_models.EffectiveNetworkSecurityGroups"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword rules: The security rules which are recommended to be effective on the VM.
        :paramtype rules: list[~azure.mgmt.security.v2020_01_01.models.Rule]
        :keyword rules_calculation_time: The UTC time on which the rules were calculated.
        :paramtype rules_calculation_time: ~datetime.datetime
        :keyword effective_network_security_groups: The Network Security Groups effective on the
         network interfaces of the protected resource.
        :paramtype effective_network_security_groups:
         list[~azure.mgmt.security.v2020_01_01.models.EffectiveNetworkSecurityGroups]
        """
        super().__init__(**kwargs)
        self.rules = rules
        self.rules_calculation_time = rules_calculation_time
        self.effective_network_security_groups = effective_network_security_groups


class AdaptiveNetworkHardeningEnforceRequest(_serialization.Model):
    """AdaptiveNetworkHardeningEnforceRequest.

    All required parameters must be populated in order to send to server.

    :ivar rules: The rules to enforce. Required.
    :vartype rules: list[~azure.mgmt.security.v2020_01_01.models.Rule]
    :ivar network_security_groups: The Azure resource IDs of the effective network security groups
     that will be updated with the created security rules from the Adaptive Network Hardening rules.
     Required.
    :vartype network_security_groups: list[str]
    """

    _validation = {
        "rules": {"required": True},
        "network_security_groups": {"required": True},
    }

    _attribute_map = {
        "rules": {"key": "rules", "type": "[Rule]"},
        "network_security_groups": {"key": "networkSecurityGroups", "type": "[str]"},
    }

    def __init__(self, *, rules: List["_models.Rule"], network_security_groups: List[str], **kwargs: Any) -> None:
        """
        :keyword rules: The rules to enforce. Required.
        :paramtype rules: list[~azure.mgmt.security.v2020_01_01.models.Rule]
        :keyword network_security_groups: The Azure resource IDs of the effective network security
         groups that will be updated with the created security rules from the Adaptive Network Hardening
         rules. Required.
        :paramtype network_security_groups: list[str]
        """
        super().__init__(**kwargs)
        self.rules = rules
        self.network_security_groups = network_security_groups


class AdaptiveNetworkHardeningsList(_serialization.Model):
    """Response for ListAdaptiveNetworkHardenings API service call.

    :ivar value: A list of Adaptive Network Hardenings resources.
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.AdaptiveNetworkHardening]
    :ivar next_link: The URL to get the next set of results.
    :vartype next_link: str
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[AdaptiveNetworkHardening]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(
        self,
        *,
        value: Optional[List["_models.AdaptiveNetworkHardening"]] = None,
        next_link: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword value: A list of Adaptive Network Hardenings resources.
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.AdaptiveNetworkHardening]
        :keyword next_link: The URL to get the next set of results.
        :paramtype next_link: str
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class AllowedConnectionsList(_serialization.Model):
    """List of all possible traffic between Azure resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.AllowedConnectionsResource]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[AllowedConnectionsResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class AllowedConnectionsResource(Resource, Location):
    """The resource whose properties describes the allowed traffic between Azure resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar calculated_date_time: The UTC time on which the allowed connections resource was
     calculated.
    :vartype calculated_date_time: ~datetime.datetime
    :ivar connectable_resources: List of connectable resources.
    :vartype connectable_resources:
     list[~azure.mgmt.security.v2020_01_01.models.ConnectableResource]
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "calculated_date_time": {"readonly": True},
        "connectable_resources": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "calculated_date_time": {"key": "properties.calculatedDateTime", "type": "iso-8601"},
        "connectable_resources": {"key": "properties.connectableResources", "type": "[ConnectableResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location = None
        self.calculated_date_time = None
        self.connectable_resources = None
        self.id = None
        self.name = None
        self.type = None


class AssessmentLinks(_serialization.Model):
    """Links relevant to the assessment.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar azure_portal_uri: Link to assessment in Azure Portal.
    :vartype azure_portal_uri: str
    """

    _validation = {
        "azure_portal_uri": {"readonly": True},
    }

    _attribute_map = {
        "azure_portal_uri": {"key": "azurePortalUri", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.azure_portal_uri = None


class AssessmentStatus(_serialization.Model):
    """The result of the assessment.

    All required parameters must be populated in order to send to server.

    :ivar code: Programmatic code for the status of the assessment. Required. Known values are:
     "Healthy", "Unhealthy", and "NotApplicable".
    :vartype code: str or ~azure.mgmt.security.v2020_01_01.models.AssessmentStatusCode
    :ivar cause: Programmatic code for the cause of the assessment status.
    :vartype cause: str
    :ivar description: Human readable description of the assessment status.
    :vartype description: str
    """

    _validation = {
        "code": {"required": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "cause": {"key": "cause", "type": "str"},
        "description": {"key": "description", "type": "str"},
    }

    def __init__(
        self,
        *,
        code: Union[str, "_models.AssessmentStatusCode"],
        cause: Optional[str] = None,
        description: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword code: Programmatic code for the status of the assessment. Required. Known values are:
         "Healthy", "Unhealthy", and "NotApplicable".
        :paramtype code: str or ~azure.mgmt.security.v2020_01_01.models.AssessmentStatusCode
        :keyword cause: Programmatic code for the cause of the assessment status.
        :paramtype cause: str
        :keyword description: Human readable description of the assessment status.
        :paramtype description: str
        """
        super().__init__(**kwargs)
        self.code = code
        self.cause = cause
        self.description = description


class AtaExternalSecuritySolution(ExternalSecuritySolution):
    """Represents an ATA security solution which sends logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The external security solution properties for ATA solutions.
    :vartype properties: ~azure.mgmt.security.v2020_01_01.models.AtaSolutionProperties
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "AtaSolutionProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None,
        properties: Optional["_models.AtaSolutionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or
         ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
        :keyword properties: The external security solution properties for ATA solutions.
        :paramtype properties: ~azure.mgmt.security.v2020_01_01.models.AtaSolutionProperties
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class AtaSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for ATA solutions.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
    :ivar last_event_received:
    :vartype last_event_received: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
        "last_event_received": {"key": "lastEventReceived", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        last_event_received: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
        :keyword last_event_received:
        :paramtype last_event_received: str
        """
        super().__init__(
            additional_properties=additional_properties,
            device_vendor=device_vendor,
            device_type=device_type,
            workspace=workspace,
            **kwargs
        )
        self.last_event_received = last_event_received


class ResourceDetails(_serialization.Model):
    """Details of the resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    AzureResourceDetails, OnPremiseResourceDetails

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2020_01_01.models.Source
    """

    _validation = {
        "source": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
    }

    _subtype_map = {"source": {"Azure": "AzureResourceDetails", "OnPremise": "OnPremiseResourceDetails"}}

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: Optional[str] = None


class AzureResourceDetails(ResourceDetails):
    """Details of the Azure resource that was assessed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2020_01_01.models.Source
    :ivar id: Azure resource Id of the assessed resource.
    :vartype id: str
    """

    _validation = {
        "source": {"required": True},
        "id": {"readonly": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.source: str = "Azure"
        self.id = None


class AzureResourceLink(_serialization.Model):
    """Describes an Azure resource with kind.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Azure resource Id.
    :vartype id: str
    """

    _validation = {
        "id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None


class CefExternalSecuritySolution(ExternalSecuritySolution):
    """Represents a security solution which sends CEF logs to an OMS workspace.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
    :vartype kind: str or ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar properties: The external security solution properties for CEF solutions.
    :vartype properties: ~azure.mgmt.security.v2020_01_01.models.CefSolutionProperties
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "properties": {"key": "properties", "type": "CefSolutionProperties"},
    }

    def __init__(
        self,
        *,
        kind: Optional[Union[str, "_models.ExternalSecuritySolutionKindEnum"]] = None,
        properties: Optional["_models.CefSolutionProperties"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: The kind of the external solution. Known values are: "CEF", "ATA", and "AAD".
        :paramtype kind: str or
         ~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolutionKindEnum
        :keyword properties: The external security solution properties for CEF solutions.
        :paramtype properties: ~azure.mgmt.security.v2020_01_01.models.CefSolutionProperties
        """
        super().__init__(kind=kind, **kwargs)
        self.properties = properties


class CefSolutionProperties(ExternalSecuritySolutionProperties):
    """The external security solution properties for CEF solutions.

    :ivar additional_properties: Unmatched properties from the message are deserialized to this
     collection.
    :vartype additional_properties: dict[str, any]
    :ivar device_vendor:
    :vartype device_vendor: str
    :ivar device_type:
    :vartype device_type: str
    :ivar workspace: Represents an OMS workspace to which the solution is connected.
    :vartype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
    :ivar hostname:
    :vartype hostname: str
    :ivar agent:
    :vartype agent: str
    :ivar last_event_received:
    :vartype last_event_received: str
    """

    _attribute_map = {
        "additional_properties": {"key": "", "type": "{object}"},
        "device_vendor": {"key": "deviceVendor", "type": "str"},
        "device_type": {"key": "deviceType", "type": "str"},
        "workspace": {"key": "workspace", "type": "ConnectedWorkspace"},
        "hostname": {"key": "hostname", "type": "str"},
        "agent": {"key": "agent", "type": "str"},
        "last_event_received": {"key": "lastEventReceived", "type": "str"},
    }

    def __init__(
        self,
        *,
        additional_properties: Optional[Dict[str, Any]] = None,
        device_vendor: Optional[str] = None,
        device_type: Optional[str] = None,
        workspace: Optional["_models.ConnectedWorkspace"] = None,
        hostname: Optional[str] = None,
        agent: Optional[str] = None,
        last_event_received: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword additional_properties: Unmatched properties from the message are deserialized to this
         collection.
        :paramtype additional_properties: dict[str, any]
        :keyword device_vendor:
        :paramtype device_vendor: str
        :keyword device_type:
        :paramtype device_type: str
        :keyword workspace: Represents an OMS workspace to which the solution is connected.
        :paramtype workspace: ~azure.mgmt.security.v2020_01_01.models.ConnectedWorkspace
        :keyword hostname:
        :paramtype hostname: str
        :keyword agent:
        :paramtype agent: str
        :keyword last_event_received:
        :paramtype last_event_received: str
        """
        super().__init__(
            additional_properties=additional_properties,
            device_vendor=device_vendor,
            device_type=device_type,
            workspace=workspace,
            **kwargs
        )
        self.hostname = hostname
        self.agent = agent
        self.last_event_received = last_event_received


class CloudErrorBody(_serialization.Model):
    """The error detail.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.security.v2020_01_01.models.CloudErrorBody]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.security.v2020_01_01.models.ErrorAdditionalInfo]
    """

    _validation = {
        "code": {"readonly": True},
        "message": {"readonly": True},
        "target": {"readonly": True},
        "details": {"readonly": True},
        "additional_info": {"readonly": True},
    }

    _attribute_map = {
        "code": {"key": "code", "type": "str"},
        "message": {"key": "message", "type": "str"},
        "target": {"key": "target", "type": "str"},
        "details": {"key": "details", "type": "[CloudErrorBody]"},
        "additional_info": {"key": "additionalInfo", "type": "[ErrorAdditionalInfo]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class ConnectableResource(_serialization.Model):
    """Describes the allowed inbound and outbound traffic of an Azure resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: The Azure resource id.
    :vartype id: str
    :ivar inbound_connected_resources: The list of Azure resources that the resource has inbound
     allowed connection from.
    :vartype inbound_connected_resources:
     list[~azure.mgmt.security.v2020_01_01.models.ConnectedResource]
    :ivar outbound_connected_resources: The list of Azure resources that the resource has outbound
     allowed connection to.
    :vartype outbound_connected_resources:
     list[~azure.mgmt.security.v2020_01_01.models.ConnectedResource]
    """

    _validation = {
        "id": {"readonly": True},
        "inbound_connected_resources": {"readonly": True},
        "outbound_connected_resources": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "inbound_connected_resources": {"key": "inboundConnectedResources", "type": "[ConnectedResource]"},
        "outbound_connected_resources": {"key": "outboundConnectedResources", "type": "[ConnectedResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.id = None
        self.inbound_connected_resources = None
        self.outbound_connected_resources = None


class ConnectedResource(_serialization.Model):
    """Describes properties of a connected resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar connected_resource_id: The Azure resource id of the connected resource.
    :vartype connected_resource_id: str
    :ivar tcp_ports: The allowed tcp ports.
    :vartype tcp_ports: str
    :ivar udp_ports: The allowed udp ports.
    :vartype udp_ports: str
    """

    _validation = {
        "connected_resource_id": {"readonly": True},
        "tcp_ports": {"readonly": True},
        "udp_ports": {"readonly": True},
    }

    _attribute_map = {
        "connected_resource_id": {"key": "connectedResourceId", "type": "str"},
        "tcp_ports": {"key": "tcpPorts", "type": "str"},
        "udp_ports": {"key": "udpPorts", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.connected_resource_id = None
        self.tcp_ports = None
        self.udp_ports = None


class ConnectedWorkspace(_serialization.Model):
    """Represents an OMS workspace to which the solution is connected.

    :ivar id: Azure resource ID of the connected OMS workspace.
    :vartype id: str
    """

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
    }

    def __init__(self, *, id: Optional[str] = None, **kwargs: Any) -> None:  # pylint: disable=redefined-builtin
        """
        :keyword id: Azure resource ID of the connected OMS workspace.
        :paramtype id: str
        """
        super().__init__(**kwargs)
        self.id = id


class DiscoveredSecuritySolution(Resource, Location):
    """DiscoveredSecuritySolution.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar security_family: The security family of the discovered solution. Required. Known values
     are: "Waf", "Ngfw", "SaasWaf", and "Va".
    :vartype security_family: str or ~azure.mgmt.security.v2020_01_01.models.SecurityFamily
    :ivar offer: The security solutions' image offer. Required.
    :vartype offer: str
    :ivar publisher: The security solutions' image publisher. Required.
    :vartype publisher: str
    :ivar sku: The security solutions' image sku. Required.
    :vartype sku: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "security_family": {"required": True},
        "offer": {"required": True},
        "publisher": {"required": True},
        "sku": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "security_family": {"key": "properties.securityFamily", "type": "str"},
        "offer": {"key": "properties.offer", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "sku": {"key": "properties.sku", "type": "str"},
    }

    def __init__(
        self,
        *,
        security_family: Union[str, "_models.SecurityFamily"],
        offer: str,
        publisher: str,
        sku: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_family: The security family of the discovered solution. Required. Known
         values are: "Waf", "Ngfw", "SaasWaf", and "Va".
        :paramtype security_family: str or ~azure.mgmt.security.v2020_01_01.models.SecurityFamily
        :keyword offer: The security solutions' image offer. Required.
        :paramtype offer: str
        :keyword publisher: The security solutions' image publisher. Required.
        :paramtype publisher: str
        :keyword sku: The security solutions' image sku. Required.
        :paramtype sku: str
        """
        super().__init__(**kwargs)
        self.location = None
        self.security_family = security_family
        self.offer = offer
        self.publisher = publisher
        self.sku = sku
        self.id = None
        self.name = None
        self.type = None


class DiscoveredSecuritySolutionList(_serialization.Model):
    """DiscoveredSecuritySolutionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.DiscoveredSecuritySolution]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[DiscoveredSecuritySolution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.DiscoveredSecuritySolution"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.DiscoveredSecuritySolution]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class EffectiveNetworkSecurityGroups(_serialization.Model):
    """Describes the Network Security Groups effective on a network interface.

    :ivar network_interface: The Azure resource ID of the network interface.
    :vartype network_interface: str
    :ivar network_security_groups: The Network Security Groups effective on the network interface.
    :vartype network_security_groups: list[str]
    """

    _attribute_map = {
        "network_interface": {"key": "networkInterface", "type": "str"},
        "network_security_groups": {"key": "networkSecurityGroups", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        network_interface: Optional[str] = None,
        network_security_groups: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword network_interface: The Azure resource ID of the network interface.
        :paramtype network_interface: str
        :keyword network_security_groups: The Network Security Groups effective on the network
         interface.
        :paramtype network_security_groups: list[str]
        """
        super().__init__(**kwargs)
        self.network_interface = network_interface
        self.network_security_groups = network_security_groups


class ErrorAdditionalInfo(_serialization.Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: JSON
    """

    _validation = {
        "type": {"readonly": True},
        "info": {"readonly": True},
    }

    _attribute_map = {
        "type": {"key": "type", "type": "str"},
        "info": {"key": "info", "type": "object"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.type = None
        self.info = None


class ExternalSecuritySolutionList(_serialization.Model):
    """ExternalSecuritySolutionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolution]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[ExternalSecuritySolution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.ExternalSecuritySolution"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.ExternalSecuritySolution]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class JitNetworkAccessPoliciesList(_serialization.Model):
    """JitNetworkAccessPoliciesList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicy]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[JitNetworkAccessPolicy]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.JitNetworkAccessPolicy"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicy]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class Kind(_serialization.Model):
    """Describes an Azure resource with kind.

    :ivar kind: Kind of the resource.
    :vartype kind: str
    """

    _attribute_map = {
        "kind": {"key": "kind", "type": "str"},
    }

    def __init__(self, *, kind: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        """
        super().__init__(**kwargs)
        self.kind = kind


class JitNetworkAccessPolicy(Resource, Kind, Location):
    """JitNetworkAccessPolicy.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar kind: Kind of the resource.
    :vartype kind: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar virtual_machines: Configurations for Microsoft.Compute/virtualMachines resource type.
     Required.
    :vartype virtual_machines:
     list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicyVirtualMachine]
    :ivar requests:
    :vartype requests: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessRequest]
    :ivar provisioning_state: Gets the provisioning state of the Just-in-Time policy.
    :vartype provisioning_state: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "virtual_machines": {"required": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "kind": {"key": "kind", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "virtual_machines": {"key": "properties.virtualMachines", "type": "[JitNetworkAccessPolicyVirtualMachine]"},
        "requests": {"key": "properties.requests", "type": "[JitNetworkAccessRequest]"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machines: List["_models.JitNetworkAccessPolicyVirtualMachine"],
        kind: Optional[str] = None,
        requests: Optional[List["_models.JitNetworkAccessRequest"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword kind: Kind of the resource.
        :paramtype kind: str
        :keyword virtual_machines: Configurations for Microsoft.Compute/virtualMachines resource type.
         Required.
        :paramtype virtual_machines:
         list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicyVirtualMachine]
        :keyword requests:
        :paramtype requests: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessRequest]
        """
        super().__init__(kind=kind, **kwargs)
        self.location = None
        self.kind = kind
        self.virtual_machines = virtual_machines
        self.requests = requests
        self.provisioning_state = None
        self.id = None
        self.name = None
        self.type = None


class JitNetworkAccessPolicyInitiatePort(_serialization.Model):
    """JitNetworkAccessPolicyInitiatePort.

    All required parameters must be populated in order to send to server.

    :ivar number: Required.
    :vartype number: int
    :ivar allowed_source_address_prefix: Source of the allowed traffic. If omitted, the request
     will be for the source IP address of the initiate request.
    :vartype allowed_source_address_prefix: str
    :ivar end_time_utc: The time to close the request in UTC. Required.
    :vartype end_time_utc: ~datetime.datetime
    """

    _validation = {
        "number": {"required": True, "maximum": 65535, "minimum": 0},
        "end_time_utc": {"required": True},
    }

    _attribute_map = {
        "number": {"key": "number", "type": "int"},
        "allowed_source_address_prefix": {"key": "allowedSourceAddressPrefix", "type": "str"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
    }

    def __init__(
        self,
        *,
        number: int,
        end_time_utc: datetime.datetime,
        allowed_source_address_prefix: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number: Required.
        :paramtype number: int
        :keyword allowed_source_address_prefix: Source of the allowed traffic. If omitted, the request
         will be for the source IP address of the initiate request.
        :paramtype allowed_source_address_prefix: str
        :keyword end_time_utc: The time to close the request in UTC. Required.
        :paramtype end_time_utc: ~datetime.datetime
        """
        super().__init__(**kwargs)
        self.number = number
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.end_time_utc = end_time_utc


class JitNetworkAccessPolicyInitiateRequest(_serialization.Model):
    """JitNetworkAccessPolicyInitiateRequest.

    All required parameters must be populated in order to send to server.

    :ivar virtual_machines: A list of virtual machines & ports to open access for. Required.
    :vartype virtual_machines:
     list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicyInitiateVirtualMachine]
    :ivar justification: The justification for making the initiate request.
    :vartype justification: str
    """

    _validation = {
        "virtual_machines": {"required": True},
    }

    _attribute_map = {
        "virtual_machines": {"key": "virtualMachines", "type": "[JitNetworkAccessPolicyInitiateVirtualMachine]"},
        "justification": {"key": "justification", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machines: List["_models.JitNetworkAccessPolicyInitiateVirtualMachine"],
        justification: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machines: A list of virtual machines & ports to open access for. Required.
        :paramtype virtual_machines:
         list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicyInitiateVirtualMachine]
        :keyword justification: The justification for making the initiate request.
        :paramtype justification: str
        """
        super().__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.justification = justification


class JitNetworkAccessPolicyInitiateVirtualMachine(_serialization.Model):  # pylint: disable=name-too-long
    """JitNetworkAccessPolicyInitiateVirtualMachine.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the virtual machine that is linked to this policy. Required.
    :vartype id: str
    :ivar ports: The ports to open for the resource with the ``id``. Required.
    :vartype ports:
     list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicyInitiatePort]
    """

    _validation = {
        "id": {"required": True},
        "ports": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ports": {"key": "ports", "type": "[JitNetworkAccessPolicyInitiatePort]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ports: List["_models.JitNetworkAccessPolicyInitiatePort"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of the virtual machine that is linked to this policy. Required.
        :paramtype id: str
        :keyword ports: The ports to open for the resource with the ``id``. Required.
        :paramtype ports:
         list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPolicyInitiatePort]
        """
        super().__init__(**kwargs)
        self.id = id
        self.ports = ports


class JitNetworkAccessPolicyVirtualMachine(_serialization.Model):
    """JitNetworkAccessPolicyVirtualMachine.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the virtual machine that is linked to this policy. Required.
    :vartype id: str
    :ivar ports: Port configurations for the virtual machine. Required.
    :vartype ports: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPortRule]
    :ivar public_ip_address: Public IP address of the Azure Firewall that is linked to this policy,
     if applicable.
    :vartype public_ip_address: str
    """

    _validation = {
        "id": {"required": True},
        "ports": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ports": {"key": "ports", "type": "[JitNetworkAccessPortRule]"},
        "public_ip_address": {"key": "publicIpAddress", "type": "str"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ports: List["_models.JitNetworkAccessPortRule"],
        public_ip_address: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of the virtual machine that is linked to this policy. Required.
        :paramtype id: str
        :keyword ports: Port configurations for the virtual machine. Required.
        :paramtype ports: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessPortRule]
        :keyword public_ip_address: Public IP address of the Azure Firewall that is linked to this
         policy, if applicable.
        :paramtype public_ip_address: str
        """
        super().__init__(**kwargs)
        self.id = id
        self.ports = ports
        self.public_ip_address = public_ip_address


class JitNetworkAccessPortRule(_serialization.Model):
    """JitNetworkAccessPortRule.

    All required parameters must be populated in order to send to server.

    :ivar number: Required.
    :vartype number: int
    :ivar protocol: Required. Known values are: "TCP", "UDP", and "*".
    :vartype protocol: str or ~azure.mgmt.security.v2020_01_01.models.ProtocolEnum
    :ivar allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes"
     parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
    :vartype allowed_source_address_prefix: str
    :ivar allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix"
     parameter.
    :vartype allowed_source_address_prefixes: list[str]
    :ivar max_request_access_duration: Maximum duration requests can be made for. In ISO 8601
     duration format. Minimum 5 minutes, maximum 1 day. Required.
    :vartype max_request_access_duration: str
    """

    _validation = {
        "number": {"required": True, "maximum": 65535, "minimum": 0},
        "protocol": {"required": True},
        "max_request_access_duration": {"required": True},
    }

    _attribute_map = {
        "number": {"key": "number", "type": "int"},
        "protocol": {"key": "protocol", "type": "str"},
        "allowed_source_address_prefix": {"key": "allowedSourceAddressPrefix", "type": "str"},
        "allowed_source_address_prefixes": {"key": "allowedSourceAddressPrefixes", "type": "[str]"},
        "max_request_access_duration": {"key": "maxRequestAccessDuration", "type": "str"},
    }

    def __init__(
        self,
        *,
        number: int,
        protocol: Union[str, "_models.ProtocolEnum"],
        max_request_access_duration: str,
        allowed_source_address_prefix: Optional[str] = None,
        allowed_source_address_prefixes: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number: Required.
        :paramtype number: int
        :keyword protocol: Required. Known values are: "TCP", "UDP", and "*".
        :paramtype protocol: str or ~azure.mgmt.security.v2020_01_01.models.ProtocolEnum
        :keyword allowed_source_address_prefix: Mutually exclusive with the
         "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example
         "192.168.0.3" or "192.168.0.0/16".
        :paramtype allowed_source_address_prefix: str
        :keyword allowed_source_address_prefixes: Mutually exclusive with the
         "allowedSourceAddressPrefix" parameter.
        :paramtype allowed_source_address_prefixes: list[str]
        :keyword max_request_access_duration: Maximum duration requests can be made for. In ISO 8601
         duration format. Minimum 5 minutes, maximum 1 day. Required.
        :paramtype max_request_access_duration: str
        """
        super().__init__(**kwargs)
        self.number = number
        self.protocol = protocol
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.allowed_source_address_prefixes = allowed_source_address_prefixes
        self.max_request_access_duration = max_request_access_duration


class JitNetworkAccessRequest(_serialization.Model):
    """JitNetworkAccessRequest.

    All required parameters must be populated in order to send to server.

    :ivar virtual_machines: Required.
    :vartype virtual_machines:
     list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessRequestVirtualMachine]
    :ivar start_time_utc: The start time of the request in UTC. Required.
    :vartype start_time_utc: ~datetime.datetime
    :ivar requestor: The identity of the person who made the request. Required.
    :vartype requestor: str
    :ivar justification: The justification for making the initiate request.
    :vartype justification: str
    """

    _validation = {
        "virtual_machines": {"required": True},
        "start_time_utc": {"required": True},
        "requestor": {"required": True},
    }

    _attribute_map = {
        "virtual_machines": {"key": "virtualMachines", "type": "[JitNetworkAccessRequestVirtualMachine]"},
        "start_time_utc": {"key": "startTimeUtc", "type": "iso-8601"},
        "requestor": {"key": "requestor", "type": "str"},
        "justification": {"key": "justification", "type": "str"},
    }

    def __init__(
        self,
        *,
        virtual_machines: List["_models.JitNetworkAccessRequestVirtualMachine"],
        start_time_utc: datetime.datetime,
        requestor: str,
        justification: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword virtual_machines: Required.
        :paramtype virtual_machines:
         list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessRequestVirtualMachine]
        :keyword start_time_utc: The start time of the request in UTC. Required.
        :paramtype start_time_utc: ~datetime.datetime
        :keyword requestor: The identity of the person who made the request. Required.
        :paramtype requestor: str
        :keyword justification: The justification for making the initiate request.
        :paramtype justification: str
        """
        super().__init__(**kwargs)
        self.virtual_machines = virtual_machines
        self.start_time_utc = start_time_utc
        self.requestor = requestor
        self.justification = justification


class JitNetworkAccessRequestPort(_serialization.Model):
    """JitNetworkAccessRequestPort.

    All required parameters must be populated in order to send to server.

    :ivar number: Required.
    :vartype number: int
    :ivar allowed_source_address_prefix: Mutually exclusive with the "allowedSourceAddressPrefixes"
     parameter. Should be an IP address or CIDR, for example "192.168.0.3" or "192.168.0.0/16".
    :vartype allowed_source_address_prefix: str
    :ivar allowed_source_address_prefixes: Mutually exclusive with the "allowedSourceAddressPrefix"
     parameter.
    :vartype allowed_source_address_prefixes: list[str]
    :ivar end_time_utc: The date & time at which the request ends in UTC. Required.
    :vartype end_time_utc: ~datetime.datetime
    :ivar status: The status of the port. Required. Known values are: "Revoked" and "Initiated".
    :vartype status: str or ~azure.mgmt.security.v2020_01_01.models.Status
    :ivar status_reason: A description of why the ``status`` has its value. Required. Known values
     are: "Expired", "UserRequested", and "NewerRequestInitiated".
    :vartype status_reason: str or ~azure.mgmt.security.v2020_01_01.models.StatusReason
    :ivar mapped_port: The port which is mapped to this port's ``number`` in the Azure Firewall, if
     applicable.
    :vartype mapped_port: int
    """

    _validation = {
        "number": {"required": True, "maximum": 65535, "minimum": 0},
        "end_time_utc": {"required": True},
        "status": {"required": True},
        "status_reason": {"required": True},
    }

    _attribute_map = {
        "number": {"key": "number", "type": "int"},
        "allowed_source_address_prefix": {"key": "allowedSourceAddressPrefix", "type": "str"},
        "allowed_source_address_prefixes": {"key": "allowedSourceAddressPrefixes", "type": "[str]"},
        "end_time_utc": {"key": "endTimeUtc", "type": "iso-8601"},
        "status": {"key": "status", "type": "str"},
        "status_reason": {"key": "statusReason", "type": "str"},
        "mapped_port": {"key": "mappedPort", "type": "int"},
    }

    def __init__(
        self,
        *,
        number: int,
        end_time_utc: datetime.datetime,
        status: Union[str, "_models.Status"],
        status_reason: Union[str, "_models.StatusReason"],
        allowed_source_address_prefix: Optional[str] = None,
        allowed_source_address_prefixes: Optional[List[str]] = None,
        mapped_port: Optional[int] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword number: Required.
        :paramtype number: int
        :keyword allowed_source_address_prefix: Mutually exclusive with the
         "allowedSourceAddressPrefixes" parameter. Should be an IP address or CIDR, for example
         "192.168.0.3" or "192.168.0.0/16".
        :paramtype allowed_source_address_prefix: str
        :keyword allowed_source_address_prefixes: Mutually exclusive with the
         "allowedSourceAddressPrefix" parameter.
        :paramtype allowed_source_address_prefixes: list[str]
        :keyword end_time_utc: The date & time at which the request ends in UTC. Required.
        :paramtype end_time_utc: ~datetime.datetime
        :keyword status: The status of the port. Required. Known values are: "Revoked" and "Initiated".
        :paramtype status: str or ~azure.mgmt.security.v2020_01_01.models.Status
        :keyword status_reason: A description of why the ``status`` has its value. Required. Known
         values are: "Expired", "UserRequested", and "NewerRequestInitiated".
        :paramtype status_reason: str or ~azure.mgmt.security.v2020_01_01.models.StatusReason
        :keyword mapped_port: The port which is mapped to this port's ``number`` in the Azure Firewall,
         if applicable.
        :paramtype mapped_port: int
        """
        super().__init__(**kwargs)
        self.number = number
        self.allowed_source_address_prefix = allowed_source_address_prefix
        self.allowed_source_address_prefixes = allowed_source_address_prefixes
        self.end_time_utc = end_time_utc
        self.status = status
        self.status_reason = status_reason
        self.mapped_port = mapped_port


class JitNetworkAccessRequestVirtualMachine(_serialization.Model):
    """JitNetworkAccessRequestVirtualMachine.

    All required parameters must be populated in order to send to server.

    :ivar id: Resource ID of the virtual machine that is linked to this policy. Required.
    :vartype id: str
    :ivar ports: The ports that were opened for the virtual machine. Required.
    :vartype ports: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessRequestPort]
    """

    _validation = {
        "id": {"required": True},
        "ports": {"required": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "ports": {"key": "ports", "type": "[JitNetworkAccessRequestPort]"},
    }

    def __init__(
        self,
        *,
        id: str,  # pylint: disable=redefined-builtin
        ports: List["_models.JitNetworkAccessRequestPort"],
        **kwargs: Any
    ) -> None:
        """
        :keyword id: Resource ID of the virtual machine that is linked to this policy. Required.
        :paramtype id: str
        :keyword ports: The ports that were opened for the virtual machine. Required.
        :paramtype ports: list[~azure.mgmt.security.v2020_01_01.models.JitNetworkAccessRequestPort]
        """
        super().__init__(**kwargs)
        self.id = id
        self.ports = ports


class OnPremiseResourceDetails(ResourceDetails):
    """Details of the On Premise resource that was assessed.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    OnPremiseSqlResourceDetails

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2020_01_01.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
    }

    _subtype_map = {"source": {"OnPremiseSql": "OnPremiseSqlResourceDetails"}}

    def __init__(
        self, *, workspace_id: str, vmuuid: str, source_computer_id: str, machine_name: str, **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        """
        super().__init__(**kwargs)
        self.source: str = "OnPremise"
        self.workspace_id = workspace_id
        self.vmuuid = vmuuid
        self.source_computer_id = source_computer_id
        self.machine_name = machine_name


class OnPremiseSqlResourceDetails(OnPremiseResourceDetails):
    """Details of the On Premise Sql resource that was assessed.

    All required parameters must be populated in order to send to server.

    :ivar source: The platform where the assessed resource resides. Required. Known values are:
     "Azure", "OnPremise", and "OnPremiseSql".
    :vartype source: str or ~azure.mgmt.security.v2020_01_01.models.Source
    :ivar workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
    :vartype workspace_id: str
    :ivar vmuuid: The unique Id of the machine. Required.
    :vartype vmuuid: str
    :ivar source_computer_id: The oms agent Id installed on the machine. Required.
    :vartype source_computer_id: str
    :ivar machine_name: The name of the machine. Required.
    :vartype machine_name: str
    :ivar server_name: The Sql server name installed on the machine. Required.
    :vartype server_name: str
    :ivar database_name: The Sql database name installed on the machine. Required.
    :vartype database_name: str
    """

    _validation = {
        "source": {"required": True},
        "workspace_id": {"required": True},
        "vmuuid": {"required": True},
        "source_computer_id": {"required": True},
        "machine_name": {"required": True},
        "server_name": {"required": True},
        "database_name": {"required": True},
    }

    _attribute_map = {
        "source": {"key": "source", "type": "str"},
        "workspace_id": {"key": "workspaceId", "type": "str"},
        "vmuuid": {"key": "vmuuid", "type": "str"},
        "source_computer_id": {"key": "sourceComputerId", "type": "str"},
        "machine_name": {"key": "machineName", "type": "str"},
        "server_name": {"key": "serverName", "type": "str"},
        "database_name": {"key": "databaseName", "type": "str"},
    }

    def __init__(
        self,
        *,
        workspace_id: str,
        vmuuid: str,
        source_computer_id: str,
        machine_name: str,
        server_name: str,
        database_name: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword workspace_id: Azure resource Id of the workspace the machine is attached to. Required.
        :paramtype workspace_id: str
        :keyword vmuuid: The unique Id of the machine. Required.
        :paramtype vmuuid: str
        :keyword source_computer_id: The oms agent Id installed on the machine. Required.
        :paramtype source_computer_id: str
        :keyword machine_name: The name of the machine. Required.
        :paramtype machine_name: str
        :keyword server_name: The Sql server name installed on the machine. Required.
        :paramtype server_name: str
        :keyword database_name: The Sql database name installed on the machine. Required.
        :paramtype database_name: str
        """
        super().__init__(
            workspace_id=workspace_id,
            vmuuid=vmuuid,
            source_computer_id=source_computer_id,
            machine_name=machine_name,
            **kwargs
        )
        self.source: str = "OnPremiseSql"
        self.server_name = server_name
        self.database_name = database_name


class PathRecommendation(_serialization.Model):
    """Represents a path that is recommended to be allowed and its properties.

    :ivar path: The full path of the file, or an identifier of the application.
    :vartype path: str
    :ivar action: The recommendation action of the machine or rule. Known values are:
     "Recommended", "Add", and "Remove".
    :vartype action: str or ~azure.mgmt.security.v2020_01_01.models.RecommendationAction
    :ivar type: The type of the rule to be allowed. Known values are: "File", "FileHash",
     "PublisherSignature", "ProductSignature", "BinarySignature", and "VersionAndAboveSignature".
    :vartype type: str or ~azure.mgmt.security.v2020_01_01.models.RecommendationType
    :ivar publisher_info: Represents the publisher information of a process/rule.
    :vartype publisher_info: ~azure.mgmt.security.v2020_01_01.models.PublisherInfo
    :ivar common: Whether the application is commonly run on the machine.
    :vartype common: bool
    :ivar user_sids:
    :vartype user_sids: list[str]
    :ivar usernames:
    :vartype usernames: list[~azure.mgmt.security.v2020_01_01.models.UserRecommendation]
    :ivar file_type: The type of the file (for Linux files - Executable is used). Known values are:
     "Exe", "Dll", "Msi", "Script", "Executable", and "Unknown".
    :vartype file_type: str or ~azure.mgmt.security.v2020_01_01.models.FileType
    :ivar configuration_status: The configuration status of the machines group or machine or rule.
     Known values are: "Configured", "NotConfigured", "InProgress", "Failed", and "NoStatus".
    :vartype configuration_status: str or
     ~azure.mgmt.security.v2020_01_01.models.ConfigurationStatus
    """

    _attribute_map = {
        "path": {"key": "path", "type": "str"},
        "action": {"key": "action", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "publisher_info": {"key": "publisherInfo", "type": "PublisherInfo"},
        "common": {"key": "common", "type": "bool"},
        "user_sids": {"key": "userSids", "type": "[str]"},
        "usernames": {"key": "usernames", "type": "[UserRecommendation]"},
        "file_type": {"key": "fileType", "type": "str"},
        "configuration_status": {"key": "configurationStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        action: Optional[Union[str, "_models.RecommendationAction"]] = None,
        type: Optional[Union[str, "_models.RecommendationType"]] = None,
        publisher_info: Optional["_models.PublisherInfo"] = None,
        common: Optional[bool] = None,
        user_sids: Optional[List[str]] = None,
        usernames: Optional[List["_models.UserRecommendation"]] = None,
        file_type: Optional[Union[str, "_models.FileType"]] = None,
        configuration_status: Optional[Union[str, "_models.ConfigurationStatus"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword path: The full path of the file, or an identifier of the application.
        :paramtype path: str
        :keyword action: The recommendation action of the machine or rule. Known values are:
         "Recommended", "Add", and "Remove".
        :paramtype action: str or ~azure.mgmt.security.v2020_01_01.models.RecommendationAction
        :keyword type: The type of the rule to be allowed. Known values are: "File", "FileHash",
         "PublisherSignature", "ProductSignature", "BinarySignature", and "VersionAndAboveSignature".
        :paramtype type: str or ~azure.mgmt.security.v2020_01_01.models.RecommendationType
        :keyword publisher_info: Represents the publisher information of a process/rule.
        :paramtype publisher_info: ~azure.mgmt.security.v2020_01_01.models.PublisherInfo
        :keyword common: Whether the application is commonly run on the machine.
        :paramtype common: bool
        :keyword user_sids:
        :paramtype user_sids: list[str]
        :keyword usernames:
        :paramtype usernames: list[~azure.mgmt.security.v2020_01_01.models.UserRecommendation]
        :keyword file_type: The type of the file (for Linux files - Executable is used). Known values
         are: "Exe", "Dll", "Msi", "Script", "Executable", and "Unknown".
        :paramtype file_type: str or ~azure.mgmt.security.v2020_01_01.models.FileType
        :keyword configuration_status: The configuration status of the machines group or machine or
         rule. Known values are: "Configured", "NotConfigured", "InProgress", "Failed", and "NoStatus".
        :paramtype configuration_status: str or
         ~azure.mgmt.security.v2020_01_01.models.ConfigurationStatus
        """
        super().__init__(**kwargs)
        self.path = path
        self.action = action
        self.type = type
        self.publisher_info = publisher_info
        self.common = common
        self.user_sids = user_sids
        self.usernames = usernames
        self.file_type = file_type
        self.configuration_status = configuration_status


class ProtectionMode(_serialization.Model):
    """The protection mode of the collection/file types. Exe/Msi/Script are used for Windows,
    Executable is used for Linux.

    :ivar exe: The application control policy enforcement/protection mode of the machine group.
     Known values are: "Audit", "Enforce", and "None".
    :vartype exe: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
    :ivar msi: The application control policy enforcement/protection mode of the machine group.
     Known values are: "Audit", "Enforce", and "None".
    :vartype msi: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
    :ivar script: The application control policy enforcement/protection mode of the machine group.
     Known values are: "Audit", "Enforce", and "None".
    :vartype script: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
    :ivar executable: The application control policy enforcement/protection mode of the machine
     group. Known values are: "Audit", "Enforce", and "None".
    :vartype executable: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
    """

    _attribute_map = {
        "exe": {"key": "exe", "type": "str"},
        "msi": {"key": "msi", "type": "str"},
        "script": {"key": "script", "type": "str"},
        "executable": {"key": "executable", "type": "str"},
    }

    def __init__(
        self,
        *,
        exe: Optional[Union[str, "_models.EnforcementMode"]] = None,
        msi: Optional[Union[str, "_models.EnforcementMode"]] = None,
        script: Optional[Union[str, "_models.EnforcementMode"]] = None,
        executable: Optional[Union[str, "_models.EnforcementMode"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword exe: The application control policy enforcement/protection mode of the machine group.
         Known values are: "Audit", "Enforce", and "None".
        :paramtype exe: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
        :keyword msi: The application control policy enforcement/protection mode of the machine group.
         Known values are: "Audit", "Enforce", and "None".
        :paramtype msi: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
        :keyword script: The application control policy enforcement/protection mode of the machine
         group. Known values are: "Audit", "Enforce", and "None".
        :paramtype script: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
        :keyword executable: The application control policy enforcement/protection mode of the machine
         group. Known values are: "Audit", "Enforce", and "None".
        :paramtype executable: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementMode
        """
        super().__init__(**kwargs)
        self.exe = exe
        self.msi = msi
        self.script = script
        self.executable = executable


class PublisherInfo(_serialization.Model):
    """Represents the publisher information of a process/rule.

    :ivar publisher_name: The Subject field of the x.509 certificate used to sign the code, using
     the following fields -  O = Organization, L = Locality, S = State or Province, and C = Country.
    :vartype publisher_name: str
    :ivar product_name: The product name taken from the file's version resource.
    :vartype product_name: str
    :ivar binary_name: The "OriginalName" field taken from the file's version resource.
    :vartype binary_name: str
    :ivar version: The binary file version taken from the file's version resource.
    :vartype version: str
    """

    _attribute_map = {
        "publisher_name": {"key": "publisherName", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "binary_name": {"key": "binaryName", "type": "str"},
        "version": {"key": "version", "type": "str"},
    }

    def __init__(
        self,
        *,
        publisher_name: Optional[str] = None,
        product_name: Optional[str] = None,
        binary_name: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword publisher_name: The Subject field of the x.509 certificate used to sign the code,
         using the following fields -  O = Organization, L = Locality, S = State or Province, and C =
         Country.
        :paramtype publisher_name: str
        :keyword product_name: The product name taken from the file's version resource.
        :paramtype product_name: str
        :keyword binary_name: The "OriginalName" field taken from the file's version resource.
        :paramtype binary_name: str
        :keyword version: The binary file version taken from the file's version resource.
        :paramtype version: str
        """
        super().__init__(**kwargs)
        self.publisher_name = publisher_name
        self.product_name = product_name
        self.binary_name = binary_name
        self.version = version


class Rule(_serialization.Model):
    """Describes remote addresses that is recommended to communicate with the Azure resource on some
    (Protocol, Port, Direction). All other remote addresses are recommended to be blocked.

    :ivar name: The name of the rule.
    :vartype name: str
    :ivar direction: The rule's direction. Known values are: "Inbound" and "Outbound".
    :vartype direction: str or ~azure.mgmt.security.v2020_01_01.models.Direction
    :ivar destination_port: The rule's destination port.
    :vartype destination_port: int
    :ivar protocols: The rule's transport protocols.
    :vartype protocols: list[str or ~azure.mgmt.security.v2020_01_01.models.TransportProtocol]
    :ivar ip_addresses: The remote IP addresses that should be able to communicate with the Azure
     resource on the rule's destination port and protocol.
    :vartype ip_addresses: list[str]
    """

    _validation = {
        "destination_port": {"maximum": 65535, "minimum": 0},
    }

    _attribute_map = {
        "name": {"key": "name", "type": "str"},
        "direction": {"key": "direction", "type": "str"},
        "destination_port": {"key": "destinationPort", "type": "int"},
        "protocols": {"key": "protocols", "type": "[str]"},
        "ip_addresses": {"key": "ipAddresses", "type": "[str]"},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        direction: Optional[Union[str, "_models.Direction"]] = None,
        destination_port: Optional[int] = None,
        protocols: Optional[List[Union[str, "_models.TransportProtocol"]]] = None,
        ip_addresses: Optional[List[str]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword name: The name of the rule.
        :paramtype name: str
        :keyword direction: The rule's direction. Known values are: "Inbound" and "Outbound".
        :paramtype direction: str or ~azure.mgmt.security.v2020_01_01.models.Direction
        :keyword destination_port: The rule's destination port.
        :paramtype destination_port: int
        :keyword protocols: The rule's transport protocols.
        :paramtype protocols: list[str or ~azure.mgmt.security.v2020_01_01.models.TransportProtocol]
        :keyword ip_addresses: The remote IP addresses that should be able to communicate with the
         Azure resource on the rule's destination port and protocol.
        :paramtype ip_addresses: list[str]
        """
        super().__init__(**kwargs)
        self.name = name
        self.direction = direction
        self.destination_port = destination_port
        self.protocols = protocols
        self.ip_addresses = ip_addresses


class SecureScoreControlDefinitionItem(Resource):
    """Information about the security control.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the control.
    :vartype display_name: str
    :ivar description: User friendly description of the control.
    :vartype description: str
    :ivar max_score: Maximum control score (0..10).
    :vartype max_score: int
    :ivar source: Source object from which the control was created.
    :vartype source: ~azure.mgmt.security.v2020_01_01.models.SecureScoreControlDefinitionSource
    :ivar assessment_definitions: Array of assessments metadata IDs that are included in this
     security control.
    :vartype assessment_definitions:
     list[~azure.mgmt.security.v2020_01_01.models.AzureResourceLink]
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "description": {"readonly": True, "max_length": 256},
        "max_score": {"readonly": True, "maximum": 10, "minimum": 0},
        "source": {"readonly": True},
        "assessment_definitions": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "max_score": {"key": "properties.maxScore", "type": "int"},
        "source": {"key": "properties.source", "type": "SecureScoreControlDefinitionSource"},
        "assessment_definitions": {"key": "properties.assessmentDefinitions", "type": "[AzureResourceLink]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.description = None
        self.max_score = None
        self.source = None
        self.assessment_definitions = None


class SecureScoreControlDefinitionList(_serialization.Model):
    """List of security controls definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of security controls definition in this page.
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.SecureScoreControlDefinitionItem]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecureScoreControlDefinitionItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecureScoreControlDefinitionSource(_serialization.Model):
    """The type of the security control (For example, BuiltIn).

    :ivar source_type: The type of security control (for example, BuiltIn). Known values are:
     "BuiltIn" and "Custom".
    :vartype source_type: str or ~azure.mgmt.security.v2020_01_01.models.ControlType
    """

    _attribute_map = {
        "source_type": {"key": "sourceType", "type": "str"},
    }

    def __init__(self, *, source_type: Optional[Union[str, "_models.ControlType"]] = None, **kwargs: Any) -> None:
        """
        :keyword source_type: The type of security control (for example, BuiltIn). Known values are:
         "BuiltIn" and "Custom".
        :paramtype source_type: str or ~azure.mgmt.security.v2020_01_01.models.ControlType
        """
        super().__init__(**kwargs)
        self.source_type = source_type


class SecureScoreControlDetails(Resource):  # pylint: disable=too-many-instance-attributes
    """Details of the security control, its score, and the health status of the relevant resources.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the control.
    :vartype display_name: str
    :ivar healthy_resource_count: Number of healthy resources in the control.
    :vartype healthy_resource_count: int
    :ivar unhealthy_resource_count: Number of unhealthy resources in the control.
    :vartype unhealthy_resource_count: int
    :ivar not_applicable_resource_count: Number of not applicable resources in the control.
    :vartype not_applicable_resource_count: int
    :ivar weight: The relative weight for this specific control in each of your subscriptions. Used
     when calculating an aggregated score for this control across all of your subscriptions.
    :vartype weight: int
    :ivar definition: Information about the security control.
    :vartype definition: ~azure.mgmt.security.v2020_01_01.models.SecureScoreControlDefinitionItem
    :ivar max: Maximum score available.
    :vartype max: int
    :ivar current: Current score.
    :vartype current: float
    :ivar percentage: Ratio of the current score divided by the maximum. Rounded to 4 digits after
     the decimal point.
    :vartype percentage: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "healthy_resource_count": {"readonly": True},
        "unhealthy_resource_count": {"readonly": True},
        "not_applicable_resource_count": {"readonly": True},
        "weight": {"readonly": True, "minimum": 0},
        "max": {"readonly": True, "minimum": 0},
        "current": {"readonly": True, "minimum": 0},
        "percentage": {"readonly": True, "maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "healthy_resource_count": {"key": "properties.healthyResourceCount", "type": "int"},
        "unhealthy_resource_count": {"key": "properties.unhealthyResourceCount", "type": "int"},
        "not_applicable_resource_count": {"key": "properties.notApplicableResourceCount", "type": "int"},
        "weight": {"key": "properties.weight", "type": "int"},
        "definition": {"key": "properties.definition", "type": "SecureScoreControlDefinitionItem"},
        "max": {"key": "properties.score.max", "type": "int"},
        "current": {"key": "properties.score.current", "type": "float"},
        "percentage": {"key": "properties.score.percentage", "type": "float"},
    }

    def __init__(
        self, *, definition: Optional["_models.SecureScoreControlDefinitionItem"] = None, **kwargs: Any
    ) -> None:
        """
        :keyword definition: Information about the security control.
        :paramtype definition: ~azure.mgmt.security.v2020_01_01.models.SecureScoreControlDefinitionItem
        """
        super().__init__(**kwargs)
        self.display_name = None
        self.healthy_resource_count = None
        self.unhealthy_resource_count = None
        self.not_applicable_resource_count = None
        self.weight = None
        self.definition = definition
        self.max = None
        self.current = None
        self.percentage = None


class SecureScoreControlList(_serialization.Model):
    """List of security controls.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of security controls in this page.
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.SecureScoreControlDetails]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecureScoreControlDetails]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecureScoreControlScore(_serialization.Model):
    """Calculation result data.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar max: Maximum control score (0..10).
    :vartype max: int
    :ivar current: Actual score for the control = (achieved points / total points) * max score. if
     total points is zeroed, the return number is 0.00.
    :vartype current: float
    :ivar percentage: Ratio of the current score divided by the maximum. Rounded to 4 digits after
     the decimal point.
    :vartype percentage: float
    """

    _validation = {
        "max": {"readonly": True, "maximum": 10, "minimum": 0},
        "current": {"readonly": True, "maximum": 10, "minimum": 0},
        "percentage": {"readonly": True, "maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "max": {"key": "max", "type": "int"},
        "current": {"key": "current", "type": "float"},
        "percentage": {"key": "percentage", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.max = None
        self.current = None
        self.percentage = None


class SecureScoreItem(Resource):
    """Secure score item data model.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: The initiative’s name.
    :vartype display_name: str
    :ivar weight: The relative weight for each subscription. Used when calculating an aggregated
     secure score for multiple subscriptions.
    :vartype weight: int
    :ivar max: Maximum score available.
    :vartype max: int
    :ivar current: Current score.
    :vartype current: float
    :ivar percentage: Ratio of the current score divided by the maximum. Rounded to 4 digits after
     the decimal point.
    :vartype percentage: float
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "weight": {"readonly": True, "minimum": 0},
        "max": {"readonly": True, "minimum": 0},
        "current": {"readonly": True, "minimum": 0},
        "percentage": {"readonly": True, "maximum": 1, "minimum": 0},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "weight": {"key": "properties.weight", "type": "int"},
        "max": {"key": "properties.score.max", "type": "int"},
        "current": {"key": "properties.score.current", "type": "float"},
        "percentage": {"key": "properties.score.percentage", "type": "float"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.display_name = None
        self.weight = None
        self.max = None
        self.current = None
        self.percentage = None


class SecureScoresList(_serialization.Model):
    """List of secure scores.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of secure scores in this page.
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.SecureScoreItem]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecureScoreItem]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityAssessment(Resource):
    """Security assessment on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar resource_details: Details of the resource that was assessed.
    :vartype resource_details: ~azure.mgmt.security.v2020_01_01.models.ResourceDetails
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar status: The result of the assessment.
    :vartype status: ~azure.mgmt.security.v2020_01_01.models.AssessmentStatus
    :ivar additional_data: Additional data regarding the assessment.
    :vartype additional_data: dict[str, str]
    :ivar links: Links relevant to the assessment.
    :vartype links: ~azure.mgmt.security.v2020_01_01.models.AssessmentLinks
    :ivar metadata: Describes properties of an assessment metadata.
    :vartype metadata: ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentMetadataProperties
    :ivar partners_data: Data regarding 3rd party partner integration.
    :vartype partners_data: ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentPartnerData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "display_name": {"readonly": True},
        "links": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "resource_details": {"key": "properties.resourceDetails", "type": "ResourceDetails"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "status": {"key": "properties.status", "type": "AssessmentStatus"},
        "additional_data": {"key": "properties.additionalData", "type": "{str}"},
        "links": {"key": "properties.links", "type": "AssessmentLinks"},
        "metadata": {"key": "properties.metadata", "type": "SecurityAssessmentMetadataProperties"},
        "partners_data": {"key": "properties.partnersData", "type": "SecurityAssessmentPartnerData"},
    }

    def __init__(
        self,
        *,
        resource_details: Optional["_models.ResourceDetails"] = None,
        status: Optional["_models.AssessmentStatus"] = None,
        additional_data: Optional[Dict[str, str]] = None,
        metadata: Optional["_models.SecurityAssessmentMetadataProperties"] = None,
        partners_data: Optional["_models.SecurityAssessmentPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword resource_details: Details of the resource that was assessed.
        :paramtype resource_details: ~azure.mgmt.security.v2020_01_01.models.ResourceDetails
        :keyword status: The result of the assessment.
        :paramtype status: ~azure.mgmt.security.v2020_01_01.models.AssessmentStatus
        :keyword additional_data: Additional data regarding the assessment.
        :paramtype additional_data: dict[str, str]
        :keyword metadata: Describes properties of an assessment metadata.
        :paramtype metadata:
         ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentMetadataProperties
        :keyword partners_data: Data regarding 3rd party partner integration.
        :paramtype partners_data: ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentPartnerData
        """
        super().__init__(**kwargs)
        self.resource_details = resource_details
        self.display_name = None
        self.status = status
        self.additional_data = additional_data
        self.links = None
        self.metadata = metadata
        self.partners_data = partners_data


class SecurityAssessmentList(_serialization.Model):
    """Page of a security assessments list.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: Collection of security assessments in this page.
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.SecurityAssessment]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityAssessment]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityAssessmentMetadata(Resource):  # pylint: disable=too-many-instance-attributes
    """Security assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar display_name: User friendly display name of the assessment.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.v2020_01_01.models.Categories]
    :ivar severity: The severity level of the assessment. Known values are: "Low", "Medium", and
     "High".
    :vartype severity: str or ~azure.mgmt.security.v2020_01_01.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.v2020_01_01.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or
     ~azure.mgmt.security.v2020_01_01.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.v2020_01_01.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
     "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
    :vartype assessment_type: str or ~azure.mgmt.security.v2020_01_01.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data:
     ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "policy_definition_id": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "display_name": {"key": "properties.displayName", "type": "str"},
        "policy_definition_id": {"key": "properties.policyDefinitionId", "type": "str"},
        "description": {"key": "properties.description", "type": "str"},
        "remediation_description": {"key": "properties.remediationDescription", "type": "str"},
        "categories": {"key": "properties.categories", "type": "[str]"},
        "severity": {"key": "properties.severity", "type": "str"},
        "user_impact": {"key": "properties.userImpact", "type": "str"},
        "implementation_effort": {"key": "properties.implementationEffort", "type": "str"},
        "threats": {"key": "properties.threats", "type": "[str]"},
        "preview": {"key": "properties.preview", "type": "bool"},
        "assessment_type": {"key": "properties.assessmentType", "type": "str"},
        "partner_data": {"key": "properties.partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
    }

    def __init__(
        self,
        *,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        severity: Optional[Union[str, "_models.Severity"]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        assessment_type: Optional[Union[str, "_models.AssessmentType"]] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.v2020_01_01.models.Categories]
        :keyword severity: The severity level of the assessment. Known values are: "Low", "Medium", and
         "High".
        :paramtype severity: str or ~azure.mgmt.security.v2020_01_01.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.v2020_01_01.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or
         ~azure.mgmt.security.v2020_01_01.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.v2020_01_01.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Known values are: "BuiltIn",
         "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
        :paramtype assessment_type: str or ~azure.mgmt.security.v2020_01_01.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data:
         ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentMetadataPartnerData
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data


class SecurityAssessmentMetadataList(_serialization.Model):
    """List of security assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentMetadata]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecurityAssessmentMetadata]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class SecurityAssessmentMetadataPartnerData(_serialization.Model):
    """Describes the partner that created the assessment.

    All required parameters must be populated in order to send to server.

    :ivar partner_name: Name of the company of the partner. Required.
    :vartype partner_name: str
    :ivar product_name: Name of the product of the partner that created the assessment.
    :vartype product_name: str
    :ivar secret: Secret to authenticate the partner and verify it created the assessment - write
     only. Required.
    :vartype secret: str
    """

    _validation = {
        "partner_name": {"required": True},
        "secret": {"required": True},
    }

    _attribute_map = {
        "partner_name": {"key": "partnerName", "type": "str"},
        "product_name": {"key": "productName", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, partner_name: str, secret: str, product_name: Optional[str] = None, **kwargs: Any) -> None:
        """
        :keyword partner_name: Name of the company of the partner. Required.
        :paramtype partner_name: str
        :keyword product_name: Name of the product of the partner that created the assessment.
        :paramtype product_name: str
        :keyword secret: Secret to authenticate the partner and verify it created the assessment -
         write only. Required.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.partner_name = partner_name
        self.product_name = product_name
        self.secret = secret


class SecurityAssessmentMetadataProperties(_serialization.Model):  # pylint: disable=too-many-instance-attributes
    """Describes properties of an assessment metadata.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar display_name: User friendly display name of the assessment. Required.
    :vartype display_name: str
    :ivar policy_definition_id: Azure resource ID of the policy definition that turns this
     assessment calculation on.
    :vartype policy_definition_id: str
    :ivar description: Human readable description of the assessment.
    :vartype description: str
    :ivar remediation_description: Human readable description of what you should do to mitigate
     this security issue.
    :vartype remediation_description: str
    :ivar categories:
    :vartype categories: list[str or ~azure.mgmt.security.v2020_01_01.models.Categories]
    :ivar severity: The severity level of the assessment. Required. Known values are: "Low",
     "Medium", and "High".
    :vartype severity: str or ~azure.mgmt.security.v2020_01_01.models.Severity
    :ivar user_impact: The user impact of the assessment. Known values are: "Low", "Moderate", and
     "High".
    :vartype user_impact: str or ~azure.mgmt.security.v2020_01_01.models.UserImpact
    :ivar implementation_effort: The implementation effort required to remediate this assessment.
     Known values are: "Low", "Moderate", and "High".
    :vartype implementation_effort: str or
     ~azure.mgmt.security.v2020_01_01.models.ImplementationEffort
    :ivar threats:
    :vartype threats: list[str or ~azure.mgmt.security.v2020_01_01.models.Threats]
    :ivar preview: True if this assessment is in preview release status.
    :vartype preview: bool
    :ivar assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
     Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
     "BuiltIn", "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
    :vartype assessment_type: str or ~azure.mgmt.security.v2020_01_01.models.AssessmentType
    :ivar partner_data: Describes the partner that created the assessment.
    :vartype partner_data:
     ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentMetadataPartnerData
    """

    _validation = {
        "display_name": {"required": True},
        "policy_definition_id": {"readonly": True},
        "severity": {"required": True},
        "assessment_type": {"required": True},
    }

    _attribute_map = {
        "display_name": {"key": "displayName", "type": "str"},
        "policy_definition_id": {"key": "policyDefinitionId", "type": "str"},
        "description": {"key": "description", "type": "str"},
        "remediation_description": {"key": "remediationDescription", "type": "str"},
        "categories": {"key": "categories", "type": "[str]"},
        "severity": {"key": "severity", "type": "str"},
        "user_impact": {"key": "userImpact", "type": "str"},
        "implementation_effort": {"key": "implementationEffort", "type": "str"},
        "threats": {"key": "threats", "type": "[str]"},
        "preview": {"key": "preview", "type": "bool"},
        "assessment_type": {"key": "assessmentType", "type": "str"},
        "partner_data": {"key": "partnerData", "type": "SecurityAssessmentMetadataPartnerData"},
    }

    def __init__(
        self,
        *,
        display_name: str,
        severity: Union[str, "_models.Severity"],
        assessment_type: Union[str, "_models.AssessmentType"],
        description: Optional[str] = None,
        remediation_description: Optional[str] = None,
        categories: Optional[List[Union[str, "_models.Categories"]]] = None,
        user_impact: Optional[Union[str, "_models.UserImpact"]] = None,
        implementation_effort: Optional[Union[str, "_models.ImplementationEffort"]] = None,
        threats: Optional[List[Union[str, "_models.Threats"]]] = None,
        preview: Optional[bool] = None,
        partner_data: Optional["_models.SecurityAssessmentMetadataPartnerData"] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword display_name: User friendly display name of the assessment. Required.
        :paramtype display_name: str
        :keyword description: Human readable description of the assessment.
        :paramtype description: str
        :keyword remediation_description: Human readable description of what you should do to mitigate
         this security issue.
        :paramtype remediation_description: str
        :keyword categories:
        :paramtype categories: list[str or ~azure.mgmt.security.v2020_01_01.models.Categories]
        :keyword severity: The severity level of the assessment. Required. Known values are: "Low",
         "Medium", and "High".
        :paramtype severity: str or ~azure.mgmt.security.v2020_01_01.models.Severity
        :keyword user_impact: The user impact of the assessment. Known values are: "Low", "Moderate",
         and "High".
        :paramtype user_impact: str or ~azure.mgmt.security.v2020_01_01.models.UserImpact
        :keyword implementation_effort: The implementation effort required to remediate this
         assessment. Known values are: "Low", "Moderate", and "High".
        :paramtype implementation_effort: str or
         ~azure.mgmt.security.v2020_01_01.models.ImplementationEffort
        :keyword threats:
        :paramtype threats: list[str or ~azure.mgmt.security.v2020_01_01.models.Threats]
        :keyword preview: True if this assessment is in preview release status.
        :paramtype preview: bool
        :keyword assessment_type: BuiltIn if the assessment based on built-in Azure Policy definition,
         Custom if the assessment based on custom Azure Policy definition. Required. Known values are:
         "BuiltIn", "CustomPolicy", "CustomerManaged", and "VerifiedPartner".
        :paramtype assessment_type: str or ~azure.mgmt.security.v2020_01_01.models.AssessmentType
        :keyword partner_data: Describes the partner that created the assessment.
        :paramtype partner_data:
         ~azure.mgmt.security.v2020_01_01.models.SecurityAssessmentMetadataPartnerData
        """
        super().__init__(**kwargs)
        self.display_name = display_name
        self.policy_definition_id = None
        self.description = description
        self.remediation_description = remediation_description
        self.categories = categories
        self.severity = severity
        self.user_impact = user_impact
        self.implementation_effort = implementation_effort
        self.threats = threats
        self.preview = preview
        self.assessment_type = assessment_type
        self.partner_data = partner_data


class SecurityAssessmentPartnerData(_serialization.Model):
    """Data regarding 3rd party partner integration.

    All required parameters must be populated in order to send to server.

    :ivar partner_name: Name of the company of the partner. Required.
    :vartype partner_name: str
    :ivar secret: secret to authenticate the partner - write only. Required.
    :vartype secret: str
    """

    _validation = {
        "partner_name": {"required": True},
        "secret": {"required": True},
    }

    _attribute_map = {
        "partner_name": {"key": "partnerName", "type": "str"},
        "secret": {"key": "secret", "type": "str"},
    }

    def __init__(self, *, partner_name: str, secret: str, **kwargs: Any) -> None:
        """
        :keyword partner_name: Name of the company of the partner. Required.
        :paramtype partner_name: str
        :keyword secret: secret to authenticate the partner - write only. Required.
        :paramtype secret: str
        """
        super().__init__(**kwargs)
        self.partner_name = partner_name
        self.secret = secret


class SecuritySolution(Resource, Location):
    """SecuritySolution.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar security_family: The security family of the security solution. Known values are: "Waf",
     "Ngfw", "SaasWaf", and "Va".
    :vartype security_family: str or ~azure.mgmt.security.v2020_01_01.models.SecurityFamily
    :ivar provisioning_state: The security family provisioning State. Known values are:
     "Succeeded", "Failed", and "Updating".
    :vartype provisioning_state: str or ~azure.mgmt.security.v2020_01_01.models.ProvisioningState
    :ivar template: The security solutions' template.
    :vartype template: str
    :ivar protection_status: The security solutions' status.
    :vartype protection_status: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "security_family": {"key": "properties.securityFamily", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
        "template": {"key": "properties.template", "type": "str"},
        "protection_status": {"key": "properties.protectionStatus", "type": "str"},
    }

    def __init__(
        self,
        *,
        security_family: Optional[Union[str, "_models.SecurityFamily"]] = None,
        provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = None,
        template: Optional[str] = None,
        protection_status: Optional[str] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_family: The security family of the security solution. Known values are:
         "Waf", "Ngfw", "SaasWaf", and "Va".
        :paramtype security_family: str or ~azure.mgmt.security.v2020_01_01.models.SecurityFamily
        :keyword provisioning_state: The security family provisioning State. Known values are:
         "Succeeded", "Failed", and "Updating".
        :paramtype provisioning_state: str or ~azure.mgmt.security.v2020_01_01.models.ProvisioningState
        :keyword template: The security solutions' template.
        :paramtype template: str
        :keyword protection_status: The security solutions' status.
        :paramtype protection_status: str
        """
        super().__init__(**kwargs)
        self.location = None
        self.security_family = security_family
        self.provisioning_state = provisioning_state
        self.template = template
        self.protection_status = protection_status
        self.id = None
        self.name = None
        self.type = None


class SecuritySolutionList(_serialization.Model):
    """SecuritySolutionList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.SecuritySolution]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[SecuritySolution]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, *, value: Optional[List["_models.SecuritySolution"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.SecuritySolution]
        """
        super().__init__(**kwargs)
        self.value = value
        self.next_link = None


class SecuritySolutionsReferenceData(Resource, Location):  # pylint: disable=too-many-instance-attributes
    """SecuritySolutionsReferenceData.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to server.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar security_family: The security family of the security solution. Required. Known values
     are: "Waf", "Ngfw", "SaasWaf", and "Va".
    :vartype security_family: str or ~azure.mgmt.security.v2020_01_01.models.SecurityFamily
    :ivar alert_vendor_name: The security solutions' vendor name. Required.
    :vartype alert_vendor_name: str
    :ivar package_info_url: The security solutions' package info url. Required.
    :vartype package_info_url: str
    :ivar product_name: The security solutions' product name. Required.
    :vartype product_name: str
    :ivar publisher: The security solutions' publisher. Required.
    :vartype publisher: str
    :ivar publisher_display_name: The security solutions' publisher display name. Required.
    :vartype publisher_display_name: str
    :ivar template: The security solutions' template. Required.
    :vartype template: str
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "security_family": {"required": True},
        "alert_vendor_name": {"required": True},
        "package_info_url": {"required": True},
        "product_name": {"required": True},
        "publisher": {"required": True},
        "publisher_display_name": {"required": True},
        "template": {"required": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "security_family": {"key": "properties.securityFamily", "type": "str"},
        "alert_vendor_name": {"key": "properties.alertVendorName", "type": "str"},
        "package_info_url": {"key": "properties.packageInfoUrl", "type": "str"},
        "product_name": {"key": "properties.productName", "type": "str"},
        "publisher": {"key": "properties.publisher", "type": "str"},
        "publisher_display_name": {"key": "properties.publisherDisplayName", "type": "str"},
        "template": {"key": "properties.template", "type": "str"},
    }

    def __init__(
        self,
        *,
        security_family: Union[str, "_models.SecurityFamily"],
        alert_vendor_name: str,
        package_info_url: str,
        product_name: str,
        publisher: str,
        publisher_display_name: str,
        template: str,
        **kwargs: Any
    ) -> None:
        """
        :keyword security_family: The security family of the security solution. Required. Known values
         are: "Waf", "Ngfw", "SaasWaf", and "Va".
        :paramtype security_family: str or ~azure.mgmt.security.v2020_01_01.models.SecurityFamily
        :keyword alert_vendor_name: The security solutions' vendor name. Required.
        :paramtype alert_vendor_name: str
        :keyword package_info_url: The security solutions' package info url. Required.
        :paramtype package_info_url: str
        :keyword product_name: The security solutions' product name. Required.
        :paramtype product_name: str
        :keyword publisher: The security solutions' publisher. Required.
        :paramtype publisher: str
        :keyword publisher_display_name: The security solutions' publisher display name. Required.
        :paramtype publisher_display_name: str
        :keyword template: The security solutions' template. Required.
        :paramtype template: str
        """
        super().__init__(**kwargs)
        self.location = None
        self.security_family = security_family
        self.alert_vendor_name = alert_vendor_name
        self.package_info_url = package_info_url
        self.product_name = product_name
        self.publisher = publisher
        self.publisher_display_name = publisher_display_name
        self.template = template
        self.id = None
        self.name = None
        self.type = None


class SecuritySolutionsReferenceDataList(_serialization.Model):
    """SecuritySolutionsReferenceDataList.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.SecuritySolutionsReferenceData]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[SecuritySolutionsReferenceData]"},
    }

    def __init__(
        self, *, value: Optional[List["_models.SecuritySolutionsReferenceData"]] = None, **kwargs: Any
    ) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.SecuritySolutionsReferenceData]
        """
        super().__init__(**kwargs)
        self.value = value


class ServerVulnerabilityAssessment(Resource):
    """Describes the server vulnerability assessment details on a resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: The provisioningState of the vulnerability assessment capability on
     the VM. Known values are: "Succeeded", "Failed", "Canceled", "Provisioning", and
     "Deprovisioning".
    :vartype provisioning_state: str or
     ~azure.mgmt.security.v2020_01_01.models.ServerVulnerabilityAssessmentPropertiesProvisioningState
    """

    _validation = {
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "provisioning_state": {"readonly": True},
    }

    _attribute_map = {
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "provisioning_state": {"key": "properties.provisioningState", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.provisioning_state = None


class ServerVulnerabilityAssessmentsList(_serialization.Model):
    """List of server vulnerability assessments.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.ServerVulnerabilityAssessment]
    """

    _attribute_map = {
        "value": {"key": "value", "type": "[ServerVulnerabilityAssessment]"},
    }

    def __init__(self, *, value: Optional[List["_models.ServerVulnerabilityAssessment"]] = None, **kwargs: Any) -> None:
        """
        :keyword value:
        :paramtype value: list[~azure.mgmt.security.v2020_01_01.models.ServerVulnerabilityAssessment]
        """
        super().__init__(**kwargs)
        self.value = value


class TopologyList(_serialization.Model):
    """TopologyList.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value:
    :vartype value: list[~azure.mgmt.security.v2020_01_01.models.TopologyResource]
    :ivar next_link: The URI to fetch the next page.
    :vartype next_link: str
    """

    _validation = {
        "value": {"readonly": True},
        "next_link": {"readonly": True},
    }

    _attribute_map = {
        "value": {"key": "value", "type": "[TopologyResource]"},
        "next_link": {"key": "nextLink", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.value = None
        self.next_link = None


class TopologyResource(Resource, Location):
    """TopologyResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar location: Location where the resource is stored.
    :vartype location: str
    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar calculated_date_time: The UTC time on which the topology was calculated.
    :vartype calculated_date_time: ~datetime.datetime
    :ivar topology_resources: Azure resources which are part of this topology resource.
    :vartype topology_resources:
     list[~azure.mgmt.security.v2020_01_01.models.TopologySingleResource]
    """

    _validation = {
        "location": {"readonly": True},
        "id": {"readonly": True},
        "name": {"readonly": True},
        "type": {"readonly": True},
        "calculated_date_time": {"readonly": True},
        "topology_resources": {"readonly": True},
    }

    _attribute_map = {
        "location": {"key": "location", "type": "str"},
        "id": {"key": "id", "type": "str"},
        "name": {"key": "name", "type": "str"},
        "type": {"key": "type", "type": "str"},
        "calculated_date_time": {"key": "properties.calculatedDateTime", "type": "iso-8601"},
        "topology_resources": {"key": "properties.topologyResources", "type": "[TopologySingleResource]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.location = None
        self.calculated_date_time = None
        self.topology_resources = None
        self.id = None
        self.name = None
        self.type = None


class TopologySingleResource(_serialization.Model):
    """TopologySingleResource.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: Azure resource id.
    :vartype resource_id: str
    :ivar severity: The security severity of the resource.
    :vartype severity: str
    :ivar recommendations_exist: Indicates if the resource has security recommendations.
    :vartype recommendations_exist: bool
    :ivar network_zones: Indicates the resource connectivity level to the Internet (InternetFacing,
     Internal ,etc.).
    :vartype network_zones: str
    :ivar topology_score: Score of the resource based on its security severity.
    :vartype topology_score: int
    :ivar location: The location of this resource.
    :vartype location: str
    :ivar parents: Azure resources connected to this resource which are in higher level in the
     topology view.
    :vartype parents: list[~azure.mgmt.security.v2020_01_01.models.TopologySingleResourceParent]
    :ivar children: Azure resources connected to this resource which are in lower level in the
     topology view.
    :vartype children: list[~azure.mgmt.security.v2020_01_01.models.TopologySingleResourceChild]
    """

    _validation = {
        "resource_id": {"readonly": True},
        "severity": {"readonly": True},
        "recommendations_exist": {"readonly": True},
        "network_zones": {"readonly": True},
        "topology_score": {"readonly": True},
        "location": {"readonly": True},
        "parents": {"readonly": True},
        "children": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
        "severity": {"key": "severity", "type": "str"},
        "recommendations_exist": {"key": "recommendationsExist", "type": "bool"},
        "network_zones": {"key": "networkZones", "type": "str"},
        "topology_score": {"key": "topologyScore", "type": "int"},
        "location": {"key": "location", "type": "str"},
        "parents": {"key": "parents", "type": "[TopologySingleResourceParent]"},
        "children": {"key": "children", "type": "[TopologySingleResourceChild]"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_id = None
        self.severity = None
        self.recommendations_exist = None
        self.network_zones = None
        self.topology_score = None
        self.location = None
        self.parents = None
        self.children = None


class TopologySingleResourceChild(_serialization.Model):
    """TopologySingleResourceChild.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: Azure resource id which serves as child resource in topology view.
    :vartype resource_id: str
    """

    _validation = {
        "resource_id": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_id = None


class TopologySingleResourceParent(_serialization.Model):
    """TopologySingleResourceParent.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_id: Azure resource id which serves as parent resource in topology view.
    :vartype resource_id: str
    """

    _validation = {
        "resource_id": {"readonly": True},
    }

    _attribute_map = {
        "resource_id": {"key": "resourceId", "type": "str"},
    }

    def __init__(self, **kwargs: Any) -> None:
        """ """
        super().__init__(**kwargs)
        self.resource_id = None


class UserRecommendation(_serialization.Model):
    """Represents a user that is recommended to be allowed for a certain rule.

    :ivar username: Represents a user that is recommended to be allowed for a certain rule.
    :vartype username: str
    :ivar recommendation_action: The recommendation action of the machine or rule. Known values
     are: "Recommended", "Add", and "Remove".
    :vartype recommendation_action: str or
     ~azure.mgmt.security.v2020_01_01.models.RecommendationAction
    """

    _attribute_map = {
        "username": {"key": "username", "type": "str"},
        "recommendation_action": {"key": "recommendationAction", "type": "str"},
    }

    def __init__(
        self,
        *,
        username: Optional[str] = None,
        recommendation_action: Optional[Union[str, "_models.RecommendationAction"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword username: Represents a user that is recommended to be allowed for a certain rule.
        :paramtype username: str
        :keyword recommendation_action: The recommendation action of the machine or rule. Known values
         are: "Recommended", "Add", and "Remove".
        :paramtype recommendation_action: str or
         ~azure.mgmt.security.v2020_01_01.models.RecommendationAction
        """
        super().__init__(**kwargs)
        self.username = username
        self.recommendation_action = recommendation_action


class VmRecommendation(_serialization.Model):
    """Represents a machine that is part of a machine group.

    :ivar configuration_status: The configuration status of the machines group or machine or rule.
     Known values are: "Configured", "NotConfigured", "InProgress", "Failed", and "NoStatus".
    :vartype configuration_status: str or
     ~azure.mgmt.security.v2020_01_01.models.ConfigurationStatus
    :ivar recommendation_action: The recommendation action of the machine or rule. Known values
     are: "Recommended", "Add", and "Remove".
    :vartype recommendation_action: str or
     ~azure.mgmt.security.v2020_01_01.models.RecommendationAction
    :ivar resource_id: The full resource id of the machine.
    :vartype resource_id: str
    :ivar enforcement_support: The machine supportability of Enforce feature. Known values are:
     "Supported", "NotSupported", and "Unknown".
    :vartype enforcement_support: str or ~azure.mgmt.security.v2020_01_01.models.EnforcementSupport
    """

    _attribute_map = {
        "configuration_status": {"key": "configurationStatus", "type": "str"},
        "recommendation_action": {"key": "recommendationAction", "type": "str"},
        "resource_id": {"key": "resourceId", "type": "str"},
        "enforcement_support": {"key": "enforcementSupport", "type": "str"},
    }

    def __init__(
        self,
        *,
        configuration_status: Optional[Union[str, "_models.ConfigurationStatus"]] = None,
        recommendation_action: Optional[Union[str, "_models.RecommendationAction"]] = None,
        resource_id: Optional[str] = None,
        enforcement_support: Optional[Union[str, "_models.EnforcementSupport"]] = None,
        **kwargs: Any
    ) -> None:
        """
        :keyword configuration_status: The configuration status of the machines group or machine or
         rule. Known values are: "Configured", "NotConfigured", "InProgress", "Failed", and "NoStatus".
        :paramtype configuration_status: str or
         ~azure.mgmt.security.v2020_01_01.models.ConfigurationStatus
        :keyword recommendation_action: The recommendation action of the machine or rule. Known values
         are: "Recommended", "Add", and "Remove".
        :paramtype recommendation_action: str or
         ~azure.mgmt.security.v2020_01_01.models.RecommendationAction
        :keyword resource_id: The full resource id of the machine.
        :paramtype resource_id: str
        :keyword enforcement_support: The machine supportability of Enforce feature. Known values are:
         "Supported", "NotSupported", and "Unknown".
        :paramtype enforcement_support: str or
         ~azure.mgmt.security.v2020_01_01.models.EnforcementSupport
        """
        super().__init__(**kwargs)
        self.configuration_status = configuration_status
        self.recommendation_action = recommendation_action
        self.resource_id = resource_id
        self.enforcement_support = enforcement_support
